/*
 * Decompiled with CFR 0.152.
 */
package xyz.lunala.meowstorage.datagen;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.crafting.conditions.IConditionBuilder;
import xyz.lunala.meowstorage.init.ItemInit;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(pOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> pWriter) {
        ModRecipeProvider.generateChests(pWriter);
        ModRecipeProvider.generateBarrels(pWriter);
        ModRecipeProvider.generateBackpacks(pWriter);
        ModRecipeProvider.filledRecipe(pWriter, RecipeCategory.REDSTONE, (ItemLike)ItemInit.LINKER_OUTPUT_ITEM.get(), (ItemLike)Items.f_42594_.m_5456_(), (ItemLike)Items.f_42584_.m_5456_(), "has_container_linker", "container_linker_output");
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)((ItemLike)ItemInit.CONTAINER_LINKER_ITEM.get())).m_126130_("RDR").m_126130_("COC").m_126130_("RPR").m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42594_).m_126127_(Character.valueOf('O'), (ItemLike)ItemInit.LINKER_OUTPUT_ITEM.get()).m_126127_(Character.valueOf('R'), (ItemLike)Items.f_42451_).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42415_).m_126127_(Character.valueOf('P'), (ItemLike)Items.f_42584_).m_126132_("has_cobblestone", (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)Items.f_42594_)).m_176500_(pWriter, "meowstorage:asdfawesdfaw_container_linker");
    }

    protected static void fullRecipe(Consumer<FinishedRecipe> recipeOutput, RecipeCategory category, ItemLike result, ItemLike input, String unlockName, String recipeName) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)category, (ItemLike)result).m_126130_("BBB").m_126130_("BBB").m_126130_("BBB").m_126127_(Character.valueOf('B'), input).m_126132_(unlockName, (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)input)).m_176500_(recipeOutput, "meowstorage:" + recipeName);
    }

    protected static void donutRecipe(Consumer<FinishedRecipe> recipeOutput, RecipeCategory category, ItemLike result, ItemLike input, String unlockName, String recipeName) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)category, (ItemLike)result).m_126130_("BBB").m_126130_("B B").m_126130_("BBB").m_126127_(Character.valueOf('B'), input).m_126132_(unlockName, (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)input)).m_176500_(recipeOutput, "meowstorage:" + recipeName);
    }

    protected static void filledRecipe(Consumer<FinishedRecipe> recipeOutput, RecipeCategory category, ItemLike result, ItemLike input, ItemLike centerItem, String unlockName, String recipeName) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)category, (ItemLike)result).m_126130_("BBB").m_126130_("BAB").m_126130_("BBB").m_126127_(Character.valueOf('B'), input).m_126127_(Character.valueOf('A'), centerItem).m_126132_(unlockName, (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)input)).m_176500_(recipeOutput, "meowstorage:" + recipeName);
    }

    protected static void compressedItemRecipe(Consumer<FinishedRecipe> recipeOutput, RecipeCategory category, ItemLike compressedBlock, ItemLike item, String unlockName, String recipeName) {
        ModRecipeProvider.fullRecipe(recipeOutput, category, compressedBlock, item, unlockName, recipeName + "_compressed");
        ShapelessRecipeBuilder.m_246517_((RecipeCategory)category, (ItemLike)item, (int)9).m_126209_(compressedBlock).m_126132_(recipeName, (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)item)).m_176500_(recipeOutput, "meowstorage" + recipeName + "_un_compressed");
    }

    protected static void smithingUpgrade(Consumer<FinishedRecipe> recipeOutput, ItemLike template, ItemLike base, ItemLike addition, Item result) {
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{template}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{base}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{addition}), (RecipeCategory)RecipeCategory.MISC, (Item)result).m_266439_("has_" + String.valueOf(addition), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)addition)).m_266260_(recipeOutput, "meowstorage:" + String.valueOf(result) + "_smithing");
    }

    protected static void chestFromMaterial(Consumer<FinishedRecipe> recipeOutput, ItemLike chest, ItemLike material, ItemLike base, String unlockName) {
        ModRecipeProvider.filledRecipe(recipeOutput, RecipeCategory.REDSTONE, chest, material, base, unlockName, chest.toString() + "_from_" + material.toString());
    }

    protected static void generateChests(Consumer<FinishedRecipe> recipeOutput) {
        Tuple[] items = new Tuple[]{new Tuple(ItemInit.COPPER_CHEST_ITEM.get(), (Object)Items.f_151052_), new Tuple(ItemInit.IRON_CHEST_ITEM.get(), (Object)Items.f_42416_), new Tuple(ItemInit.GOLD_CHEST_ITEM.get(), (Object)Items.f_42417_), new Tuple(ItemInit.DIAMOND_CHEST_ITEM.get(), (Object)Items.f_42415_)};
        Item base = Items.f_42009_;
        for (Tuple pair : items) {
            ModRecipeProvider.chestFromMaterial(recipeOutput, (ItemLike)pair.m_14418_(), (ItemLike)pair.m_14419_(), (ItemLike)base, "has_" + String.valueOf(pair.m_14418_()));
            base = (ItemLike)pair.m_14418_();
        }
        ModRecipeProvider.smithingUpgrade(recipeOutput, (ItemLike)Items.f_265918_, (ItemLike)ItemInit.DIAMOND_CHEST_ITEM.get(), (ItemLike)Items.f_42418_, (Item)ItemInit.NETHERITE_CHEST_ITEM.get());
    }

    protected static void generateBarrels(Consumer<FinishedRecipe> recipeOutput) {
        Tuple[] items = new Tuple[]{new Tuple(ItemInit.COPPER_BARREL_ITEM.get(), (Object)Items.f_151052_), new Tuple(ItemInit.IRON_BARREL_ITEM.get(), (Object)Items.f_42416_), new Tuple(ItemInit.GOLD_BARREL_ITEM.get(), (Object)Items.f_42417_), new Tuple(ItemInit.DIAMOND_BARREL_ITEM.get(), (Object)Items.f_42415_)};
        Item base = Items.f_42009_;
        for (Tuple pair : items) {
            ModRecipeProvider.chestFromMaterial(recipeOutput, (ItemLike)pair.m_14418_(), (ItemLike)pair.m_14419_(), (ItemLike)base, "has_" + String.valueOf(pair.m_14418_()));
            base = (ItemLike)pair.m_14418_();
        }
        ModRecipeProvider.smithingUpgrade(recipeOutput, (ItemLike)Items.f_265918_, (ItemLike)ItemInit.DIAMOND_BARREL_ITEM.get(), (ItemLike)Items.f_42418_, (Item)ItemInit.NETHERITE_BARREL_ITEM.get());
    }

    protected static void generateBackpacks(Consumer<FinishedRecipe> recipeOutput) {
        ModRecipeProvider.backpackFrom(recipeOutput, (ItemLike)Items.f_42009_.m_5456_(), (ItemLike)Items.f_42454_.m_5456_(), (ItemLike)ItemInit.SMALL_BACKPACK_ITEM.get(), "small_backpack");
        ModRecipeProvider.backpackFrom(recipeOutput, (ItemLike)ItemInit.SMALL_BACKPACK_ITEM.get(), (ItemLike)ItemInit.COPPER_CHEST_ITEM.get(), (ItemLike)ItemInit.MID_BACKPACK_ITEM.get(), "mid_backpack");
        ModRecipeProvider.backpackFrom(recipeOutput, (ItemLike)ItemInit.MID_BACKPACK_ITEM.get(), (ItemLike)ItemInit.IRON_CHEST_ITEM.get(), (ItemLike)ItemInit.BIG_BACKPACK_ITEM.get(), "big_backpack");
    }

    protected static void backpackFrom(Consumer<FinishedRecipe> recipeOutput, ItemLike centerPiece, ItemLike upgrade, ItemLike result, String recipeName) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.REDSTONE, (ItemLike)result).m_126130_("CDC").m_126130_("DAD").m_126130_("DBD").m_126127_(Character.valueOf('B'), upgrade).m_126127_(Character.valueOf('A'), centerPiece).m_126127_(Character.valueOf('C'), (ItemLike)Items.f_42401_).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42454_).m_126132_("has_" + String.valueOf(upgrade.m_5456_().m_7968_().m_41611_()), (CriterionTriggerInstance)ModRecipeProvider.m_125977_((ItemLike)upgrade)).m_176500_(recipeOutput, "meowstorage:" + recipeName + "_your_mom");
    }
}

