/*
 * Decompiled with CFR 0.152.
 */
package xyz.lunala.meowstorage.events;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.lunala.meowstorage.block.barrels.MeowBarrelBase;
import xyz.lunala.meowstorage.init.EntityInit;
import xyz.lunala.meowstorage.util.InteractionHelper;

@Mod.EventBusSubscriber(modid="meowstorage")
public class CommonEvents {
    @SubscribeEvent
    public static void entityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)EntityInit.CALICO_CAT.get(), Cat.m_28168_().m_22265_());
    }

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        BlockPos pPos = event.getPos();
        Level pLevel = event.getLevel();
        BlockState pState = pLevel.m_8055_(pPos);
        Block pBlock = pState.m_60734_();
        Player pPlayer = event.getEntity();
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        if (!event.getAction().equals((Object)PlayerInteractEvent.LeftClickBlock.Action.START)) {
            return;
        }
        if (!(pBlock instanceof MeowBarrelBase)) {
            return;
        }
        MeowBarrelBase barrelBase = (MeowBarrelBase)pBlock;
        if (!pPlayer.m_7500_()) {
            return;
        }
        if (InteractionHelper.playerClickedFacingFace(pPos, pLevel, pState, pPlayer)) {
            return;
        }
        event.setCanceled(true);
        if (!pLevel.m_5776_()) {
            barrelBase.takeItem(pState, (LevelAccessor)pLevel, pPos, pPlayer);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pPos = event.getPos();
        Player pPlayer = event.getEntity();
        if (!pPlayer.m_6144_()) {
            return;
        }
        Level pLevel = event.getLevel();
        BlockState pState = pLevel.m_8055_(pPos);
        InteractionHand pHand = event.getHand();
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        Block block = pState.m_60734_();
        if (!(block instanceof MeowBarrelBase)) {
            return;
        }
        MeowBarrelBase barrelBase = (MeowBarrelBase)block;
        Vec3 eyePos = pPlayer.m_20299_(1.0f);
        Vec3 lookVector = pPlayer.m_20252_(1.0f);
        Vec3 endPos = eyePos.m_82549_(lookVector.m_82490_(eyePos.m_82554_(Vec3.m_82512_((Vec3i)pPos)) + 1.0));
        ClipContext context = new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)pPlayer);
        BlockHitResult pHit = pLevel.m_45547_(context);
        InteractionResult result = barrelBase.m_6227_(pState, pLevel, pPos, pPlayer, pHand, pHit);
        event.setCanceled(result.m_19077_());
    }
}

