/*
 * Decompiled with CFR 0.152.
 */
package xyz.lunala.meowstorage.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Quaternionf;
import xyz.lunala.meowstorage.block.backpacks.BigBackpack;
import xyz.lunala.meowstorage.block.backpacks.MidBackpack;
import xyz.lunala.meowstorage.block.backpacks.SmallBackpack;
import xyz.lunala.meowstorage.init.BlockInit;
import xyz.lunala.meowstorage.init.ItemInit;

@OnlyIn(value=Dist.CLIENT)
public class BackpackRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public BackpackRenderer(RenderLayerParent pRenderer) {
        super(pRenderer);
    }

    public void render(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, AbstractClientPlayer pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ItemStack stack = pLivingEntity.m_6844_(EquipmentSlot.CHEST);
        if (stack.m_150930_((Item)ItemInit.SMALL_BACKPACK_ITEM.get())) {
            this.renderSmallPack(pPoseStack, pBuffer, pPackedLight, pLivingEntity, stack, pPartialTick);
        } else if (stack.m_150930_((Item)ItemInit.MID_BACKPACK_ITEM.get())) {
            this.renderMidPack(pPoseStack, pBuffer, pPackedLight, pLivingEntity, stack, pPartialTick);
        } else if (stack.m_150930_((Item)ItemInit.BIG_BACKPACK_ITEM.get())) {
            this.renderBigPack(pPoseStack, pBuffer, pPackedLight, pLivingEntity, stack, pPartialTick);
        }
    }

    private void renderSmallPack(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, AbstractClientPlayer pLivingEntity, ItemStack stack, float pPartialTick) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, 0.0, 0.16);
        pPoseStack.m_252781_(new Quaternionf().rotateLocalX((float)Math.toRadians(180.0)));
        pPoseStack.m_252781_(new Quaternionf().rotateLocalY((float)Math.toRadians(180.0)));
        pPoseStack.m_85837_(-0.5, -0.6, -0.1);
        if (pLivingEntity.m_6047_()) {
            pPoseStack.m_252781_(new Quaternionf().rotateLocalX((float)Math.toRadians(-29.5)));
            pPoseStack.m_85837_(0.0, -0.2, 0.2);
        }
        Minecraft.m_91087_().m_91289_().renderSingleBlock(((SmallBackpack)((Object)BlockInit.SMALL_BACKPACK.get())).m_49966_(), pPoseStack, pBuffer, pPackedLight, OverlayTexture.f_118083_, ModelData.builder().build(), RenderType.m_110451_());
        pPoseStack.m_85849_();
    }

    private void renderMidPack(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, AbstractClientPlayer pLivingEntity, ItemStack stack, float pPartialTick) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, 0.0, 0.16);
        pPoseStack.m_252781_(new Quaternionf().rotateLocalX((float)Math.toRadians(180.0)));
        pPoseStack.m_252781_(new Quaternionf().rotateLocalY((float)Math.toRadians(180.0)));
        pPoseStack.m_85837_(-0.5, -0.7, -0.1);
        if (pLivingEntity.m_6047_()) {
            pPoseStack.m_252781_(new Quaternionf().rotateLocalX((float)Math.toRadians(-29.5)));
            pPoseStack.m_85837_(0.0, -0.2, 0.25);
        }
        Minecraft.m_91087_().m_91289_().renderSingleBlock(((MidBackpack)((Object)BlockInit.MID_BACKPACK.get())).m_49966_(), pPoseStack, pBuffer, pPackedLight, OverlayTexture.f_118083_, ModelData.builder().build(), RenderType.m_110451_());
        pPoseStack.m_85849_();
    }

    private void renderBigPack(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, AbstractClientPlayer pLivingEntity, ItemStack stack, float pPartialTick) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.0, 0.0, 0.16);
        pPoseStack.m_252781_(new Quaternionf().rotateLocalX((float)Math.toRadians(180.0)));
        pPoseStack.m_252781_(new Quaternionf().rotateLocalY((float)Math.toRadians(180.0)));
        pPoseStack.m_85837_(-0.5, -0.8, -0.1);
        if (pLivingEntity.m_6047_()) {
            pPoseStack.m_252781_(new Quaternionf().rotateLocalX((float)Math.toRadians(-29.5)));
            pPoseStack.m_85837_(0.0, -0.2, 0.3);
        }
        Minecraft.m_91087_().m_91289_().renderSingleBlock(((BigBackpack)((Object)BlockInit.BIG_BACKPACK.get())).m_49966_(), pPoseStack, pBuffer, pPackedLight, OverlayTexture.f_118083_, ModelData.builder().build(), RenderType.m_110451_());
        pPoseStack.m_85849_();
    }
}

