/*
 * Decompiled with CFR 0.152.
 */
package xyz.lunala.meowstorage.screen;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.items.SlotItemHandler;
import xyz.lunala.meowstorage.Meowstorage;
import xyz.lunala.meowstorage.menu.ChestMenu;
import xyz.lunala.meowstorage.util.IMovableSlot;

public class ChestMenuScreen
extends AbstractContainerScreen<ChestMenu> {
    private static final ResourceLocation BIG_BACKGROUND = ResourceLocation.parse((String)"meowstorage:textures/gui/big_chest_menu.png");
    private static final ResourceLocation SMALL_BACKGROUND = ResourceLocation.parse((String)"meowstorage:textures/gui/small_chest_menu.png");
    private static final int VISIBLE_ROWS = 6;
    private static final int SLOT_COLS = 9;
    private final int totalRows = (int)Math.ceil(this.getInventorySlots() / 9.0) - 4;
    private final int playerInventoryRows = 4;
    private int scrollOffset = 4;
    private boolean needsScrollbar = false;
    private int scrollBarLeft = 177;
    private int scrollBarTop = 3;
    private int scrollBarWidth = 15;
    private int scrollBarHeight = 122;
    private int floaterLeft = 194;
    private int floaterTop = 7;
    private int floaterWidth = 7;
    private int floaterHeight = 15;
    private boolean floaterDragged = false;
    private int floaterUpperLimit = 7;
    private int floaterLowerLimit = 106;

    public ChestMenuScreen(ChestMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 176;
        this.f_97727_ = this.totalRows > 3 ? 220 : 166;
        this.f_97731_ = this.totalRows > 3 ? 127 : 73;
        this.needsScrollbar = Math.max(0, this.totalRows - 6) > 0;
        this.rearrange();
    }

    protected void m_7856_() {
        super.m_7856_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int maxOffset = Math.max(0, this.totalRows - 6);
        if (maxOffset > 0) {
            this.scrollOffset -= (int)Math.signum(delta);
            if (this.scrollOffset < 4) {
                this.scrollOffset = 4;
            } else if (this.scrollOffset > maxOffset) {
                this.scrollOffset = maxOffset;
            }
        }
        this.rearrange();
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void rearrange() {
        if (!this.needsScrollbar) {
            return;
        }
        int i = 36;
        while ((double)i < this.getInventorySlots()) {
            int row = i / 9;
            int col = i % 9;
            SlotItemHandler slot = (SlotItemHandler)((ChestMenu)this.f_97732_).f_38839_.get(i);
            if (!(slot instanceof IMovableSlot)) {
                Meowstorage.getLogger().error("Expected IMovableSlot but got " + slot.getClass().getCanonicalName());
                Meowstorage.getLogger().error("Game prolly ate the throw!");
                throw new IllegalStateException("Expected IMovableSlot but got " + slot.getClass().getCanonicalName());
            }
            if (row >= this.scrollOffset && row < this.scrollOffset + 6) {
                int slotX = 8 + col * 18;
                int slotY = 18 + (row - this.scrollOffset) * 18;
                ((IMovableSlot)slot).meowstorage$setX(slotX);
                ((IMovableSlot)slot).meowstorage$setY(slotY);
            } else {
                ((IMovableSlot)slot).meowstorage$setX(-1000);
                ((IMovableSlot)slot).meowstorage$setY(-1000);
            }
            ++i;
        }
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280218_(this.getAppropriateBackground(), this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        if (this.needsScrollbar) {
            guiGraphics.m_280218_(BIG_BACKGROUND, this.f_97735_ + this.scrollBarLeft, this.f_97736_ + this.scrollBarTop, this.scrollBarLeft, this.scrollBarTop, this.scrollBarWidth, this.scrollBarHeight);
            int floaterOffset = (int)((double)(this.scrollOffset - 4) / (double)(this.totalRows - 6 - 4) * (double)(this.floaterLowerLimit - this.floaterUpperLimit));
            if (this.floaterDragged) {
                floaterOffset = mouseY - (int)((double)this.floaterHeight * 1.5);
            }
            if (floaterOffset < 0) {
                floaterOffset = 0;
            } else if (floaterOffset > 99) {
                floaterOffset = 99;
            }
            guiGraphics.m_280218_(BIG_BACKGROUND, this.f_97735_ + 181, this.f_97736_ + this.floaterTop + floaterOffset, this.floaterLeft, this.floaterTop, this.floaterWidth, this.floaterHeight);
        }
    }

    private ResourceLocation getAppropriateBackground() {
        if (this.totalRows > 3) {
            return BIG_BACKGROUND;
        }
        return SMALL_BACKGROUND;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        int floaterOffset = (int)((double)(this.scrollOffset - 4) / (double)(this.totalRows - 6 - 4) * (double)(this.floaterLowerLimit - this.floaterUpperLimit));
        if (this.m_6774_(181, this.floaterTop + floaterOffset, this.floaterWidth, this.floaterHeight, pMouseX, pMouseY)) {
            this.floaterDragged = true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        this.floaterDragged = false;
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.floaterDragged) {
            this.updateFloater(pMouseY);
            this.rearrange();
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private void updateFloater(double pMouseY) {
        int maxOffset = Math.max(0, this.totalRows - 6);
        this.scrollOffset = (int)Math.round((pMouseY - (double)(this.f_97736_ + this.floaterTop)) / (double)(this.floaterLowerLimit - this.floaterUpperLimit) * (double)(this.totalRows - 6));
        if (this.scrollOffset < 4) {
            this.scrollOffset = 4;
        } else if (this.scrollOffset > maxOffset) {
            this.scrollOffset = maxOffset;
        }
    }

    private double getInventorySlots() {
        return ((ChestMenu)this.f_97732_).f_38839_.size();
    }
}

