/*
 * Decompiled with CFR 0.152.
 */
package xyz.lunala.meowstorage.block.barrels;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.lunala.meowstorage.block.entity.MeowBarrelEntityBase;
import xyz.lunala.meowstorage.util.InteractionHelper;

public abstract class MeowBarrelBase
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public MeowBarrelBase(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected abstract BlockEntityType<?> getBlockEntityType();

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return this.getBlockEntityType().m_155264_(blockPos, blockState);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    protected void m_7926_(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (pLevel.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        if (!direction.equals((Object)pHit.m_82434_())) {
            return InteractionResult.PASS;
        }
        return this.putItem(pState, (LevelAccessor)pLevel, pPos, pPlayer, pPlayer.m_21120_(pHand));
    }

    public void m_6256_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        if (pLevel.f_46443_) {
            return;
        }
        if (InteractionHelper.playerClickedFacingFace(pPos, pLevel, pState, pPlayer)) {
            return;
        }
        this.takeItem(pState, (LevelAccessor)pLevel, pPos, pPlayer);
    }

    public InteractionResult takeItem(BlockState pState, LevelAccessor pLevel, BlockPos pPos, Player pPlayer) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof MeowBarrelEntityBase)) {
            return InteractionResult.PASS;
        }
        MeowBarrelEntityBase meowBarrelEntityBase = (MeowBarrelEntityBase)blockEntity;
        boolean isShiftDown = pPlayer.m_6144_();
        ItemStack itemStack = meowBarrelEntityBase.takeItem(isShiftDown ? 64 : 1);
        if (!pPlayer.m_150109_().m_36054_(itemStack)) {
            Containers.m_18992_((Level)pPlayer.m_9236_(), (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (ItemStack)itemStack);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResult putItem(BlockState pState, LevelAccessor pLevel, BlockPos pPos, Player pPlayer, ItemStack pStack) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (!(blockEntity instanceof MeowBarrelEntityBase)) {
            return InteractionResult.PASS;
        }
        MeowBarrelEntityBase meowBarrelEntityBase = (MeowBarrelEntityBase)blockEntity;
        boolean isShiftDown = pPlayer.m_6144_();
        int shrink = meowBarrelEntityBase.putItem(pStack, isShiftDown ? 64 : 1);
        pStack.m_41774_(shrink);
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        if (pLevel.f_46443_) {
            return;
        }
        if (pStack.m_41619_()) {
            return;
        }
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof MeowBarrelEntityBase) {
            MeowBarrelEntityBase meowBarrelEntityBase = (MeowBarrelEntityBase)blockEntity;
            meowBarrelEntityBase.m_142466_(pStack.m_41784_());
        }
    }
}

