/*
 * Decompiled with CFR 0.152.
 */
package xyz.lunala.meowstorage.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MeowBarrelEntityBase
extends BlockEntity
implements Container {
    protected ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            MeowBarrelEntityBase.this.m_6596_();
            assert (MeowBarrelEntityBase.this.f_58857_ != null);
            if (MeowBarrelEntityBase.this.f_58857_.m_5776_()) {
                return;
            }
            MeowBarrelEntityBase.this.f_58857_.m_7260_(MeowBarrelEntityBase.this.m_58899_(), MeowBarrelEntityBase.this.m_58900_(), MeowBarrelEntityBase.this.m_58900_(), 3);
        }
    };
    protected LazyOptional<ItemStackHandler> inventoryOptional;
    protected final int maxStackSize;

    public MeowBarrelEntityBase(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState, int stackSize, String material) {
        super(pType, pPos, pBlockState);
        this.maxStackSize = stackSize;
        this.inventoryOptional = LazyOptional.of(() -> this.inventory);
    }

    public int m_6643_() {
        return this.inventory.getSlots();
    }

    public boolean m_7983_() {
        return this.inventory.getStackInSlot(0).m_41619_();
    }

    public ItemStack m_8020_(int pSlot) {
        return this.inventory.getStackInSlot(pSlot);
    }

    public ItemStack getRenderStack() {
        ItemStack stack = this.inventory.getStackInSlot(0);
        return stack.m_41619_() ? ItemStack.f_41583_ : stack.m_255036_(1);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        return this.inventory.extractItem(pSlot, pAmount, false);
    }

    public ItemStack m_8016_(int pSlot) {
        return this.m_7407_(pSlot, 1);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        this.inventory.setStackInSlot(pSlot, pStack);
    }

    public boolean m_6542_(Player pPlayer) {
        return false;
    }

    public void m_6211_() {
        this.inventory.setStackInSlot(0, ItemStack.f_41583_);
    }

    public ItemStack takeItem(int i) {
        ItemStack itemStack = this.inventory.getStackInSlot(0);
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack result = itemStack.m_255036_(i);
        itemStack.m_41774_(i);
        if (itemStack.m_41613_() <= 0) {
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        } else {
            this.inventory.setStackInSlot(0, itemStack);
        }
        return result;
    }

    public int putItem(ItemStack itemStack, int count) {
        int decrement = Math.min(count, itemStack.m_41613_());
        return this.putItem(itemStack.m_255036_(decrement = Math.min(decrement, this.maxStackSize - this.inventory.getStackInSlot(0).m_41613_()))) ? decrement : 0;
    }

    public boolean putItem(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return false;
        }
        ItemStack currentStack = this.inventory.getStackInSlot(0);
        if (currentStack.m_41619_()) {
            this.inventory.setStackInSlot(0, itemStack.m_41777_());
            return true;
        }
        if (currentStack.m_41720_() != itemStack.m_41720_()) {
            return false;
        }
        if (currentStack.m_41613_() + itemStack.m_41613_() > this.maxStackSize) {
            return false;
        }
        currentStack.m_41764_(currentStack.m_41613_() + itemStack.m_41613_());
        return true;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        CompoundTag inventoryTag = new CompoundTag();
        ItemStack itemStack = this.inventory.getStackInSlot(0);
        inventoryTag.m_128365_("item", (Tag)itemStack.m_255036_(1).serializeNBT());
        inventoryTag.m_128405_("count", itemStack.m_41613_());
        pTag.m_128365_("barrel_inv", (Tag)inventoryTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        if (pTag.m_128441_("barrel_inv")) {
            CompoundTag inventoryTag = pTag.m_128469_("barrel_inv");
            if (inventoryTag.m_128441_("item")) {
                ItemStack itemStack = ItemStack.m_41712_((CompoundTag)inventoryTag.m_128469_("item"));
                int count = inventoryTag.m_128451_("count");
                this.inventory.setStackInSlot(0, itemStack);
                itemStack.m_41764_(count);
            } else {
                this.inventory.setStackInSlot(0, ItemStack.f_41583_);
            }
        } else {
            this.inventory.setStackInSlot(0, ItemStack.f_41583_);
        }
    }

    public void m_187476_(ItemStack pStack) {
        super.m_187476_(pStack);
        CompoundTag tag = pStack.m_41784_();
        this.m_183515_(tag);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.inventoryOptional.cast() : LazyOptional.empty().cast();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.inventoryOptional.cast() : LazyOptional.empty().cast();
    }
}

