/*
 * Decompiled with CFR 0.152.
 */
package xyz.lunala.meowstorage.block.entity.linker;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.lunala.meowstorage.block.containers.MeowContainerEntity;
import xyz.lunala.meowstorage.block.linker.ContainerLinkerOutputBlock;
import xyz.lunala.meowstorage.init.BlockEntityInit;

public class ContainerLinkerOutputBlockEntity
extends BlockEntity {
    private BlockPos likedTo = new BlockPos(0, 0, 0);
    private LazyOptional<?> optional = LazyOptional.empty();

    public ContainerLinkerOutputBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityInit.LINKER_OUTPUT.get(), pPos, pBlockState);
    }

    public BlockPos getLikedTo() {
        return this.likedTo;
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        CompoundTag linkedToTag = new CompoundTag();
        if (this.likedTo != null) {
            linkedToTag.m_128405_("x", this.likedTo.m_123341_());
            linkedToTag.m_128405_("y", this.likedTo.m_123342_());
            linkedToTag.m_128405_("z", this.likedTo.m_123343_());
        }
        pTag.m_128365_("linked_to", (Tag)linkedToTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        CompoundTag linkedToTag = pTag.m_128469_("linked_to");
        if (!linkedToTag.m_128456_()) {
            int x = linkedToTag.m_128451_("x");
            int y = linkedToTag.m_128451_("y");
            int z = linkedToTag.m_128451_("z");
            this.likedTo = new BlockPos(x, y, z);
        } else {
            this.likedTo = new BlockPos(0, 0, 0);
        }
    }

    public void setLikedTo(BlockPos blockPos) {
        this.likedTo = blockPos;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.getOptional().cast() : LazyOptional.empty().cast();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return this.getCapability(cap);
    }

    private LazyOptional<?> getOptional() {
        return this.optional;
    }

    public <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        BlockEntity entityBelow = level.m_7702_(this.getLikedTo().m_7495_());
        if (!(blockEntity instanceof ContainerLinkerOutputBlockEntity)) {
            this.optional = LazyOptional.empty();
            state.m_61124_(ContainerLinkerOutputBlock.LINKSTATUS, (Comparable)((Object)ContainerLinkerOutputBlock.LinkStatus.UNLINKED));
            this.m_6596_();
            return;
        }
        ContainerLinkerOutputBlockEntity linkerOutputBlockEntity = (ContainerLinkerOutputBlockEntity)blockEntity;
        if (!(entityBelow instanceof MeowContainerEntity)) {
            this.optional = LazyOptional.empty();
            state.m_61124_(ContainerLinkerOutputBlock.LINKSTATUS, (Comparable)((Object)ContainerLinkerOutputBlock.LinkStatus.UNLINKED));
            this.m_6596_();
            return;
        }
        MeowContainerEntity meowContainerEntity = (MeowContainerEntity)entityBelow;
        this.optional = meowContainerEntity.getOptional();
        state.m_61124_(ContainerLinkerOutputBlock.LINKSTATUS, (Comparable)((Object)ContainerLinkerOutputBlock.LinkStatus.LINKED));
        this.m_6596_();
    }
}

