/*
 * Decompiled with CFR 0.152.
 */
package xyz.lunala.meowstorage.block.linker;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.lunala.meowstorage.block.entity.linker.ContainerLinkerOutputBlockEntity;
import xyz.lunala.meowstorage.init.BlockEntityInit;

public class ContainerLinkerOutputBlock
extends Block
implements EntityBlock {
    public static final EnumProperty<LinkStatus> LINKSTATUS = EnumProperty.m_61587_((String)"link_status", LinkStatus.class);

    public ContainerLinkerOutputBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(LINKSTATUS, (Comparable)((Object)LinkStatus.UNLINKED)));
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        CompoundTag linkedToTag = pStack.m_41737_("linked_to");
        if (linkedToTag != null) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof ContainerLinkerOutputBlockEntity) {
                ContainerLinkerOutputBlockEntity linkerOutputBlockEntity = (ContainerLinkerOutputBlockEntity)blockEntity;
                int x = linkedToTag.m_128451_("x");
                int y = linkedToTag.m_128451_("y");
                int z = linkedToTag.m_128451_("z");
                linkerOutputBlockEntity.setLikedTo(new BlockPos(x, y, z));
                pLevel.m_7731_(pPos, (BlockState)pState.m_61124_(LINKSTATUS, (Comparable)((Object)LinkStatus.LINKED)), 3);
            }
        } else {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_(LINKSTATUS, (Comparable)((Object)LinkStatus.UNLINKED)), 3);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.m_5776_()) {
            return null;
        }
        if (pBlockEntityType == BlockEntityInit.LINKER_OUTPUT.get()) {
            return (level, pos, state, blockEntity) -> {
                if (blockEntity instanceof ContainerLinkerOutputBlockEntity) {
                    ContainerLinkerOutputBlockEntity linkerOutputBlockEntity = (ContainerLinkerOutputBlockEntity)blockEntity;
                    linkerOutputBlockEntity.tick(level, pos, state, blockEntity);
                }
            };
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        if (LINKSTATUS == null) {
            throw new IllegalStateException("LinkStatus is null");
        }
        pBuilder.m_61104_(new Property[]{LINKSTATUS});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ((BlockEntityType)BlockEntityInit.LINKER_OUTPUT.get()).m_155264_(pPos, pState);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        return (BlockState)this.m_49966_().m_61124_(LINKSTATUS, (Comparable)((Object)LinkStatus.UNLINKED));
    }

    public static enum LinkStatus implements StringRepresentable
    {
        LINKED,
        UNLINKED;


        @NotNull
        public String m_7912_() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case LINKED -> "linked";
                case UNLINKED -> "unlinked";
            };
        }
    }
}

