/*
 * Decompiled with CFR 0.152.
 */
package xyz.lunala.meowstorage.block.containers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.lunala.meowstorage.block.containers.MeowContainerEntity;

public abstract class MeowContainer
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    protected MeowContainer(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected abstract BlockEntityType<?> getBlockEntityType();

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return this.getBlockEntityType().m_155264_(blockPos, blockState);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof MeowContainerEntity)) {
            return InteractionResult.PASS;
        }
        MeowContainerEntity container = (MeowContainerEntity)blockEntity;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.CONSUME;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        NetworkHooks.openScreen((ServerPlayer)sPlayer, (MenuProvider)container, buf -> buf.m_130064_(pos));
        return InteractionResult.CONSUME;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public abstract BlockState m_5573_(BlockPlaceContext var1);

    public abstract VoxelShape m_5940_(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof Container) {
                Containers.m_19002_((Level)pLevel, (BlockPos)pPos, (Container)((Container)blockentity));
                pLevel.m_46717_(pPos, (Block)this);
                for (ItemStack drop : MeowContainer.m_49869_((BlockState)pState, (ServerLevel)((ServerLevel)pLevel), (BlockPos)pPos, (BlockEntity)blockentity)) {
                    if (drop.m_41619_()) continue;
                    Containers.m_18992_((Level)pLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (ItemStack)drop);
                }
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }
}

