/*
 * Decompiled with CFR 0.152.
 */
package xyz.lunala.meowstorage.block.containers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.lunala.meowstorage.menu.ChestMenu;
import xyz.lunala.meowstorage.util.IChestBlockMenuProvider;

public abstract class MeowContainerEntity
extends BlockEntity
implements MenuProvider,
IChestBlockMenuProvider,
Container {
    protected ItemStackHandler inventory;
    protected LazyOptional<ItemStackHandler> inventoryOptional;
    protected Component TITLE;

    protected MeowContainerEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int inventorySize, Component titleComponent) {
        super(type, pos, state);
        this.inventory = new ItemStackHandler(inventorySize){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                MeowContainerEntity.this.m_6596_();
            }
        };
        this.inventoryOptional = LazyOptional.of(() -> this.inventory);
        this.TITLE = titleComponent;
    }

    public void setCustomName(Component name) {
        this.TITLE = name;
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        CompoundTag modData = nbt.m_128469_("meowstorage");
        this.inventory.deserializeNBT(modData.m_128469_("inventory"));
    }

    public void loadFrom(CompoundTag nbt) {
        this.m_142466_(nbt);
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        CompoundTag modData = new CompoundTag();
        modData.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        nbt.m_128365_("meowstorage", (Tag)modData);
    }

    public void saveTo(CompoundTag nbt) {
        this.m_183515_(nbt);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.inventoryOptional.cast() : super.getCapability(cap);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? this.inventoryOptional.cast() : super.getCapability(cap);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryOptional.invalidate();
    }

    public CompoundTag m_5995_() {
        CompoundTag modData = super.m_5995_();
        this.m_183515_(modData);
        return modData;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        this.m_142466_(nbt);
    }

    public Component m_5446_() {
        return this.TITLE;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player player) {
        return new ChestMenu(pContainerId, pPlayerInventory, this);
    }

    @Override
    public LazyOptional<ItemStackHandler> getOptional() {
        return this.inventoryOptional;
    }

    public int m_6643_() {
        return this.inventory.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.inventory.extractItem(slot, amount, false);
    }

    public ItemStack m_8016_(int slot) {
        return this.inventory.extractItem(slot, 1, false);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
    }

    public boolean m_6542_(Player player) {
        return false;
    }

    public void m_6211_() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.extractItem(i, this.inventory.getStackInSlot(i).m_41613_(), false);
        }
    }
}

