/*
 * Decompiled with CFR 0.152.
 */
package xyz.lunala.meowstorage.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import xyz.lunala.meowstorage.Meowstorage;
import xyz.lunala.meowstorage.init.MenuInit;
import xyz.lunala.meowstorage.util.IChestBlockMenuProvider;

public class ChestMenu
extends AbstractContainerMenu {
    private final IChestBlockMenuProvider chestBlockMenuProvider;
    private final ContainerLevelAccess levelAccess;

    public ChestMenu(int id, Inventory playerInventory, FriendlyByteBuf additionalData) {
        this(id, playerInventory, playerInventory.f_35978_.m_9236_().m_7702_(additionalData.m_130135_()));
    }

    public ChestMenu(int id, Inventory playerInventory, BlockEntity blockEntity) {
        super((MenuType)MenuInit.CHEST_MENU.get(), id);
        IChestBlockMenuProvider copperChestBlockEntity;
        if (!(blockEntity instanceof IChestBlockMenuProvider)) {
            throw new IllegalStateException("Expected CopperChestBlockEntity but got " + blockEntity.getClass().getCanonicalName());
        }
        this.chestBlockMenuProvider = copperChestBlockEntity = (IChestBlockMenuProvider)blockEntity;
        assert (blockEntity.m_58904_() != null);
        this.levelAccess = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        this.chestBlockMenuProvider.getOptional().ifPresent(inventory -> {
            if (inventory.getSlots() <= 27) {
                this.createPlayerInventory(playerInventory, ChestMode.SINGLE);
                this.createPlayerHotbar(playerInventory, ChestMode.SINGLE);
            } else {
                this.createPlayerInventory(playerInventory, ChestMode.DOUBLE);
                this.createPlayerHotbar(playerInventory, ChestMode.DOUBLE);
            }
            this.createBlockEntityInventory((ItemStackHandler)inventory);
        });
    }

    private void createBlockEntityInventory(ItemStackHandler inventory) {
        for (int i = 0; i < inventory.getSlots(); ++i) {
            this.m_38897_((Slot)new SlotItemHandler((IItemHandler)inventory, i, 8 + i % 9 * 18, 18 + i / 9 * 18));
        }
    }

    private void createPlayerInventory(Inventory playerInventory, ChestMode mode) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, 8 + x * 18, mode.getOffset() + y * 18));
            }
        }
    }

    private void createPlayerHotbar(Inventory playerInventory, ChestMode mode) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, mode.getOffset() + 58));
        }
    }

    @NotNull
    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        Slot fromSlot = this.m_38853_(pIndex);
        ItemStack fromStack = fromSlot.m_7993_();
        if (fromStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!fromSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack copyFromStack = fromStack.m_41777_();
        if (pIndex < 36) {
            if (!this.m_38903_(fromStack, 36, this.f_38839_.size(), false)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex < this.f_38839_.size()) {
            if (!this.m_38903_(fromStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            Meowstorage.getLogger().error("Invalid slot index: {}", (Object)pIndex);
            return ItemStack.f_41583_;
        }
        fromSlot.m_6654_();
        fromSlot.m_142406_(pPlayer, fromStack);
        return copyFromStack;
    }

    public boolean m_6875_(Player pPlayer) {
        IChestBlockMenuProvider iChestBlockMenuProvider = this.chestBlockMenuProvider;
        if (!(iChestBlockMenuProvider instanceof BlockEntity)) {
            throw new IllegalStateException("Expected BlockEntity but got " + this.chestBlockMenuProvider.getClass().getCanonicalName());
        }
        BlockEntity blockEntity = (BlockEntity)iChestBlockMenuProvider;
        return ChestMenu.m_38889_((ContainerLevelAccess)this.levelAccess, (Player)pPlayer, (Block)blockEntity.m_58900_().m_60734_());
    }

    private static enum ChestMode {
        SINGLE(84),
        DOUBLE(138);

        private final int offset;

        private ChestMode(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

