/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.sit.file;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import one.oth3r.sit.utl.Utl;

public class CustomBlock {
    @SerializedName(value="block-ids")
    private ArrayList<String> blockIds = new ArrayList();
    @SerializedName(value="block-tags")
    private ArrayList<String> blockTags = new ArrayList();
    @SerializedName(value="blockstates")
    private ArrayList<String> blockStates = new ArrayList();

    public CustomBlock() {
    }

    public CustomBlock(ArrayList<String> blockIds, ArrayList<String> blockTags, ArrayList<String> blockStates) {
        this.blockIds = blockIds;
        this.blockTags = blockTags;
        this.blockStates = blockStates;
    }

    public CustomBlock(CustomBlock customBlock) {
        this.blockIds = new ArrayList<String>(customBlock.blockIds);
        this.blockTags = new ArrayList<String>(customBlock.blockTags);
        this.blockStates = new ArrayList<String>(customBlock.blockStates);
    }

    public ArrayList<String> getBlockIds() {
        return this.blockIds;
    }

    public ArrayList<String> getBlockTags() {
        return this.blockTags;
    }

    public ArrayList<String> getBlockStates() {
        return this.blockStates;
    }

    public boolean isValid(class_2680 blockState) {
        boolean blockType = this.checkBlockType(blockState);
        if (!blockType) {
            return false;
        }
        for (String state : this.blockStates) {
            if (state.startsWith("!")) {
                String fixedState = state.substring(1);
                if (!blockState.method_11656().entrySet().stream().map(class_2688.field_24737).anyMatch(s -> s.equals(fixedState))) continue;
                return false;
            }
            if (!blockState.method_11656().entrySet().stream().map(class_2688.field_24737).noneMatch(s -> s.equals(state))) continue;
            return false;
        }
        return true;
    }

    private boolean checkBlockType(class_2680 blockState) {
        for (String id : this.blockIds) {
            if (id.startsWith("!") && id.substring(1).equals(Utl.getBlockID(blockState))) {
                return false;
            }
            if (!id.equalsIgnoreCase(Utl.getBlockID(blockState))) continue;
            return true;
        }
        boolean tagCheck = false;
        boolean hasPositiveTags = false;
        for (String tag : this.blockTags) {
            class_2960 id;
            if (tag.startsWith("!")) {
                id = class_2960.method_12829((String)tag.substring(2));
                if (id == null || !blockState.method_26164(class_6862.method_40092((class_5321)class_7923.field_41175.method_46765(), (class_2960)id))) continue;
                return false;
            }
            hasPositiveTags = true;
            id = class_2960.method_12829((String)tag.substring(1));
            if (id == null || !blockState.method_26164(class_6862.method_40092((class_5321)class_7923.field_41175.method_46765(), (class_2960)id))) continue;
            tagCheck = true;
        }
        return hasPositiveTags ? tagCheck : true;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomBlock that = (CustomBlock)o;
        return Objects.equals(this.blockIds, that.blockIds) && Objects.equals(this.blockTags, that.blockTags) && Objects.equals(this.blockStates, that.blockStates);
    }

    public int hashCode() {
        return Objects.hash(this.blockIds, this.blockTags, this.blockStates);
    }
}

