/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.sit.file;

import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import one.oth3r.sit.file.CustomItem;

public class HandSetting {
    @SerializedName(value="requirement")
    private SittingRequirement sittingRequirement = SittingRequirement.NONE;
    @SerializedName(value="requirement-options")
    private final String sittingRequirementOptions = Arrays.stream(SittingRequirement.values()).map(Enum::toString).collect(Collectors.joining(", "));
    @SerializedName(value="filter")
    private Filter filter = new Filter();

    public HandSetting() {
    }

    public HandSetting(SittingRequirement sittingRequirement, Filter filter) {
        this.sittingRequirement = sittingRequirement;
        this.filter = filter;
    }

    public HandSetting(HandSetting handSetting) {
        this.sittingRequirement = handSetting.sittingRequirement;
        this.filter = new Filter(handSetting.filter);
    }

    public SittingRequirement getSittingRequirement() {
        return this.sittingRequirement;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandSetting that = (HandSetting)o;
        return this.sittingRequirement == that.sittingRequirement && Objects.equals(this.sittingRequirementOptions, that.sittingRequirementOptions) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sittingRequirement, this.sittingRequirementOptions, this.filter});
    }

    public static enum SittingRequirement {
        NONE,
        FILTER,
        EMPTY;

    }

    public static class Filter {
        @SerializedName(value="invert-filter")
        private Boolean invert = false;
        @SerializedName(value="presets")
        private Presets presets = new Presets();
        @SerializedName(value="custom-items")
        private CustomItem customItems = new CustomItem();

        public Filter() {
        }

        public Filter(boolean invert, Presets presets, CustomItem customItems) {
            this.invert = invert;
            this.presets = presets;
            this.customItems = customItems;
        }

        public Filter(Filter filter) {
            this.invert = filter.invert;
            this.presets = new Presets(filter.presets);
            this.customItems = new CustomItem(filter.customItems);
        }

        public Boolean isInverted() {
            return this.invert;
        }

        public Presets getPresets() {
            return this.presets;
        }

        public CustomItem getCustomItems() {
            return this.customItems;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Filter filter = (Filter)o;
            return Objects.equals(this.invert, filter.invert) && Objects.equals(this.presets, filter.presets) && Objects.equals(this.customItems, filter.customItems);
        }

        public int hashCode() {
            return Objects.hash(this.invert, this.presets, this.customItems);
        }

        public static class Presets {
            @SerializedName(value="block")
            private boolean block = false;
            @SerializedName(value="food")
            private boolean food = false;
            @SerializedName(value="usable")
            private boolean usable = false;

            public Presets() {
            }

            public Presets(boolean block, boolean food, boolean usable) {
                this.block = block;
                this.food = food;
                this.usable = usable;
            }

            public Presets(Presets presets) {
                this.block = presets.block;
                this.food = presets.food;
                this.usable = presets.usable;
            }

            public boolean isBlock() {
                return this.block;
            }

            public boolean isFood() {
                return this.food;
            }

            public boolean isUsable() {
                return this.usable;
            }

            public boolean equals(Object o) {
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Presets presets = (Presets)o;
                return this.block == presets.block && this.food == presets.food && this.usable == presets.usable;
            }

            public int hashCode() {
                return Objects.hash(this.block, this.food, this.usable);
            }
        }
    }
}

