/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.sit.file;

import com.google.common.base.Objects;
import com.google.gson.annotations.SerializedName;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.class_1268;
import one.oth3r.otterlib.file.CustomFile;
import one.oth3r.otterlib.file.FileSettings;
import one.oth3r.sit.file.FileData;
import one.oth3r.sit.file.HandSetting;
import one.oth3r.sit.utl.Data;
import org.jetbrains.annotations.NotNull;

public class SittingConfig
implements CustomFile<SittingConfig> {
    public static final String ID = "sitting-config";
    @SerializedName(value="version")
    private Double version = 1.0;
    @SerializedName(value="enabled")
    private Boolean enabled = true;
    @SerializedName(value="hand-sitting")
    private Boolean handSitting = true;
    @SerializedName(value="main-hand")
    private HandSetting mainHand = FileData.Defaults.MAIN_HAND;
    @SerializedName(value="off-hand")
    private HandSetting offHand = FileData.Defaults.OFF_HAND;

    public SittingConfig() {
    }

    public SittingConfig(double version, boolean enabled, boolean handSitting, HandSetting mainHand, HandSetting offHand) {
        this.version = version;
        this.enabled = enabled;
        this.handSitting = handSitting;
        this.mainHand = mainHand;
        this.offHand = offHand;
    }

    public SittingConfig(SittingConfig sittingConfig) {
        this.copyFileData(sittingConfig);
    }

    public Double getVersion() {
        return this.version;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean canSitWithHand() {
        return this.handSitting;
    }

    public void setHandSitting(Boolean handSitting) {
        this.handSitting = handSitting;
    }

    public HandSetting getHand(class_1268 handType) {
        return handType.equals((Object)class_1268.field_5808) ? this.mainHand : this.offHand;
    }

    public HandSetting getMainHand() {
        return this.mainHand;
    }

    public HandSetting getOffHand() {
        return this.offHand;
    }

    public FileSettings getFileSettings() {
        return new FileSettings(Data.LOGGER);
    }

    public Path getFilePath() {
        return Paths.get(Data.CONFIG_DIR, "sitting-config.json");
    }

    public void reset() {
        this.copyFileData(new SittingConfig());
    }

    @NotNull
    public Class<SittingConfig> getFileClass() {
        return SittingConfig.class;
    }

    public void copyFileData(SittingConfig sittingConfig) {
        this.version = sittingConfig.version;
        this.enabled = sittingConfig.enabled;
        this.handSitting = sittingConfig.handSitting;
        this.mainHand = new HandSetting(sittingConfig.mainHand);
        this.offHand = new HandSetting(sittingConfig.offHand);
    }

    public void updateInstance() {
    }

    public SittingConfig clone() {
        SittingConfig clone = new SittingConfig();
        clone.copyFileData(this);
        return clone;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SittingConfig that = (SittingConfig)o;
        return Objects.equal((Object)this.version, (Object)that.version) && Objects.equal((Object)this.enabled, (Object)that.enabled) && Objects.equal((Object)this.handSitting, (Object)that.handSitting) && Objects.equal((Object)this.mainHand, (Object)that.mainHand) && Objects.equal((Object)this.offHand, (Object)that.offHand);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.version, this.enabled, this.handSitting, this.mainHand, this.offHand});
    }
}

