/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.sit.utl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1269;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import one.oth3r.otterlib.chat.CTxT;
import one.oth3r.sit.SitClient;
import one.oth3r.sit.command.SitCommand;
import one.oth3r.sit.file.FileData;
import one.oth3r.sit.file.SittingConfig;
import one.oth3r.sit.packet.SitPayloads;
import one.oth3r.sit.utl.Chat;
import one.oth3r.sit.utl.Data;
import one.oth3r.sit.utl.Logic;
import one.oth3r.sit.utl.LoopManager;
import one.oth3r.sit.utl.Utl;

public class Events {
    private static void clientMisc() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            assert (client.field_1724 != null);
            Keybindings.loopLogic(client);
        });
    }

    private static void clientConnections() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            Data.setInGame(true);
            if (client.method_1542()) {
                Data.setSingleplayer(true);
            }
            Utl.sendSettingsPackets();
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            Data.setInGame(false);
            Data.setSingleplayer(false);
            Data.setSupportedServer(false);
        });
    }

    private static void playerConnections() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            FileData.setPlayerSetting(handler.field_14140, FileData.getSittingConfig());
            Data.setCheckPlayer(handler.field_14140, 5);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (!FileData.getServerConfig().isKeepActive()) {
                Logic.removeEntity(handler.field_14140);
            }
            FileData.removePlayerSetting(handler.field_14140);
        });
    }

    private static void serverLifecycle() {
        ServerLifecycleEvents.SERVER_STARTED.register(s -> {
            Data.setServer(s);
            UseBlockCallback.EVENT.register((pl, world, hand, hitResult) -> {
                class_1269.class_9860 result;
                if (Data.isClient() && !Data.isSingleplayer()) {
                    return class_1269.field_5811;
                }
                class_3222 player = Data.getServer().method_3760().method_14602(pl.method_5667());
                if (player == null || player.method_7325()) {
                    return class_1269.field_5811;
                }
                Object object = result = Logic.canSit(player, hitResult.method_17777(), hitResult) ? class_1269.field_21466 : class_1269.field_5811;
                if (result.equals((Object)class_1269.field_21466)) {
                    try {
                        CommandDispatcher dispatcher = Data.getServer().method_3739().method_54310();
                        ParseResults parse = dispatcher.parse("sit", (Object)player.method_64396());
                        dispatcher.execute(parse);
                    }
                    catch (CommandSyntaxException e) {
                        Data.LOGGER.error("Error executing sit command for player %s", new Object[]{player.method_5477().getString()});
                    }
                }
                return result;
            });
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(s -> {
            Data.setServer(null);
            FileData.clearPlayerSettings();
        });
        ServerTickEvents.END_SERVER_TICK.register(minecraftServer -> minecraftServer.execute(LoopManager::tick));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> SitCommand.register((CommandDispatcher<class_2168>)dispatcher));
    }

    public static void registerCommon() {
        Events.playerConnections();
        Events.serverLifecycle();
        Packet.common();
    }

    public static void registerClient() {
        Keybindings.register();
        Events.clientConnections();
        Events.clientMisc();
        Packet.client();
    }

    private static class Packet {
        private Packet() {
        }

        private static void common() {
            PayloadTypeRegistry.playC2S().register(SitPayloads.SettingsPayload.ID, SitPayloads.SettingsPayload.CODEC);
            PayloadTypeRegistry.playS2C().register(SitPayloads.ResponsePayload.ID, SitPayloads.ResponsePayload.CODEC);
            ServerPlayNetworking.registerGlobalReceiver(SitPayloads.SettingsPayload.ID, (payload, context) -> Data.getServer().execute(() -> {
                FileData.setPlayerSetting(context.player(), (SittingConfig)Utl.getGson().fromJson(payload.value(), SittingConfig.class));
                ServerPlayNetworking.send((class_3222)context.player(), (class_8710)new SitPayloads.ResponsePayload("response_v1.0"));
                Data.LOGGER.info(Chat.lang("sit!.console.player_settings", context.player().method_5477().getString()).toString(), new Object[0]);
            }));
        }

        private static void client() {
            ClientPlayNetworking.registerGlobalReceiver(SitPayloads.ResponsePayload.ID, (payload, context) -> {
                if (!Data.isSupportedServer()) {
                    Data.setSupportedServer(true);
                    Data.LOGGER.info(Chat.lang("sit!.console.connected", payload.value()).toString(), new Object[0]);
                }
            });
        }
    }

    private static class Keybindings {
        private static class_304 toggle_key;
        private static class_304 sit_key;
        private static class_304 config__key;

        private Keybindings() {
        }

        private static void register() {
            toggle_key = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.sit!.toggle", -1, "category.sit!"));
            sit_key = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.sit!.sit", -1, "category.sit!"));
            config__key = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.sit!.config", -1, "category.sit!"));
        }

        private static void loopLogic(class_310 client) {
            class_746 player = client.field_1724;
            while (config__key.method_1436()) {
                client.method_1507(SitClient.getConfigScreen(client.field_1755));
            }
            if (player == null) {
                return;
            }
            while (toggle_key.method_1436()) {
                if (!Data.isInGame()) continue;
                player.method_7353((class_2561)Logic.toggleSiting(), true);
            }
            while (sit_key.method_1436()) {
                if (!Data.isInGame()) continue;
                if (Data.isSupportedServer()) {
                    player.field_3944.method_45730("sit");
                    continue;
                }
                player.method_7353((class_2561)((CTxT)Chat.lang("sit!.chat.unsupported", new Object[0]).color(Color.RED)).b(), true);
            }
        }
    }
}

