/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.sit.utl;

import java.awt.Color;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_8113;
import one.oth3r.otterlib.chat.CTxT;
import one.oth3r.sit.file.FileData;
import one.oth3r.sit.file.HandSetting;
import one.oth3r.sit.file.ServerConfig;
import one.oth3r.sit.file.SittingConfig;
import one.oth3r.sit.utl.Chat;
import one.oth3r.sit.utl.Data;
import one.oth3r.sit.utl.Utl;
import org.jetbrains.annotations.Nullable;

public class Logic {
    public static boolean canSit(class_3222 player, class_2338 blockPos, @Nullable class_3965 hitResult) {
        if (player.method_5715()) {
            return false;
        }
        if (!FileData.getServerConfig().canSitWhileSeated() && Data.getSitEntity(player) != null) {
            return false;
        }
        if (hitResult != null && !Logic.checkHands(player)) {
            return false;
        }
        if (!Logic.checkYLimits(player, blockPos)) {
            return false;
        }
        class_3218 serverWorld = player.method_51469();
        Double sitHeight = Utl.getSittingHeight(player, blockPos, hitResult);
        if (sitHeight == null) {
            return false;
        }
        class_8113.class_8123 entity = Utl.Entity.create((class_1937)serverWorld, blockPos, sitHeight);
        return Logic.checkPlayerSitAbility(entity);
    }

    public static boolean sit(class_3222 player, class_2338 blockPos, @Nullable class_3965 hitResult) {
        if (!Logic.canSit(player, blockPos, hitResult)) {
            return false;
        }
        class_3218 serverWorld = player.method_51469();
        Double sitHeight = Utl.getSittingHeight(player, blockPos, hitResult);
        assert (sitHeight != null);
        Utl.Entity.spawnSit(player, Utl.Entity.create((class_1937)serverWorld, blockPos, sitHeight));
        return true;
    }

    public static boolean sitLooking(class_3222 player) {
        return Logic.sit(player, Utl.getBlockPosPlayerIsLookingAt(player.method_51469(), (class_1657)player, Utl.getPlayerReach((class_1657)player)), null);
    }

    public static boolean checkHands(class_3222 player) {
        SittingConfig sittingConfig = FileData.getPlayerSetting(player);
        if (!sittingConfig.canSitWithHand()) {
            return false;
        }
        boolean canSit = true;
        block4: for (class_1268 hand : class_1268.values()) {
            if (!canSit) break;
            HandSetting handSetting = sittingConfig.getHand(hand);
            switch (handSetting.getSittingRequirement()) {
                case EMPTY: {
                    canSit = player.method_5998(hand).method_7960();
                    continue block4;
                }
                case FILTER: {
                    canSit = Utl.checkItem(handSetting.getFilter(), player.method_5998(hand));
                }
            }
        }
        return canSit;
    }

    public static boolean checkYLimits(class_3222 player, class_2338 blockPos) {
        double blockY;
        boolean isAbove;
        double playerY = player.method_31478();
        boolean bl = isAbove = playerY < (blockY = (double)blockPos.method_10264());
        if (playerY == blockY) {
            return true;
        }
        double heightDifference = Math.abs(playerY - blockY);
        ServerConfig.YDifferenceLimit yDifferenceLimit = FileData.getServerConfig().getYDifferenceLimit();
        return (isAbove ? yDifferenceLimit.getAbove() : yDifferenceLimit.getBelow()) >= heightDifference;
    }

    public static void removeEntity(class_3222 player) {
        class_8113.class_8123 entity = Data.getSitEntity(player);
        if (entity == null) {
            return;
        }
        Utl.Entity.remove(entity);
    }

    public static void spawnEntity(class_3222 player) {
        if (Data.getSpawnList().get(player) == null) {
            return;
        }
        if (Data.getSitEntity(player) != null) {
            Logic.removeEntity(player);
        }
        class_8113.class_8123 sitEntity = Data.getSpawnList().get(player);
        player.method_51469().method_8649((class_1297)sitEntity);
        player.method_5804((class_1297)sitEntity);
        Data.addSitEntity(player, sitEntity);
        Data.removeSpawnList(player);
    }

    public static void checkSittingValidity(class_3222 player) {
        class_8113.class_8123 entity = Data.getSitEntity(player);
        if (entity == null) {
            return;
        }
        if (!Utl.Entity.isValid(player, entity)) {
            Logic.removeEntity(player);
        }
    }

    public static boolean checkPlayerSitAbility(class_8113.class_8123 entity) {
        class_2338 pos = Utl.Entity.getBlockPos(entity);
        class_2338 pos1 = new class_2338((class_2382)pos).method_10069(0, 1, 0);
        class_2338 pos2 = new class_2338((class_2382)pos).method_10069(0, 2, 0);
        class_2338 posBelow = new class_2338((class_2382)pos);
        if ((double)pos.method_10264() > entity.method_23318() - 0.0 - 0.8) {
            pos2 = pos2.method_10069(0, -1, 0);
            posBelow = posBelow.method_10069(0, -1, 0);
        }
        return Utl.isNotObstructed(entity.method_37908(), pos1) && Utl.isNotObstructed(entity.method_37908(), pos2) && Utl.isNotOccupied(pos) && Utl.isNotOccupied(pos1) && Utl.isNotOccupied(pos2) && Utl.isNotOccupied(posBelow);
    }

    public static void reload() {
        FileData.loadFiles();
        FileData.saveFiles();
    }

    public static class_5250 toggleSiting() {
        if (Data.isSupportedServer()) {
            SittingConfig config;
            config.setEnabled((config = FileData.getSittingConfig()).getEnabled() == false);
            config.save();
            Utl.sendSettingsPackets();
            String messageKey = "sit!.chat.toggle_sit." + (config.getEnabled() != false ? "on" : "off");
            class_124 messageColor = config.getEnabled() != false ? class_124.field_1060 : class_124.field_1061;
            return Chat.lang("sit!.chat.toggle_sit", Chat.lang(messageKey, new Object[0]).color(config.getEnabled() != false ? Color.GREEN : Color.RED)).b();
        }
        return ((CTxT)Chat.lang("sit!.chat.unsupported", new Object[0]).color(Color.RED)).b();
    }
}

