/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.sit.file;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import one.oth3r.otterlib.base.Num;
import one.oth3r.otterlib.file.CustomFile;
import one.oth3r.otterlib.file.FileSettings;
import one.oth3r.otterlib.registry.LanguageReg;
import one.oth3r.sit.file.CustomBlock;
import one.oth3r.sit.file.CustomItem;
import one.oth3r.sit.file.FileData;
import one.oth3r.sit.file.HandSetting;
import one.oth3r.sit.file.SittingBlock;
import one.oth3r.sit.file.SittingConfig;
import one.oth3r.sit.utl.Data;
import org.jetbrains.annotations.NotNull;

public class ServerConfig
implements CustomFile<ServerConfig> {
    public static final String ID = "server-config";
    @SerializedName(value="version")
    private Double version = 2.3;
    @SerializedName(value="lang")
    private String lang = "en_us";
    @SerializedName(value="lang-options")
    private final String langOptions = "en_us, it_it, pt_br, tr_tr, zh_tw, zh_cn, de_de";
    @SerializedName(value="keep-active")
    private Boolean keepActive = true;
    @SerializedName(value="sit-while-seated")
    private Boolean sitWhileSeated = false;
    @SerializedName(value="preset-blocks")
    private PresetBlocks presetBlocks = new PresetBlocks();
    @SerializedName(value="height-difference-limit")
    private YDifferenceLimit yDifferenceLimit = new YDifferenceLimit();
    @SerializedName(value="custom-enabled")
    private Boolean customEnabled = false;
    @SerializedName(value="custom-blocks")
    private ArrayList<SittingBlock> sittingBlocks = FileData.Defaults.SITTING_BLOCKS;
    @SerializedName(value="blacklisted-blocks")
    private ArrayList<CustomBlock> blacklistedBlocks = FileData.Defaults.BLACKLISTED_BLOCKS;
    @SerializedName(value="interaction-blocks")
    private ArrayList<CustomBlock> interactionBlocks = FileData.Defaults.INTERACTION_BLOCKS;
    @SerializedName(value="allowed-above-seat")
    private ArrayList<CustomBlock> allowedAboveSeat = FileData.Defaults.ALLOWED_ABOVE_SEAT;

    public ServerConfig() {
    }

    public ServerConfig(ServerConfig serverConfig) {
        this.copyFileData(serverConfig);
    }

    public ServerConfig(Double version, String lang, boolean keepActive, boolean sitWhileSeated, PresetBlocks presetBlocks, boolean customEnabled, ArrayList<SittingBlock> sittingBlocks, ArrayList<CustomBlock> blacklistedBlocks, ArrayList<CustomBlock> interactionBlocks, ArrayList<CustomBlock> allowedAboveSeat) {
        this.version = version;
        this.lang = lang;
        this.keepActive = keepActive;
        this.sitWhileSeated = sitWhileSeated;
        this.presetBlocks = presetBlocks;
        this.customEnabled = customEnabled;
        this.sittingBlocks = sittingBlocks;
        this.blacklistedBlocks = blacklistedBlocks;
        this.interactionBlocks = interactionBlocks;
        this.allowedAboveSeat = allowedAboveSeat;
    }

    public Double getVersion() {
        return this.version;
    }

    public String getLang() {
        return this.lang;
    }

    public boolean isKeepActive() {
        return this.keepActive;
    }

    public boolean canSitWhileSeated() {
        return this.sitWhileSeated;
    }

    public PresetBlocks getPresetBlocks() {
        return this.presetBlocks;
    }

    public YDifferenceLimit getYDifferenceLimit() {
        return this.yDifferenceLimit;
    }

    public Boolean isCustomEnabled() {
        return this.customEnabled;
    }

    public ArrayList<SittingBlock> getSittingBlocks() {
        return this.sittingBlocks;
    }

    public ArrayList<CustomBlock> getBlacklistedBlocks() {
        return this.blacklistedBlocks;
    }

    public ArrayList<CustomBlock> getInteractionBlocks() {
        return this.interactionBlocks;
    }

    public ArrayList<CustomBlock> getAllowedAboveSeat() {
        return this.allowedAboveSeat;
    }

    public FileSettings getFileSettings() {
        return new FileSettings(Data.LOGGER);
    }

    public Path getFilePath() {
        return Paths.get(Data.CONFIG_DIR, "server-config.json");
    }

    public void reset() {
        this.copyFileData(new ServerConfig());
    }

    @NotNull
    public Class<ServerConfig> getFileClass() {
        return ServerConfig.class;
    }

    public void copyFileData(ServerConfig newFile) {
        this.version = newFile.version;
        this.lang = newFile.lang;
        this.keepActive = newFile.keepActive;
        this.sitWhileSeated = newFile.sitWhileSeated;
        this.presetBlocks = new PresetBlocks(newFile.presetBlocks);
        this.yDifferenceLimit = new YDifferenceLimit(newFile.yDifferenceLimit);
        this.customEnabled = newFile.customEnabled;
        this.sittingBlocks = newFile.sittingBlocks.stream().map(SittingBlock::new).collect(Collectors.toCollection(ArrayList::new));
        this.blacklistedBlocks = newFile.blacklistedBlocks.stream().map(CustomBlock::new).collect(Collectors.toCollection(ArrayList::new));
        this.interactionBlocks = newFile.interactionBlocks.stream().map(CustomBlock::new).collect(Collectors.toCollection(ArrayList::new));
        this.allowedAboveSeat = newFile.allowedAboveSeat.stream().map(CustomBlock::new).collect(Collectors.toCollection(ArrayList::new));
    }

    public void updateInstance() {
        if (this.version >= 2.0 && this.version <= 2.1) {
            this.version = 2.2;
        }
        if (this.version == 2.2) {
            this.version = 2.3;
            this.lang = this.lang.substring(0, 3) + this.lang.substring(3).toLowerCase();
        }
        LanguageReg.getLang((String)"sit-oth3r").updateLanguage(this.lang);
    }

    public void createDirectory() {
        super.createDirectory();
        if (Legacy.getLegacyFile().exists()) {
            Data.LOGGER.info("Updating Sit!.properties to sit!/config.json", new Object[0]);
            Legacy.run();
        }
    }

    public ServerConfig clone() {
        ServerConfig clone = new ServerConfig();
        clone.copyFileData(this);
        return clone;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerConfig that = (ServerConfig)o;
        return Objects.equals(this.version, that.version) && Objects.equals(this.lang, that.lang) && Objects.equals(this.keepActive, that.keepActive) && Objects.equals(this.sitWhileSeated, that.sitWhileSeated) && Objects.equals(this.presetBlocks, that.presetBlocks) && Objects.equals(this.yDifferenceLimit, that.yDifferenceLimit) && Objects.equals(this.customEnabled, that.customEnabled) && Objects.equals(this.sittingBlocks, that.sittingBlocks) && Objects.equals(this.blacklistedBlocks, that.blacklistedBlocks) && Objects.equals(this.interactionBlocks, that.interactionBlocks) && Objects.equals(this.allowedAboveSeat, that.allowedAboveSeat);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.lang, "en_us, it_it, pt_br, tr_tr, zh_tw, zh_cn, de_de", this.keepActive, this.sitWhileSeated, this.presetBlocks, this.yDifferenceLimit, this.customEnabled, this.sittingBlocks, this.blacklistedBlocks, this.interactionBlocks, this.allowedAboveSeat);
    }

    public static class PresetBlocks {
        @SerializedName(value="stairs")
        private boolean stairs = true;
        @SerializedName(value="slabs")
        private boolean slabs = true;
        @SerializedName(value="carpets")
        private boolean carpets = true;
        @SerializedName(value="full-blocks")
        private boolean fullBlocks = false;

        public PresetBlocks() {
        }

        public PresetBlocks(boolean stairs, boolean slabs, boolean carpets, boolean fullBlocks) {
            this.stairs = stairs;
            this.slabs = slabs;
            this.carpets = carpets;
            this.fullBlocks = fullBlocks;
        }

        public PresetBlocks(PresetBlocks presetBlocks) {
            this.stairs = presetBlocks.stairs;
            this.slabs = presetBlocks.slabs;
            this.carpets = presetBlocks.carpets;
            this.fullBlocks = presetBlocks.fullBlocks;
        }

        public boolean isStairs() {
            return this.stairs;
        }

        public boolean isSlabs() {
            return this.slabs;
        }

        public boolean isCarpets() {
            return this.carpets;
        }

        public boolean isFullBlocks() {
            return this.fullBlocks;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PresetBlocks that = (PresetBlocks)o;
            return this.stairs == that.stairs && this.slabs == that.slabs && this.carpets == that.carpets && this.fullBlocks == that.fullBlocks;
        }

        public int hashCode() {
            return Objects.hash(this.stairs, this.slabs, this.carpets, this.fullBlocks);
        }
    }

    public static class YDifferenceLimit {
        @SerializedName(value="above")
        private Double above = 1.0;
        @SerializedName(value="below")
        private Double below = 1.0;

        public YDifferenceLimit() {
        }

        public YDifferenceLimit(Double above, Double below) {
            this.above = above;
            this.below = below;
        }

        public YDifferenceLimit(YDifferenceLimit yDifferenceLimit) {
            this.above = yDifferenceLimit.above;
            this.below = yDifferenceLimit.below;
        }

        public Double getAbove() {
            return this.above;
        }

        public void setAbove(Double above) {
            this.above = above;
        }

        public Double getBelow() {
            return this.below;
        }

        public void setBelow(Double below) {
            this.below = below;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            YDifferenceLimit that = (YDifferenceLimit)o;
            return Objects.equals(this.above, that.above) && Objects.equals(this.below, that.below);
        }

        public int hashCode() {
            return Objects.hash(this.above, this.below);
        }
    }

    protected static class Legacy {
        protected Legacy() {
        }

        public static File getLegacyFile() {
            return new File(Data.CONFIG_DIR.substring(0, Data.CONFIG_DIR.length() - 5) + "Sit!.properties");
        }

        public static void run() {
            File file = Legacy.getLegacyFile();
            if (!file.exists()) {
                return;
            }
            try (FileInputStream fileStream = new FileInputStream(file);){
                Properties properties = new Properties();
                properties.load(fileStream);
                String ver = (String)properties.computeIfAbsent("version", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(new ServerConfig().getVersion())));
                if (ver.contains("v")) {
                    ver = ver.substring(1);
                }
                Legacy.loadAndUpdateVersion(properties, Double.parseDouble(ver));
            }
            catch (Exception e) {
                Data.LOGGER.error("Error loading legacy config file: %s", new Object[]{e.getMessage()});
            }
        }

        private static void deleteLegacyFile() {
            File file = Legacy.getLegacyFile();
            try {
                Files.delete(file.toPath());
                Data.LOGGER.info("Deleted " + file.getName(), new Object[0]);
            }
            catch (Exception e) {
                Data.LOGGER.error("Failed to delete the old Sit! config.", new Object[0]);
            }
        }

        private static HandSetting.SittingRequirement handRequirementUpdater(String requirement) {
            return switch (requirement) {
                case "restrictive" -> HandSetting.SittingRequirement.FILTER;
                case "none" -> HandSetting.SittingRequirement.NONE;
                default -> HandSetting.SittingRequirement.EMPTY;
            };
        }

        private static ArrayList<SittingBlock> getCustomBlocks(ArrayList<String> fix) {
            ArrayList<SittingBlock> out = new ArrayList<SittingBlock>();
            for (String entry : fix) {
                String[] split = entry.split("\\|");
                if (split.length < 3 || split.length > 4 || !Num.isNum((String)split[2])) continue;
                ArrayList<String> blockstates = new ArrayList<String>();
                if (split.length == 4) {
                    blockstates.addAll(Arrays.asList(split[3].split(",")));
                }
                out.add(new SittingBlock(new ArrayList<String>(Arrays.asList(split[0])), new ArrayList<String>(), blockstates, Double.parseDouble(split[1])));
            }
            return out;
        }

        private static ArrayList<String> getFilterList(ArrayList<String> whitelist, ArrayList<String> blacklist) {
            ArrayList<String> out = new ArrayList<String>(whitelist);
            out.addAll(blacklist.stream().map(e -> "!" + e).toList());
            return out;
        }

        public static void loadAndUpdateVersion(Properties properties, double version) {
            try {
                Type listType = new TypeToken<ArrayList<String>>(){}.getType();
                ServerConfig defaultConfig = new ServerConfig();
                ServerConfig serverConfig = new ServerConfig(2.0, (String)properties.computeIfAbsent("lang", (Function<? super Object, ?>)((Function<Object, Object>)a -> defaultConfig.getLang())), Boolean.parseBoolean((String)properties.computeIfAbsent("keep-active", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(defaultConfig.isKeepActive())))), Boolean.parseBoolean((String)properties.computeIfAbsent("sit-while-seated", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(defaultConfig.canSitWhileSeated())))), new PresetBlocks(Boolean.parseBoolean((String)properties.computeIfAbsent("stairs", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(defaultConfig.getPresetBlocks().isStairs())))), Boolean.parseBoolean((String)properties.computeIfAbsent("slabs", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(defaultConfig.getPresetBlocks().isSlabs())))), Boolean.parseBoolean((String)properties.computeIfAbsent("carpets", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(defaultConfig.getPresetBlocks().isCarpets())))), Boolean.parseBoolean((String)properties.computeIfAbsent("full-blocks", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(defaultConfig.getPresetBlocks().isFullBlocks()))))), Boolean.parseBoolean((String)properties.computeIfAbsent("custom", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(defaultConfig.isCustomEnabled())))), Legacy.getCustomBlocks((ArrayList)new Gson().fromJson((String)properties.computeIfAbsent("custom-blocks", (Function<? super Object, ?>)((Function<Object, Object>)a -> "[]")), listType)), new ArrayList<CustomBlock>(), FileData.Defaults.INTERACTION_BLOCKS, FileData.Defaults.ALLOWED_ABOVE_SEAT);
                SittingConfig defaultSittingConfig = new SittingConfig();
                SittingConfig sittingConfig = new SittingConfig();
                try {
                    sittingConfig = new SittingConfig(1.0, true, Boolean.parseBoolean((String)properties.computeIfAbsent("hand.sitting", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(defaultSittingConfig.canSitWithHand())))), new HandSetting(Legacy.handRequirementUpdater((String)properties.computeIfAbsent("hand.main.requirement", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf((Object)defaultSittingConfig.getHand(class_1268.field_5808).getSittingRequirement())))), new HandSetting.Filter(false, new HandSetting.Filter.Presets(!Boolean.parseBoolean((String)properties.computeIfAbsent("hand.main.block", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(!defaultSittingConfig.getHand(class_1268.field_5808).getFilter().getPresets().isBlock())))), !Boolean.parseBoolean((String)properties.computeIfAbsent("hand.main.food", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(!defaultSittingConfig.getHand(class_1268.field_5808).getFilter().getPresets().isFood())))), !Boolean.parseBoolean((String)properties.computeIfAbsent("hand.main.usable", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(!defaultSittingConfig.getHand(class_1268.field_5808).getFilter().getPresets().isUsable()))))), new CustomItem(Legacy.getFilterList((ArrayList)new Gson().fromJson((String)properties.computeIfAbsent("hand.main.whitelist", (Function<? super Object, ?>)((Function<Object, Object>)a -> "[]")), listType), (ArrayList)new Gson().fromJson((String)properties.computeIfAbsent("hand.main.blacklist", (Function<? super Object, ?>)((Function<Object, Object>)a -> "[]")), listType)), new ArrayList<String>()))), new HandSetting(Legacy.handRequirementUpdater((String)properties.computeIfAbsent("hand.off.requirement", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf((Object)defaultSittingConfig.getHand(class_1268.field_5810).getSittingRequirement())))), new HandSetting.Filter(false, new HandSetting.Filter.Presets(!Boolean.parseBoolean((String)properties.computeIfAbsent("hand.off.block", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(!defaultSittingConfig.getHand(class_1268.field_5810).getFilter().getPresets().isBlock())))), !Boolean.parseBoolean((String)properties.computeIfAbsent("hand.off.food", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(!defaultSittingConfig.getHand(class_1268.field_5810).getFilter().getPresets().isFood())))), !Boolean.parseBoolean((String)properties.computeIfAbsent("hand.off.usable", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(!defaultSittingConfig.getHand(class_1268.field_5810).getFilter().getPresets().isUsable()))))), new CustomItem(Legacy.getFilterList((ArrayList)new Gson().fromJson((String)properties.computeIfAbsent("hand.off.whitelist", (Function<? super Object, ?>)((Function<Object, Object>)a -> "[]")), listType), (ArrayList)new Gson().fromJson((String)properties.computeIfAbsent("hand.off.blacklist", (Function<? super Object, ?>)((Function<Object, Object>)a -> "[]")), listType)), new ArrayList<String>()))));
                }
                catch (JsonSyntaxException jsonSyntaxException) {
                    // empty catch block
                }
                if (version == 1.0) {
                    try {
                        sittingConfig = new SittingConfig(1.0, true, defaultSittingConfig.canSitWithHand(), new HandSetting(Legacy.handRequirementUpdater((String)properties.computeIfAbsent("main-hand-requirement", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf((Object)defaultSittingConfig.getHand(class_1268.field_5808).getSittingRequirement())))), new HandSetting.Filter(false, new HandSetting.Filter.Presets(!Boolean.parseBoolean((String)properties.computeIfAbsent("main-hand-block", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(!defaultSittingConfig.getHand(class_1268.field_5808).getFilter().getPresets().isBlock())))), !Boolean.parseBoolean((String)properties.computeIfAbsent("main-hand-food", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(!defaultSittingConfig.getHand(class_1268.field_5808).getFilter().getPresets().isFood())))), !Boolean.parseBoolean((String)properties.computeIfAbsent("main-hand-usable", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(!defaultSittingConfig.getHand(class_1268.field_5808).getFilter().getPresets().isUsable()))))), new CustomItem(Legacy.getFilterList((ArrayList)new Gson().fromJson((String)properties.computeIfAbsent("main-hand-whitelist", (Function<? super Object, ?>)((Function<Object, Object>)a -> "[]")), listType), (ArrayList)new Gson().fromJson((String)properties.computeIfAbsent("main-hand-blacklist", (Function<? super Object, ?>)((Function<Object, Object>)a -> "[]")), listType)), new ArrayList<String>()))), new HandSetting(Legacy.handRequirementUpdater((String)properties.computeIfAbsent("off-hand-requirement", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf((Object)defaultSittingConfig.getHand(class_1268.field_5810).getSittingRequirement())))), new HandSetting.Filter(false, new HandSetting.Filter.Presets(!Boolean.parseBoolean((String)properties.computeIfAbsent("off-hand-block", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(!defaultSittingConfig.getHand(class_1268.field_5810).getFilter().getPresets().isBlock())))), !Boolean.parseBoolean((String)properties.computeIfAbsent("off-hand-food", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(!defaultSittingConfig.getHand(class_1268.field_5810).getFilter().getPresets().isFood())))), !Boolean.parseBoolean((String)properties.computeIfAbsent("off-hand-usable", (Function<? super Object, ?>)((Function<Object, Object>)a -> String.valueOf(!defaultSittingConfig.getHand(class_1268.field_5810).getFilter().getPresets().isUsable()))))), new CustomItem(Legacy.getFilterList((ArrayList)new Gson().fromJson((String)properties.computeIfAbsent("off-hand-whitelist", (Function<? super Object, ?>)((Function<Object, Object>)a -> "[]")), listType), (ArrayList)new Gson().fromJson((String)properties.computeIfAbsent("off-hand-blacklist", (Function<? super Object, ?>)((Function<Object, Object>)a -> "[]")), listType)), new ArrayList<String>()))));
                    }
                    catch (JsonSyntaxException jsonSyntaxException) {
                        // empty catch block
                    }
                }
                Legacy.deleteLegacyFile();
                FileData.getServerConfig().copyFileData(serverConfig);
                FileData.getServerConfig().save();
                FileData.getSittingConfig().copyFileData(sittingConfig);
                FileData.getSittingConfig().save();
            }
            catch (Exception e) {
                Data.LOGGER.error("Error loading legacy config: %s", new Object[]{e.getMessage()});
            }
        }
    }
}

