/*
 * Decompiled with CFR 0.152.
 */
package one.oth3r.sit.utl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_2577;
import net.minecraft.class_2680;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5575;
import net.minecraft.class_7923;
import net.minecraft.class_8113;
import net.minecraft.class_8710;
import one.oth3r.otterlib.chat.CTxT;
import one.oth3r.otterlib.chat.ChatText;
import one.oth3r.sit.file.CustomBlock;
import one.oth3r.sit.file.FileData;
import one.oth3r.sit.file.HandSetting;
import one.oth3r.sit.file.ServerConfig;
import one.oth3r.sit.file.SittingBlock;
import one.oth3r.sit.packet.SitPayloads;
import one.oth3r.sit.utl.Chat;
import one.oth3r.sit.utl.Data;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utl {
    public static final double HALF_BLOCK = 0.5;
    public static final double CARPET = 0.062;

    public static boolean isNotObstructed(class_1937 world, class_2338 blockPos) {
        class_2680 state = world.method_8320(blockPos);
        if (Utl.blockIsInList(FileData.getServerConfig().getAllowedAboveSeat(), state)) {
            return true;
        }
        return state.method_26220((class_1922)world, blockPos).method_1110();
    }

    public static boolean isNotOccupied(class_2338 pos) {
        return Data.getSitEntities().values().stream().noneMatch(entity -> entity.method_24515().equals((Object)pos));
    }

    public static boolean checkItem(HandSetting.Filter filter, class_1799 itemStack) {
        boolean itemcheck;
        if (itemStack.method_7960()) {
            return true;
        }
        boolean TRUE = true;
        boolean FALSE = false;
        if (filter.isInverted().booleanValue()) {
            TRUE = false;
            FALSE = true;
        }
        if (itemcheck = filter.getCustomItems().checkItem(itemStack)) {
            return TRUE;
        }
        ArrayList<class_1839> food = new ArrayList<class_1839>();
        food.add(class_1839.field_8950);
        food.add(class_1839.field_8946);
        ArrayList<class_1839> notUsable = new ArrayList<class_1839>(food);
        notUsable.add(class_1839.field_8952);
        HandSetting.Filter.Presets presets = filter.getPresets();
        if (presets.isBlock() && itemStack.method_7909() instanceof class_1747) {
            return TRUE;
        }
        if (presets.isFood() && food.contains(itemStack.method_7976())) {
            return TRUE;
        }
        if (presets.isUsable() && !notUsable.contains(itemStack.method_7976())) {
            return TRUE;
        }
        return FALSE;
    }

    public static String getBlockID(class_2680 blockState) {
        return class_7923.field_41175.method_10221((Object)blockState.method_26204()).toString();
    }

    public static Double getSittingHeight(class_3222 player, class_2338 blockPos, @Nullable class_3965 hit) {
        class_3218 serverWorld = player.method_51469();
        ServerConfig config = FileData.getServerConfig();
        class_2680 blockState = serverWorld.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (hit != null && Utl.blockIsInList(config.getInteractionBlocks(), blockState)) {
            return null;
        }
        if (config.isCustomEnabled().booleanValue()) {
            if (Utl.blockIsInList(config.getBlacklistedBlocks(), blockState)) {
                return null;
            }
            for (SittingBlock sittingBlock : config.getSittingBlocks()) {
                if (!sittingBlock.isValid(blockState)) continue;
                return sittingBlock.getSittingHeight();
            }
        }
        if (block instanceof class_2510 && config.getPresetBlocks().isStairs() && blockState.method_11654((class_2769)class_2510.field_11572) == class_2760.field_12617) {
            return 0.5;
        }
        if (config.getPresetBlocks().isSlabs() && block instanceof class_2482 && blockState.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681) {
            return 0.5;
        }
        if (config.getPresetBlocks().isCarpets() && block instanceof class_2577) {
            return 0.062;
        }
        if (config.getPresetBlocks().isFullBlocks() && blockState.method_26234((class_1922)player.method_51469(), blockPos)) {
            return 1.0;
        }
        return null;
    }

    public static boolean blockIsInList(ArrayList<CustomBlock> blockList, class_2680 blockState) {
        return blockList.stream().anyMatch(c -> c.isValid(blockState));
    }

    public static void sendSettingsPackets() {
        if (Data.isClient() && Data.isInGame() && ClientPlayNetworking.canSend(SitPayloads.SettingsPayload.ID)) {
            ClientPlayNetworking.send((class_8710)new SitPayloads.SettingsPayload(Utl.getGson().toJson((Object)FileData.getSittingConfig())));
        }
    }

    public static Gson getGson() {
        return new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().registerTypeAdapterFactory((TypeAdapterFactory)new LenientTypeAdapterFactory()).create();
    }

    public static class_2338 getBlockPosPlayerIsLookingAt(class_3218 world, class_1657 player, double range) {
        class_243 rayEnd;
        class_243 rayStart = player.method_73189().method_1031(0.0, (double)player.method_18381(player.method_18376()), 0.0);
        class_3965 hitResult = world.method_17742(new class_3959(rayStart, rayEnd = rayStart.method_1019(player.method_5720().method_1021(range)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, class_3726.method_16194()));
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            return hitResult.method_17777();
        }
        return new class_2338((class_2382)player.method_24515());
    }

    public static double getPlayerReach(class_1657 player) {
        if (player.method_5996(class_5134.field_47758) != null) {
            return player.method_45325(class_5134.field_47758);
        }
        return 5.0;
    }

    public static class LenientTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            if (List.class.isAssignableFrom(type.getRawType())) {
                Type elementType = ((ParameterizedType)type.getType()).getActualTypeArguments()[0];
                TypeAdapter elementAdapter = gson.getAdapter(TypeToken.get((Type)elementType));
                return new RemoveNullListTypeAdapter(elementAdapter);
            }
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    delegate.write(out, value);
                }

                public T read(JsonReader in) throws IOException {
                    try {
                        return delegate.read(in);
                    }
                    catch (JsonSyntaxException | MalformedJsonException e) {
                        in.skipValue();
                        return null;
                    }
                }
            };
        }
    }

    private static class RemoveNullListTypeAdapter<E>
    extends TypeAdapter<List<E>> {
        private final TypeAdapter<E> elementAdapter;

        RemoveNullListTypeAdapter(TypeAdapter<E> elementAdapter) {
            this.elementAdapter = elementAdapter;
        }

        public void write(JsonWriter out, List<E> value) throws IOException {
            out.beginArray();
            for (E element : value) {
                this.elementAdapter.write(out, element);
            }
            out.endArray();
        }

        public List<E> read(JsonReader in) throws IOException {
            ArrayList<Object> list = new ArrayList<Object>();
            in.beginArray();
            while (in.hasNext()) {
                try {
                    Object element = this.elementAdapter.read(in);
                    if (element == null) continue;
                    list.add(element);
                }
                catch (Exception e) {
                    in.skipValue();
                }
            }
            in.endArray();
            return list;
        }
    }

    public static class Entity {
        public static final double Y_ADJUSTMENT = 0.0;

        public static boolean isValid(class_3222 player, @NotNull class_8113.class_8123 entity) {
            class_2338 blockPos = Entity.getBlockPos(entity);
            class_2680 blockState = player.method_51469().method_8320(blockPos);
            return !blockState.method_26215() && Utl.getSittingHeight(player, blockPos, null) != null;
        }

        public static class_2338 getBlockPos(class_8113.class_8123 entity) {
            int entityBlockY = (int)Math.floor(entity.method_23318() + -0.0);
            class_2338 pos = new class_2338(entity.method_31477(), entityBlockY, entity.method_31479());
            if (Entity.isAboveBlockHeight(entity)) {
                pos = pos.method_10069(0, -1, 0);
            }
            return pos;
        }

        public static boolean isAboveBlockHeight(class_8113.class_8123 entity) {
            return entity.method_36455() > 0.0f;
        }

        public static class_8113.class_8123 create(class_1937 world, class_2338 blockPos, double sitHeight) {
            class_8113.class_8123 entity = new class_8113.class_8123(class_1299.field_42457, world);
            entity.method_5665(class_2561.method_30163((String)"-sit!-entity-"));
            entity.method_5880(false);
            entity.method_5684(true);
            entity.method_5648(true);
            double entityY = blockPos.method_10264();
            entity.method_30634((double)blockPos.method_10263() + 0.5, entityY += sitHeight, (double)blockPos.method_10260() + 0.5);
            if (entity.method_23318() == (double)(blockPos.method_10264() + 1)) {
                entity.method_36457(90.0f);
            } else {
                entity.method_36457(-90.0f);
            }
            entity.method_30634(entity.method_23317(), entityY + 0.0, entity.method_23321());
            return entity;
        }

        public static void remove(class_8113.class_8123 entity) {
            entity.method_5772();
            entity.method_31745(class_1297.class_5529.field_26999);
            Data.removeSitEntity(entity);
        }

        public static void spawnSit(class_3222 player, class_8113.class_8123 entity) {
            Data.setSpawnList(player, entity);
        }

        public static void purge(class_3222 player, boolean message) {
            List list = player.method_51469().method_18198(class_5575.method_31795(class_8113.class_8123.class), entity -> entity.method_5477().getString().equals("-sit!-entity-"));
            int count = 0;
            for (class_8113.class_8123 entity2 : list) {
                Entity.remove(entity2);
                ++count;
            }
            if (message) {
                player.method_64398((class_2561)((CTxT)Chat.tag().append((ChatText)((CTxT)Chat.lang("sit!.chat.purged", ((CTxT)Chat.lang("sit!.chat.purged.total", count).color(Color.gray)).b()).color(Color.GREEN)))).b());
            }
        }
    }
}

