/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.containerutils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Dispenser;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.garsooon.containerutils.ContainerUtilsListener;
import org.garsooon.containerutils.RestockCommand;
import org.yaml.snakeyaml.Yaml;

public class ContainerUtils
extends JavaPlugin {
    public final Map<String, ItemStack[]> containerTemplates = new ConcurrentHashMap<String, ItemStack[]>();
    public final Map<String, Integer> containerTimers = new ConcurrentHashMap<String, Integer>();
    public final Map<String, Integer> containerRestockTimes = new ConcurrentHashMap<String, Integer>();
    public final Map<UUID, Integer> pendingRestockTimes = new HashMap<UUID, Integer>();
    public final Set<UUID> createModePlayers = new HashSet<UUID>();
    public int defaultRestockTime = 300;
    public boolean announceRestock = false;
    private RestockCommand commandHandler;
    private ContainerUtilsListener eventListener;
    private File configFile;
    private Yaml yaml = new Yaml();
    private Map<String, Object> config = new HashMap<String, Object>();

    public void onEnable() {
        System.out.println(ChatColor.GREEN + "[ContainerUtils] Plugin enabled.");
        this.loadConfig();
        this.loadRestockData();
        this.eventListener = new ContainerUtilsListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.eventListener, (Plugin)this);
        this.commandHandler = new RestockCommand(this);
        if (this.getCommand("restock") != null) {
            this.getCommand("restock").setExecutor((CommandExecutor)this.commandHandler);
        } else {
            System.out.println(ChatColor.RED + "[ContainerUtils] Command 'restock' not found in plugin.yml!");
        }
        this.startRestockTimer();
    }

    public void onDisable() {
        System.out.println(ChatColor.YELLOW + "[ContainerUtils] Plugin disabled.");
        this.saveRestockData();
        this.containerTemplates.clear();
        this.containerTimers.clear();
        this.containerRestockTimes.clear();
        this.createModePlayers.clear();
    }

    public void loadConfig() {
        this.configFile = new File(this.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            this.getDataFolder().mkdirs();
            this.config.put("default-restock-time", 300);
            this.config.put("announce-restock", false);
            this.config.put("allow-player-registration", true);
            this.saveConfigFile();
        }
        try (FileInputStream input = new FileInputStream(this.configFile);){
            Object loaded = this.yaml.load((InputStream)input);
            if (loaded instanceof Map) {
                this.config = (Map)loaded;
            } else {
                System.out.println(ChatColor.RED + "[ContainerUtils] Config file is not a valid map. Using defaults.");
            }
        }
        catch (Exception e) {
            System.out.println(ChatColor.RED + "[ContainerUtils] Failed to load config: " + e.getMessage());
        }
        this.defaultRestockTime = this.getInt("default-restock-time", 300);
        this.announceRestock = this.getBoolean("announce-restock", false);
    }

    public void saveConfigFile() {
        try (FileWriter writer = new FileWriter(this.configFile);){
            this.yaml.dump(this.config, (Writer)writer);
        }
        catch (IOException e) {
            System.out.println(ChatColor.RED + "[ContainerUtils] Failed to save config: " + e.getMessage());
        }
    }

    public void reloadConfigFile() {
        this.loadConfig();
    }

    public void loadRestockData() {
        File file = new File(this.getDataFolder(), "restocks.yml");
        if (!file.exists()) {
            System.out.println("[ContainerUtils] No restocks.yml file found.");
            return;
        }
        try (FileInputStream input = new FileInputStream(file);){
            Object raw = this.yaml.load((InputStream)input);
            if (!(raw instanceof Map)) {
                return;
            }
            Map data = (Map)raw;
            for (Map.Entry entry : data.entrySet()) {
                String loc = (String)entry.getKey();
                Map containerData = (Map)entry.getValue();
                List itemData = (List)containerData.get("items");
                int timer = (Integer)containerData.get("timer");
                int customTime = containerData.containsKey("restock_time") ? (Integer)containerData.get("restock_time") : this.defaultRestockTime;
                ItemStack[] contents = new ItemStack[itemData.size()];
                for (int i = 0; i < itemData.size(); ++i) {
                    Map itemMap = (Map)itemData.get(i);
                    contents[i] = itemMap != null ? ContainerUtils.deserializeItemStack(itemMap) : null;
                }
                this.containerTemplates.put(loc, contents);
                this.containerTimers.put(loc, timer);
                this.containerRestockTimes.put(loc, customTime);
            }
            System.out.println(ChatColor.GREEN + "[ContainerUtils] Loaded restock data from restocks.yml");
        }
        catch (Exception e) {
            System.out.println(ChatColor.RED + "[ContainerUtils] Failed to load restock data: " + e.getMessage());
        }
    }

    public void saveRestockData() {
        File file = new File(this.getDataFolder(), "restocks.yml");
        HashMap data = new HashMap();
        for (Map.Entry<String, ItemStack[]> entry : this.containerTemplates.entrySet()) {
            String loc = entry.getKey();
            ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
            for (ItemStack item : entry.getValue()) {
                items.add(item != null ? ContainerUtils.serializeItemStack(item) : null);
            }
            HashMap<String, Serializable> containerData = new HashMap<String, Serializable>();
            containerData.put("items", items);
            containerData.put("timer", this.containerTimers.getOrDefault(loc, this.defaultRestockTime));
            containerData.put("restock_time", this.containerRestockTimes.getOrDefault(loc, this.defaultRestockTime));
            data.put(loc, containerData);
        }
        try (FileWriter writer = new FileWriter(file);){
            this.yaml.dump(data, (Writer)writer);
            System.out.println(ChatColor.GREEN + "[ContainerUtils] Saved restock data to restocks.yml");
        }
        catch (IOException e) {
            System.out.println(ChatColor.RED + "[ContainerUtils] Failed to save restock data: " + e.getMessage());
        }
    }

    public static Map<String, Object> serializeItemStack(ItemStack item) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", item.getType().name());
        map.put("amount", item.getAmount());
        map.put("durability", item.getDurability());
        return map;
    }

    public static ItemStack deserializeItemStack(Map<String, Object> map) {
        Material type = Material.matchMaterial((String)((String)map.get("type")));
        int amount = (Integer)map.get("amount");
        short durability = map.containsKey("durability") ? ((Integer)map.get("durability")).shortValue() : (short)0;
        return new ItemStack(type, amount, durability);
    }

    public boolean isContainer(Block block) {
        Material type = block.getType();
        return type == Material.CHEST || type == Material.DISPENSER;
    }

    public void registerContainer(Block block, Player player) {
        BlockState state = block.getState();
        Inventory inv = this.getInventoryFromState(state);
        if (inv == null) {
            player.sendMessage(ChatColor.RED + "Cannot register container: Inventory not accessible.");
            System.out.println(ChatColor.RED + "[ContainerUtils] Failed to get inventory for container at " + this.getLocationKey(block));
            return;
        }
        String key = this.getLocationKey(block);
        ItemStack[] template = new ItemStack[inv.getSize()];
        for (int i = 0; i < inv.getSize(); ++i) {
            ItemStack item = inv.getItem(i);
            if (item == null || item.getType() == Material.AIR || item.getAmount() <= 0) continue;
            template[i] = item.clone();
        }
        this.containerTemplates.put(key, template);
        this.containerTimers.put(key, this.defaultRestockTime);
        this.containerRestockTimes.put(key, this.defaultRestockTime);
        player.sendMessage(ChatColor.GREEN + "Container registered for restocking! Punch without sneaking to restock.");
        System.out.println(ChatColor.GREEN + "[ContainerUtils] Registered container at " + key + " with " + inv.getSize() + " slots.");
        this.saveRestockData();
    }

    public void clearRegisteredContainers() {
        this.containerTemplates.clear();
        this.containerTimers.clear();
        this.containerRestockTimes.clear();
        this.saveRestockData();
    }

    public void restockContainer(Block block, Player player) {
        String key = this.getLocationKey(block);
        ItemStack[] template = this.containerTemplates.get(key);
        if (template == null) {
            player.sendMessage(ChatColor.RED + "This container is not registered for restocking.");
            return;
        }
        Inventory inv = this.getInventoryFromState(block.getState());
        if (inv == null) {
            player.sendMessage(ChatColor.RED + "Cannot restock container: Inventory not accessible.");
            return;
        }
        inv.clear();
        for (int i = 0; i < template.length && i < inv.getSize(); ++i) {
            if (template[i] == null) continue;
            inv.setItem(i, template[i].clone());
        }
        this.containerTimers.put(key, this.containerRestockTimes.getOrDefault(key, this.defaultRestockTime));
        if (player != null) {
            player.sendMessage(ChatColor.GREEN + "Container restocked!");
        }
    }

    private void startRestockTimer() {
        this.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
            for (Map.Entry<String, Integer> entry : this.containerTimers.entrySet()) {
                String key = entry.getKey();
                int timeLeft = entry.getValue();
                if (timeLeft <= 0) {
                    this.autoRestockContainer(key);
                    this.containerTimers.put(key, this.containerRestockTimes.getOrDefault(key, this.defaultRestockTime));
                    continue;
                }
                this.containerTimers.put(key, timeLeft - 1);
            }
        }, 20L, 20L);
    }

    private void autoRestockContainer(String key) {
        String[] parts = key.split(":");
        if (parts.length != 4) {
            return;
        }
        try {
            String world = parts[0];
            int x = Integer.parseInt(parts[1]);
            int y = Integer.parseInt(parts[2]);
            int z = Integer.parseInt(parts[3]);
            Block block = this.getServer().getWorld(world).getBlockAt(x, y, z);
            if (!this.isContainer(block)) {
                this.containerTemplates.remove(key);
                this.containerTimers.remove(key);
                this.containerRestockTimes.remove(key);
                return;
            }
            ItemStack[] template = this.containerTemplates.get(key);
            if (template == null) {
                return;
            }
            Inventory inv = this.getInventoryFromState(block.getState());
            if (inv == null) {
                return;
            }
            inv.clear();
            for (int i = 0; i < template.length && i < inv.getSize(); ++i) {
                if (template[i] == null) continue;
                inv.setItem(i, template[i].clone());
            }
            if (this.announceRestock) {
                for (Player p : this.getServer().getOnlinePlayers()) {
                    if (!p.getWorld().getName().equals(world) || !(p.getLocation().distance(block.getLocation()) <= 10.0)) continue;
                    p.sendMessage(ChatColor.GRAY + "Container auto-restocked nearby.");
                }
            }
        }
        catch (Exception e) {
            System.out.println(ChatColor.RED + "[ContainerUtils] Error auto-restocking container: " + e.getMessage());
        }
    }

    private Inventory getInventoryFromState(BlockState state) {
        if (state instanceof Chest) {
            return ((Chest)state).getInventory();
        }
        if (state instanceof Dispenser) {
            return ((Dispenser)state).getInventory();
        }
        return null;
    }

    public String getLocationKey(Block block) {
        return block.getWorld().getName() + ":" + block.getX() + ":" + block.getY() + ":" + block.getZ();
    }

    private int getInt(String key, int def) {
        Object value = this.config.get(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        Object value = this.config.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value);
        }
        return def;
    }

    public Map<String, ItemStack[]> getContainerTemplates() {
        return this.containerTemplates;
    }

    public Map<String, Integer> getContainerTimers() {
        return this.containerTimers;
    }

    public int getDefaultRestockTime() {
        return this.defaultRestockTime;
    }

    public void setDefaultRestockTime(int time) {
        this.defaultRestockTime = time;
        this.config.put("default-restock-time", time);
        this.saveConfigFile();
    }

    public boolean isAnnounceRestock() {
        return this.announceRestock;
    }
}

