/*
 * Decompiled with CFR 0.152.
 */
package org.garsooon.containerutils;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.garsooon.containerutils.ContainerUtils;

public class ContainerUtilsListener
implements Listener {
    private final ContainerUtils plugin;

    public ContainerUtilsListener(ContainerUtils plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.LEFT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !this.isContainer(block)) {
            return;
        }
        Player player = event.getPlayer();
        String locationKey = this.plugin.getLocationKey(block);
        if (this.plugin.pendingRestockTimes.containsKey(player.getUniqueId())) {
            int seconds = this.plugin.pendingRestockTimes.remove(player.getUniqueId());
            if (!this.plugin.getContainerTemplates().containsKey(locationKey)) {
                player.sendMessage(ChatColor.RED + "This container is not registered.");
                return;
            }
            this.plugin.containerRestockTimes.put(locationKey, seconds);
            this.plugin.containerTimers.put(locationKey, seconds);
            this.plugin.saveRestockData();
            player.sendMessage(ChatColor.GREEN + "Restock time for this container set to " + seconds + " seconds.");
            event.setCancelled(true);
            return;
        }
        if (!player.hasPermission("containerutils.admin")) {
            player.sendMessage(ChatColor.RED + "You don't have permission to use container utilities.");
            return;
        }
        boolean allowRegistration = this.plugin.getBoolean("allow-player-registration", true);
        if (!allowRegistration && !player.hasPermission("containerutils.admin")) {
            player.sendMessage(ChatColor.RED + "Container registration is disabled for players.");
            return;
        }
        if (this.plugin.createModePlayers.contains(player.getUniqueId())) {
            this.plugin.createModePlayers.remove(player.getUniqueId());
            this.plugin.registerContainer(block, player);
            event.setCancelled(true);
            return;
        }
        if (this.plugin.getContainerTemplates().containsKey(locationKey)) {
            this.plugin.restockContainer(block, player);
            event.setCancelled(true);
        }
    }

    private boolean isContainer(Block block) {
        Material material = block.getType();
        return material == Material.CHEST || material == Material.DISPENSER;
    }
}

