/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedtunnels.part.PartTypes;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspects;

@GameTestHolder(value="integratedtunnels")
@PrefixGameTestTemplate(value=false)
public class GameTestsWorldItem {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final int TIMEOUT = 2000;
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testWorldItemImporterToInterfaceToExporterBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_WORLD_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_WORLD_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_WORLD_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_WORLD_ITEM.getItem()));
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.spawnItem(Blocks.STONE.asItem(), POS.west());
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.World.ENTITYITEM_BOOLEAN_IMPORT, (ItemStack)variableAspect);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.World.ENTITYITEM_BOOLEAN_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertItemEntityNotPresent(Blocks.STONE.asItem(), POS.west(), 0.25);
            helper.assertContainerEmpty(POS.west());
            helper.assertItemEntityPresent(Blocks.STONE.asItem(), POS.east().north(), 0.25);
        });
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testWorldItemImporterToInterfaceToExporterBlockCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_WORLD_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_WORLD_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_WORLD_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_WORLD_ITEM.getItem()));
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.spawnItem(Blocks.STONE.asItem(), POS.west());
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.World.ENTITYITEM_ITEMSTACK_IMPORT, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_ITEMSTACK, (IValue)ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Blocks.STONE))));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.World.ENTITYITEM_BOOLEAN_EXPORT, (ItemStack)new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE));
        helper.succeedWhen(() -> {
            helper.assertItemEntityNotPresent(Blocks.STONE.asItem(), POS.west(), 0.25);
            helper.assertContainerEmpty(POS.west());
            helper.assertItemEntityPresent(Blocks.STONE.asItem(), POS.east().north(), 0.25);
        });
    }

    @GameTest(template="empty10", timeoutTicks=2000)
    public void testWorldItemImporterToInterfaceToExporterBlockIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_WORLD_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_WORLD_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_WORLD_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_WORLD_ITEM.getItem()));
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.spawnItem(Blocks.STONE.asItem(), POS.west());
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.World.ENTITYITEM_ITEMSTACK_IMPORT, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_ITEMSTACK, (IValue)ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Blocks.COBBLESTONE))));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.World.ENTITYITEM_BOOLEAN_EXPORT, (ItemStack)new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE));
        helper.succeedWhen(() -> {
            helper.assertItemEntityPresent(Blocks.STONE.asItem(), POS.west(), 0.25);
            helper.assertContainerEmpty(POS.west());
            helper.assertItemEntityNotPresent(Blocks.STONE.asItem(), POS.east().north(), 0.25);
        });
    }
}

