/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import java.util.Optional;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.network.IEnergyNetwork;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.core.TunnelHelpers;
import org.cyclops.integratedtunnels.core.part.PartStatePositionedAddon;

public class PartStateEnergy<P extends IPartTypeWriter>
extends PartStatePositionedAddon<P, IEnergyNetwork, Long>
implements IEnergyStorage {
    public PartStateEnergy(int inventorySize, boolean canReceive, boolean canExtract) {
        super(inventorySize, canReceive, canExtract);
    }

    public <T> Optional<T> getCapability(P partType, PartCapability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
        if (capability == Capabilities.EnergyStorage.PART) {
            return Optional.of(this);
        }
        return super.getCapability(partType, capability, network, partNetwork, target);
    }

    protected IEnergyStorage getEnergyStorage() {
        return (IEnergyStorage)((IEnergyNetwork)this.getPositionedAddonsNetwork()).getChannelExternal(Capabilities.EnergyStorage.BLOCK, TunnelHelpers.getPassiveInteractionChannel(this));
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        maxReceive = Math.min(maxReceive, GeneralConfig.energyRateLimit);
        return this.canReceive() && this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null && this.getStorageFilter().testInsertion((Object)maxReceive) ? this.getEnergyStorage().receiveEnergy(maxReceive, simulate) : 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        maxExtract = Math.min(maxExtract, GeneralConfig.energyRateLimit);
        return this.canExtract() && this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null && this.getStorageFilter().testExtraction((Object)maxExtract) ? this.getEnergyStorage().extractEnergy(maxExtract, simulate) : 0;
    }

    public int getEnergyStored() {
        if (this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null) {
            int stored = this.getEnergyStorage().getEnergyStored();
            if (this.getStorageFilter().testView((Object)stored)) {
                return stored;
            }
        }
        return 0;
    }

    public int getMaxEnergyStored() {
        return this.getPositionedAddonsNetwork() != null && this.getStorageFilter() != null ? this.getEnergyStorage().getMaxEnergyStored() : 0;
    }
}

