/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.blockentity.BlockEntityDryingBasin;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedtunnels.part.PartTypes;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspects;

public class GameTestsFluids {
    public static final String TEMPLATE_EMPTY = "integratedtunnels:empty10";
    public static final int TIMEOUT = 2000;
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidImporterToInterfaceBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin out does not contain fluids"));
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin in was not drained"));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.IMPORTER_FLUID.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.Fluid.BOOLEAN_IMPORT).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidInterfaceToExporterBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.EXPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), TunnelAspects.Write.Fluid.BOOLEAN_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin out does not contain fluids"));
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin in was not drained"));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Exporter is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.EXPORTER_FLUID.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)), Direction.EAST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.Fluid.BOOLEAN_EXPORT, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.Fluid.BOOLEAN_EXPORT).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidImporterToInterfaceToExporterBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().north(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectExporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.Fluid.BOOLEAN_EXPORT, (ItemStack)variableAspectExporter);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinInterface = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().north(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinInterface.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin interface was not drained"));
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin out does not contain fluids"));
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin in was not drained"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidImporterToInterfaceToExporterBooleanCauldron(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_FLUID.getItem()));
        helper.setBlock(POS.west(), (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3)));
        helper.setBlock(POS.east().east(), Blocks.CAULDRON);
        helper.setBlock(POS.east().north(), Blocks.CAULDRON);
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectExporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.Fluid.BOOLEAN_EXPORT, (ItemStack)variableAspectExporter);
        helper.succeedWhen(() -> {
            helper.assertBlockPresent(Blocks.CAULDRON, POS.west());
            helper.assertBlockPresent(Blocks.CAULDRON, POS.east().east());
            helper.assertBlockPresent(Blocks.WATER_CAULDRON, POS.east().north());
            helper.assertBlockProperty(POS.east().north(), (Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(3));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidsImporterToInterfaceFluidCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_FLUIDSTACK, (IValue)ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 100)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.FLUIDSTACK_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin out does not contain fluids"));
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin in was not drained"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidsImporterToInterfaceFluidIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_FLUIDSTACK, (IValue)ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.LAVA, 100)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.FLUIDSTACK_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin out was filled"));
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin in was drained"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidsImporterToFilteredInterfaceBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FILTERING_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FILTERING_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectInterface = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), TunnelAspects.Write.FluidFilter.BOOLEAN_SET_FILTER, (ItemStack)variableAspectInterface);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin out does not contain fluids"));
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin in was not drained"));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.IMPORTER_FLUID.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status importer is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, (Component)Component.literal((String)"Active aspect importer is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.Fluid.BOOLEAN_IMPORT).isEmpty(), (Component)Component.literal((String)"Active aspect importer has errors"));
            IPartStateWriter partStateInterface = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)).getState();
            helper.assertFalse(partStateInterface.isDeactivated(), (Component)Component.literal((String)"Filtering interface is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.INTERFACE_FILTERING_FLUID.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)), Direction.EAST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status filtering interface is incorrect"));
            helper.assertValueEqual((Object)partStateInterface.getActiveAspect(), TunnelAspects.Write.FluidFilter.BOOLEAN_SET_FILTER, (Component)Component.literal((String)"Active aspect filtering interface is incorrect"));
            helper.assertTrue(partStateInterface.getErrors(TunnelAspects.Write.FluidFilter.BOOLEAN_SET_FILTER).isEmpty(), (Component)Component.literal((String)"Active aspect filtering interface has errors"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidsImporterToFilteredInterfaceFluidCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FILTERING_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FILTERING_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectInterface = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_FLUIDSTACK, (IValue)ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 100)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), TunnelAspects.Write.FluidFilter.FLUIDSTACK_SET_FILTER, (ItemStack)variableAspectInterface);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin out does not contain fluids"));
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin in was not drained"));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.IMPORTER_FLUID.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status importer is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, (Component)Component.literal((String)"Active aspect importer is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.Fluid.BOOLEAN_IMPORT).isEmpty(), (Component)Component.literal((String)"Active aspect importer has errors"));
            IPartStateWriter partStateInterface = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)).getState();
            helper.assertFalse(partStateInterface.isDeactivated(), (Component)Component.literal((String)"Filtering interface is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.INTERFACE_FILTERING_FLUID.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)), Direction.EAST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status filtering interface is incorrect"));
            helper.assertValueEqual((Object)partStateInterface.getActiveAspect(), TunnelAspects.Write.FluidFilter.FLUIDSTACK_SET_FILTER, (Component)Component.literal((String)"Active aspect filtering interface is incorrect"));
            helper.assertTrue(partStateInterface.getErrors(TunnelAspects.Write.FluidFilter.FLUIDSTACK_SET_FILTER).isEmpty(), (Component)Component.literal((String)"Active aspect filtering interface has errors"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidsImporterToFilteredInterfaceFluidIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FILTERING_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FILTERING_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectInterface = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_FLUIDSTACK, (IValue)ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.LAVA, 100)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), TunnelAspects.Write.FluidFilter.FLUIDSTACK_SET_FILTER, (ItemStack)variableAspectInterface);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin out contains fluids"));
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin in was drained"));
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.IMPORTER_FLUID.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status importer is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.Fluid.BOOLEAN_IMPORT, (Component)Component.literal((String)"Active aspect importer is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.Fluid.BOOLEAN_IMPORT).isEmpty(), (Component)Component.literal((String)"Active aspect importer has errors"));
            IPartStateWriter partStateInterface = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)).getState();
            helper.assertFalse(partStateInterface.isDeactivated(), (Component)Component.literal((String)"Filtering interface is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.INTERFACE_FILTERING_FLUID.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)), Direction.EAST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status filtering interface is incorrect"));
            helper.assertValueEqual((Object)partStateInterface.getActiveAspect(), TunnelAspects.Write.FluidFilter.FLUIDSTACK_SET_FILTER, (Component)Component.literal((String)"Active aspect filtering interface is incorrect"));
            helper.assertTrue(partStateInterface.getErrors(TunnelAspects.Write.FluidFilter.FLUIDSTACK_SET_FILTER).isEmpty(), (Component)Component.literal((String)"Active aspect filtering interface has errors"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidsImporterToInterfaceFluidListCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeFluidStack.ValueFluidStack[]{ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.LAVA, 100)), ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 100))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.LIST_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin out does not contain fluids"));
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin in was not drained"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidsImporterToInterfaceFluidListIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspectImporter = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeFluidStack.ValueFluidStack[]{ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.LAVA, 100)), ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.FLOWING_LAVA, 100))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.LIST_IMPORT, (ItemStack)variableAspectImporter);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin out contains fluids"));
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin in was drained"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidsImporterToInterfaceFluidListBlacklistCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeFluidStack.ValueFluidStack[]{ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.LAVA, 100)), ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.FLOWING_LAVA, 100))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.LIST_IMPORT, (ItemStack)variableAspect);
        PartPos posImporter = PartPos.of((DimPos)DimPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS)), (Direction)Direction.WEST);
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)posImporter);
        IAspectProperties properties = TunnelAspects.Write.Fluid.LIST_IMPORT.getProperties(partStateHolder.getPart(), PartTarget.fromCenter((PartPos)posImporter), partStateHolder.getState());
        properties.setValue(TunnelAspectWriteBuilders.PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
        partStateHolder.getState().setAspectProperties(TunnelAspects.Write.Fluid.LIST_IMPORT, properties);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin out does not contain fluids"));
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin in was not drained"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidsImporterToInterfaceFluidListBlacklistIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeFluidStack.ValueFluidStack[]{ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 100)), ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.LAVA, 100))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Fluid.LIST_IMPORT, (ItemStack)variableAspect);
        PartPos posImporter = PartPos.of((DimPos)DimPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS)), (Direction)Direction.WEST);
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)posImporter);
        IAspectProperties properties = TunnelAspects.Write.Fluid.LIST_IMPORT.getProperties(partStateHolder.getPart(), PartTarget.fromCenter((PartPos)posImporter), partStateHolder.getState());
        properties.setValue(TunnelAspectWriteBuilders.PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
        partStateHolder.getState().setAspectProperties(TunnelAspects.Write.Fluid.LIST_IMPORT, properties);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin out contains fluids"));
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin in was drained"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidInterfaceToWorldExporterListCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.EXPORTER_WORLD_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeFluidStack.ValueFluidStack[]{ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.LAVA, 1000)), ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 1000))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), TunnelAspects.Write.World.FLUID_LIST_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin in was not drained"));
            helper.assertBlockPresent(Blocks.WATER, POS.east().east());
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidInterfaceToWorldExporterListIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.EXPORTER_WORLD_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        basinIn.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeFluidStack.ValueFluidStack[]{ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.LAVA, 1000)), ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.FLOWING_LAVA, 1000))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), TunnelAspects.Write.World.FLUID_LIST_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)basinIn.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin in was drained"));
            helper.assertBlockNotPresent(Blocks.WATER, POS.east().east());
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidInterfacesToWorldExporterListCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.NORTH, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.SOUTH, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.EXPORTER_WORLD_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.south(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn1 = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west(), BlockEntityDryingBasin.class);
        BlockEntityDryingBasin basinIn2 = (BlockEntityDryingBasin)helper.getBlockEntity(POS.north(), BlockEntityDryingBasin.class);
        BlockEntityDryingBasin basinIn3 = (BlockEntityDryingBasin)helper.getBlockEntity(POS.south(), BlockEntityDryingBasin.class);
        basinIn1.getTank().setFluid(new FluidStack((Holder)RegistryEntries.FLUID_MENRIL_RESIN, 1000));
        basinIn2.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        basinIn3.getTank().setFluid(new FluidStack((Fluid)Fluids.LAVA, 1000));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeFluidStack.ValueFluidStack[]{ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.WATER, 1000)), ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Fluid)Fluids.LAVA, 1000))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), TunnelAspects.Write.World.FLUID_LIST_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertValueEqual((Object)basinIn1.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin in 1 was drained"));
            helper.assertValueEqual((Object)basinIn2.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin in 2 was not drained"));
            helper.assertValueEqual((Object)basinIn3.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin in 3 was drained"));
            helper.assertBlockPresent(Blocks.WATER, POS.east().east());
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testFluidInterfaceToExporterFluidFromSubnet(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.EXPORTER_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_FLUID.getItem()));
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.west()), (Direction)Direction.WEST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.west()), (Direction)Direction.NORTH, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.west()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FLUID, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FLUID.getItem()));
        helper.setBlock(POS.west().west(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.west().north(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        helper.setBlock(POS.east().east(), (Block)RegistryEntries.BLOCK_DRYING_BASIN.get());
        BlockEntityDryingBasin basinIn1 = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west().west(), BlockEntityDryingBasin.class);
        basinIn1.getTank().setFluid(new FluidStack((Fluid)Fluids.WATER, 1000));
        BlockEntityDryingBasin basinIn2 = (BlockEntityDryingBasin)helper.getBlockEntity(POS.west().north(), BlockEntityDryingBasin.class);
        basinIn2.getTank().setFluid(new FluidStack((Holder)RegistryEntries.FLUID_MENRIL_RESIN, 1000));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_FLUIDSTACK, (IValue)ValueObjectTypeFluidStack.ValueFluidStack.of((FluidStack)new FluidStack((Holder)RegistryEntries.FLUID_MENRIL_RESIN, 100)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), TunnelAspects.Write.Fluid.FLUIDSTACK_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            BlockEntityDryingBasin basinOut = (BlockEntityDryingBasin)helper.getBlockEntity(POS.east().east(), BlockEntityDryingBasin.class);
            helper.assertValueEqual((Object)basinOut.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin out does not contain fluids"));
            helper.assertValueEqual((Object)basinOut.getTank().getFluidType(), (Object)((Fluid)RegistryEntries.FLUID_MENRIL_RESIN.get()), (Component)Component.literal((String)"Basin out does not contain the correct fluid type"));
            helper.assertValueEqual((Object)basinIn1.getTank().getFluidAmount(), (Object)1000, (Component)Component.literal((String)"Basin in 1 was incorrectly drained"));
            helper.assertValueEqual((Object)basinIn2.getTank().getFluidAmount(), (Object)0, (Component)Component.literal((String)"Basin in 2 was not drained"));
        });
    }
}

