/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import org.cyclops.integratedtunnels.core.FakeNetHandlerPlayServer;

public class ExtendedFakePlayer
extends FakePlayer {
    private static GameProfile PROFILE = new GameProfile(UUID.fromString("41C82C87-7AfB-4024-BB57-13D2C99CAE77"), "[IntegratedTunnels]");
    private long lastUpdateTick = 0L;
    private long lastSwingUpdateTick = 0L;
    private int ticksSinceLastTick = 0;

    public ExtendedFakePlayer(ServerLevel world) {
        super(world, PROFILE);
        this.gameMode.changeGameModeForPlayer(GameType.SURVIVAL);
        this.connection = new FakeNetHandlerPlayServer(world.getServer(), (ServerPlayer)this);
    }

    public boolean canBeAffected(MobEffectInstance potioneffectIn) {
        return false;
    }

    public void tick() {
        super.tick();
        ServerLevel level = this.level();
        int toTick = (int)(level.getGameTime() - this.lastUpdateTick);
        if (toTick > 0) {
            this.ticksSinceLastTick = toTick;
        }
        this.lastUpdateTick = level.getGameTime();
        this.attackStrengthTicker = (int)(level.getGameTime() - this.lastSwingUpdateTick);
        this.getInventory().tick();
        this.getCooldowns().tick();
    }

    public void resetAttackStrengthTicker() {
        super.resetAttackStrengthTicker();
        this.lastSwingUpdateTick = this.level().getGameTime();
    }

    public void updateActiveHandSimulated() {
        if (this.isUsingItem()) {
            for (int i = 0; i < this.ticksSinceLastTick; ++i) {
                if (!this.isUsingItem()) continue;
                ItemStack itemstack = this.getItemInHand(this.getUsedItemHand());
                if (CommonHooks.canContinueUsing((ItemStack)this.useItem, (ItemStack)itemstack)) {
                    this.useItem = itemstack;
                }
                if (itemstack == this.useItem) {
                    if (!this.useItem.isEmpty()) {
                        this.useItemRemaining = EventHooks.onItemUseTick((LivingEntity)this, (ItemStack)this.useItem, (int)this.useItemRemaining);
                        if (this.useItemRemaining > 0) {
                            this.useItem.getItem().onUseTick((Level)this.level(), (LivingEntity)this, this.useItem, this.useItemRemaining);
                        }
                    }
                    if (--this.useItemRemaining > 0 || this.level().isClientSide() || this.useItem.useOnRelease()) continue;
                    this.completeUsingItem();
                } else {
                    this.stopUsingItem();
                }
                break;
            }
        } else {
            this.stopUsingItem();
        }
    }

    public void startSleeping(BlockPos blockPos) {
    }
}

