/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorageSlotted;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.ingredient.storage.InconsistentIngredientInsertionException;
import org.cyclops.cyclopscore.ingredient.storage.IngredientStorageHelpers;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.ingredient.IIngredientPositionsIndex;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkCraftingHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.part.write.PartStateWriterBase;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.IntegratedTunnels;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;
import org.cyclops.integratedtunnels.part.aspect.ITunnelConnection;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders;

public class TunnelHelpers {
    private static final Cache<ITunnelConnection, Integer> CACHE_INV_CHECKS = CacheBuilder.newBuilder().expireAfterWrite((long)((GeneralConfig.inventoryUnchangedTickCount + GeneralConfig.inventoryUnchangedTickTimeout) * (1000 / IModHelpers.get().getMinecraftHelpers().getSecondInTicks())), TimeUnit.MILLISECONDS).build();

    @Nonnull
    public static <T, M> T moveSingle(IIngredientComponentStorage<T, M> source, int sourceSlot, IIngredientComponentStorage<T, M> destination, int destinationSlot, IngredientPredicate<T, M> ingredientPredicate, PartPos movementPosition, boolean simulate) throws EvaluationException {
        try {
            try {
                if (ingredientPredicate.hasMatchFlags()) {
                    IIngredientMatcher matcher = ingredientPredicate.getIngredientComponent().getMatcher();
                    for (T instance : ingredientPredicate.getInstances()) {
                        Object movedInstance = IngredientStorageHelpers.moveIngredientsSlotted(source, (int)sourceSlot, destination, (int)destinationSlot, instance, ingredientPredicate.getMatchFlags(), (boolean)simulate);
                        if (matcher.isEmpty(movedInstance)) continue;
                        return (T)movedInstance;
                    }
                    return (T)matcher.getEmptyInstance();
                }
                return (T)IngredientStorageHelpers.moveIngredientsSlotted(source, (int)sourceSlot, destination, (int)destinationSlot, ingredientPredicate, (long)ingredientPredicate.getMaxQuantity(), (boolean)ingredientPredicate.isExactQuantity(), (boolean)simulate);
            }
            catch (InconsistentIngredientInsertionException e) {
                if (GeneralConfig.ejectItemsOnInconsistentSimulationMovement && e.getIngredientComponent().equals(IngredientComponent.ITEMSTACK)) {
                    IModHelpers.get().getItemStackHelpers().spawnItemStack(movementPosition.getPos().getLevel(true), movementPosition.getPos().getBlockPos(), (ItemStack)e.getRemainder());
                    throw new EvaluationException(Component.literal((String)"Ingredient movement failed due to inconsistent insertion behaviour by destination in simulation and non-simulation mode. This can be caused by invalid network setups. Ejected failed item in world."));
                }
                throw new EvaluationException(Component.literal((String)"Ingredient movement failed due to inconsistent insertion behaviour by destination in simulation and non-simulation mode. This can be caused by invalid network setups. Lost ").append((Component)e.getIngredientComponent().getMatcher().getDisplayName(e.getRemainder())));
            }
        }
        catch (IllegalStateException e) {
            IntegratedTunnels.clog(org.apache.logging.log4j.Level.WARN, e.getMessage());
            return (T)source.getComponent().getMatcher().getEmptyInstance();
        }
    }

    @Nonnull
    public static <T, M> T moveSingleStateOptimized(INetwork network, IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork, int channel, ITunnelConnection connection, IIngredientComponentStorage<T, M> source, int sourceSlot, IIngredientComponentStorage<T, M> destination, int destinationSlot, IngredientPredicate<T, M> ingredientPredicate, PartPos movementPosition, boolean craftIfFailed) throws EvaluationException {
        IIngredientMatcher matcher = source.getComponent().getMatcher();
        if (craftIfFailed) {
            for (T instance : ingredientPredicate.getInstances()) {
                if (!TunnelHelpers.isCrafting(network, ingredientsNetwork, channel, instance, ingredientPredicate.getMatchFlags())) continue;
                return (T)matcher.getEmptyInstance();
            }
        }
        if (ingredientPredicate.isEmpty()) {
            return (T)matcher.getEmptyInstance();
        }
        Integer sleepCheck = (Integer)CACHE_INV_CHECKS.getIfPresent((Object)connection);
        if (sleepCheck != null && sleepCheck >= GeneralConfig.inventoryUnchangedTickCount) {
            return (T)matcher.getEmptyInstance();
        }
        T moved = TunnelHelpers.moveSingle(source, sourceSlot, destination, destinationSlot, ingredientPredicate, movementPosition, false);
        if (matcher.isEmpty(moved)) {
            CACHE_INV_CHECKS.put((Object)connection, (Object)(sleepCheck == null ? 1 : sleepCheck + 1));
        } else if (sleepCheck != null) {
            CACHE_INV_CHECKS.invalidate((Object)connection);
        }
        ingredientsNetwork.scheduleObservation();
        if (craftIfFailed && matcher.isEmpty(moved)) {
            Iterator<T> iterator = ingredientPredicate.getInstances().iterator();
            while (iterator.hasNext()) {
                IIngredientPositionsIndex index;
                T instance;
                Object craftInstance = instance = iterator.next();
                if (!ingredientPredicate.isExactQuantity()) {
                    craftInstance = matcher.withQuantity(craftInstance, 1L);
                }
                if ((index = ingredientsNetwork.getChannelIndex(channel)).getQuantity(instance) >= matcher.getQuantity(craftInstance)) {
                    return moved;
                }
                boolean targetAcceptsCraftingResult = destinationSlot >= 0 ? destination instanceof IIngredientComponentStorageSlotted && matcher.isEmpty(((IIngredientComponentStorageSlotted)destination).insert(destinationSlot, craftInstance, true)) : matcher.isEmpty(destination.insert(craftInstance, true));
                if (!targetAcceptsCraftingResult) continue;
                TunnelHelpers.requestCrafting(network, ingredientsNetwork, channel, craftInstance, ingredientPredicate.getMatchFlags());
                break;
            }
        }
        return moved;
    }

    public static <T, M> boolean requestCrafting(INetwork network, IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork, int channel, T instance, M matchCondition) {
        return ((INetworkCraftingHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(INetworkCraftingHandlerRegistry.class)).craft(network, ingredientsNetwork, channel, ingredientsNetwork.getComponent(), instance, matchCondition, false);
    }

    public static <T, M> boolean isCrafting(INetwork network, IPositionedAddonsNetworkIngredients<T, M> ingredientsNetwork, int channel, T instance, M matchCondition) {
        return ((INetworkCraftingHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(INetworkCraftingHandlerRegistry.class)).isCrafting(network, ingredientsNetwork, channel, ingredientsNetwork.getComponent(), instance, matchCondition);
    }

    public static BlockPlaceContext createBlockItemUseContext(Level world, @Nullable Player playerEntity, BlockPos pos, Direction side, InteractionHand hand) {
        return TunnelHelpers.createBlockItemUseContext(world, playerEntity, pos, side, hand, ItemStack.EMPTY);
    }

    public static BlockPlaceContext createBlockItemUseContext(Level world, @Nullable Player playerEntity, BlockPos pos, Direction side, InteractionHand hand, ItemStack itemStack) {
        return new BlockPlaceContext(world, playerEntity, hand, itemStack, new BlockHitResult(new Vec3((double)pos.getX() + 0.5 + (double)side.getStepX() * 0.5, (double)pos.getY() + 0.5 + (double)side.getStepY() * 0.5, (double)pos.getZ() + 0.5 + (double)side.getStepZ() * 0.5), side, pos, false));
    }

    public static int getPassiveInteractionChannel(PartStateWriterBase<?> partStateBase) {
        IAspectProperties properties;
        int channel = partStateBase.getChannel();
        IAspectWrite aspect = partStateBase.getActiveAspect();
        if (aspect != null && (properties = partStateBase.getAspectProperties((IAspect)aspect)) != null) {
            channel = ((ValueTypeInteger.ValueInteger)properties.getValue(TunnelAspectWriteBuilders.PROP_CHANNEL)).getRawValue();
        }
        return channel;
    }
}

