/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.part;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.network.NetworkCapability;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;

public interface IPartTypeInterfacePositionedAddon<N extends IPositionedAddonsNetwork, T, P extends IPartTypeInterfacePositionedAddon<N, T, P, S>, S extends IState<N, T, P, S>>
extends IPartType<P, S> {
    public NetworkCapability<N> getNetworkCapability();

    public PartCapability<T> getPartCapability();

    public BlockCapability<T, Direction> getBlockCapability();

    default public boolean isTargetCapabilityValid(T capability) {
        return capability != null;
    }

    default public Optional<T> getTargetCapabilityInstance(PartPos pos) {
        return IModHelpersNeoForge.get().getCapabilityHelpers().getCapability(pos.getPos(), (Object)pos.getSide(), this.getBlockCapability());
    }

    default public void scheduleNetworkObservation(PartTarget target, S state) {
        Object positionedAddonsNetwork = state.getPositionedAddonsNetwork();
        if (positionedAddonsNetwork instanceof IPositionedAddonsNetworkIngredients) {
            ((IPositionedAddonsNetworkIngredients)positionedAddonsNetwork).scheduleObservationForced(state.getChannelInterface(), target.getTarget());
        }
    }

    default public Pair<N, Boolean> addPositionToNetwork(INetwork network, PartPos pos, int priority, int channelInterface, S state) {
        return network.getCapability(this.getNetworkCapability()).map(networkCapability -> {
            boolean validTargetCapability = this.getTargetCapabilityInstance(pos).map(this::isTargetCapabilityValid).orElse(false);
            return Pair.of((Object)networkCapability, (Object)validTargetCapability);
        }).orElse(null);
    }

    public void onAddingPositionToNetwork(N var1, INetwork var2, PartPos var3, int var4, int var5, S var6);

    default public void removePositionFromNetwork(INetwork network, PartPos posTarget, S state) {
        network.getCapability(this.getNetworkCapability()).ifPresent(networkCapability -> this.onRemovingPositionFromNetwork(networkCapability, network, posTarget, state));
    }

    public void onRemovingPositionFromNetwork(N var1, INetwork var2, PartPos var3, S var4);

    default public void addTargetToNetwork(INetwork network, PartPos posTarget, int priority, int channelInterface, S state) {
        Pair<N, Boolean> ret = this.addPositionToNetwork(network, posTarget, priority, channelInterface, state);
        IPositionedAddonsNetwork networkCapability = (IPositionedAddonsNetwork)ret.getLeft();
        boolean validTargetCapability = (Boolean)ret.getRight();
        if (networkCapability != null) {
            state.setPositionedAddonsNetwork((IPositionedAddonsNetwork)networkCapability);
            state.setNetworks(network, NetworkHelpers.getPartNetworkChecked((INetwork)network), ValueDeseralizationContext.of((Level)posTarget.getPos().getLevel(true)));
            state.setPos(posTarget);
            state.setValidTargetCapability(validTargetCapability);
            if (validTargetCapability) {
                this.onAddingPositionToNetwork(networkCapability, network, posTarget, priority, channelInterface, state);
            }
        }
    }

    default public void removeTargetFromNetwork(INetwork network, PartPos pos, S state) {
        this.removePositionFromNetwork(network, pos, state);
        state.setPositionedAddonsNetwork(null);
        state.setNetworks(null, null, null);
        state.setPos(null);
        state.setValidTargetCapability(false);
    }

    default public void updateTargetInNetwork(INetwork network, PartPos pos, int priority, int channelInterface, S state) {
        boolean wasValidTargetCapability;
        boolean validTargetCapability;
        if (network.getCapability(this.getNetworkCapability()).isPresent() && (validTargetCapability = this.getTargetCapabilityInstance(pos).map(this::isTargetCapabilityValid).orElse(false).booleanValue()) != (wasValidTargetCapability = state.isValidTargetCapability())) {
            this.removeTargetFromNetwork(network, pos, state);
            this.addTargetToNetwork(network, pos, priority, channelInterface, state);
        }
    }

    public static interface IState<N extends IPositionedAddonsNetwork, T, P extends IPartTypeInterfacePositionedAddon<N, T, P, S>, S extends IState<N, T, P, S>>
    extends IPartState<P> {
        public void setChannelInterface(int var1);

        public int getChannelInterface();

        public PartCapability<T> getTargetCapability();

        public N getPositionedAddonsNetwork();

        public void setPositionedAddonsNetwork(N var1);

        public boolean isValidTargetCapability();

        public void setValidTargetCapability(boolean var1);

        public PartPos getPos();

        public void setPos(PartPos var1);

        default public void disablePosition() {
            N positionedNetwork = this.getPositionedAddonsNetwork();
            PartPos pos = this.getPos();
            if (positionedNetwork != null) {
                positionedNetwork.disablePosition(pos);
            }
        }

        default public void enablePosition() {
            N positionedNetwork = this.getPositionedAddonsNetwork();
            PartPos pos = this.getPos();
            if (positionedNetwork != null) {
                positionedNetwork.enablePosition(pos);
            }
        }

        default public boolean isPositionEnabled() {
            N positionedNetwork = this.getPositionedAddonsNetwork();
            PartPos pos = this.getPos();
            if (positionedNetwork != null) {
                return !positionedNetwork.isPositionDisabled(pos);
            }
            return true;
        }

        default public boolean isNetworkAndPositionValid() {
            return this.getPositionedAddonsNetwork() != null && this.isPositionEnabled();
        }

        public void setNetworks(@Nullable INetwork var1, @Nullable IPartNetwork var2, ValueDeseralizationContext var3);

        @Nullable
        public INetwork getNetwork();

        @Nullable
        public IPartNetwork getPartNetwork();

        public T getCapabilityInstance();
    }
}

