/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.integratedtunnels.core.ExtendedFakePlayer;
import org.cyclops.integratedtunnels.core.PlayerHelpers;

public class ItemStoragePlayerWrapper
implements IIngredientComponentStorage<ItemStack, Integer> {
    private static final Predicate<Entity> CAN_BE_ATTACKED = Entity::isAttackable;
    private final ExtendedFakePlayer player;
    private final ServerLevel world;
    private final BlockPos pos;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private final Direction side;
    private final InteractionHand hand;
    private final boolean rightClick;
    private final boolean sneaking;
    private final boolean continuousClick;
    private final int entityIndex;
    private final IIngredientComponentStorage<ItemStack, Integer> playerReturnHandler;

    public ItemStoragePlayerWrapper(@Nullable ExtendedFakePlayer player, ServerLevel world, BlockPos pos, double offsetX, double offsetY, double offsetZ, Direction side, InteractionHand hand, boolean rightClick, boolean sneaking, boolean continuousClick, int entityIndex, IIngredientComponentStorage<ItemStack, Integer> playerReturnHandler) {
        this.player = player;
        this.world = world;
        this.pos = pos;
        this.continuousClick = continuousClick;
        this.entityIndex = entityIndex;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.side = side;
        this.hand = hand;
        this.rightClick = rightClick;
        this.sneaking = sneaking;
        this.playerReturnHandler = playerReturnHandler;
    }

    public static void cancelDestroyingBlock(ServerPlayer player) {
        player.gameMode.isDestroyingBlock = false;
        player.gameMode.lastSentState = -1;
    }

    protected Entity getEntity(List<Entity> entities) {
        if (this.entityIndex < 0) {
            return entities.get(this.world.random.nextInt(entities.size()));
        }
        return entities.get(Math.min(this.entityIndex, entities.size() - 1));
    }

    private void returnPlayerInventory(Player player) {
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        while (it.hasNext()) {
            ItemStack itemStack = it.next();
            if (itemStack.isEmpty()) continue;
            ItemStack remaining = (ItemStack)this.playerReturnHandler.insert((Object)itemStack, false);
            ItemStackHelpers.spawnItemStackToPlayer((Level)this.world, (BlockPos)this.pos, (ItemStack)remaining, (Player)player);
            it.remove();
        }
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return IngredientComponent.ITEMSTACK;
    }

    public Iterator<ItemStack> iterator() {
        return Iterators.forArray((Object[])new ItemStack[0]);
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchCondition) {
        return this.iterator();
    }

    public long getMaxQuantity() {
        return 1L;
    }

    public ItemStack insert(@Nonnull ItemStack stack, boolean simulate) {
        if (simulate) {
            return ItemStack.EMPTY;
        }
        if (this.player == null) {
            return stack;
        }
        PlayerHelpers.setPlayerState((Player)this.player, this.hand, this.pos, this.offsetX, this.offsetY, this.offsetZ, this.side, this.sneaking);
        PlayerHelpers.setHeldItemSilent((Player)this.player, this.hand, stack.copy());
        if (!this.continuousClick) {
            ItemStoragePlayerWrapper.cancelDestroyingBlock((ServerPlayer)this.player);
        }
        if (this.rightClick) {
            List entities;
            boolean flag1;
            BlockHitResult blockRayTraceResult = new BlockHitResult(new Vec3(this.offsetX, this.offsetY, this.offsetZ), this.side, this.pos, false);
            PlayerInteractEvent.RightClickBlock rightClickBlockActionResult = CommonHooks.onRightClickBlock((Player)this.player, (InteractionHand)this.hand, (BlockPos)this.pos, (BlockHitResult)blockRayTraceResult);
            if (rightClickBlockActionResult.isCanceled()) {
                return stack;
            }
            if (rightClickBlockActionResult.getUseItem() != TriState.FALSE && !stack.isEmpty()) {
                UseOnContext itemUseContext = new UseOnContext((Player)this.player, this.hand, blockRayTraceResult);
                InteractionResult actionResult = stack.getItem().onItemUseFirst(stack, itemUseContext);
                stack = itemUseContext.getItemInHand();
                if (actionResult == InteractionResult.FAIL) {
                    return stack;
                }
                if (actionResult.consumesAction()) {
                    this.returnPlayerInventory((Player)this.player);
                    return ItemStack.EMPTY;
                }
            }
            boolean playerHasHeldItem = !this.player.getMainHandItem().isEmpty() || !this.player.getOffhandItem().isEmpty();
            boolean bl = flag1 = this.player.isSecondaryUseActive() && playerHasHeldItem && (!this.player.getMainHandItem().doesSneakBypassUse((LevelReader)this.world, this.pos, (Player)this.player) || !this.player.getOffhandItem().doesSneakBypassUse((LevelReader)this.world, this.pos, (Player)this.player));
            if (rightClickBlockActionResult.getUseBlock() == TriState.TRUE || rightClickBlockActionResult.getUseBlock() != TriState.FALSE && !flag1) {
                BlockState blockState = this.world.getBlockState(this.pos);
                if (!this.player.isCrouching() || stack.isEmpty()) {
                    ItemInteractionResult iteminteractionresult = blockState.useItemOn(this.player.getItemInHand(this.hand), (Level)this.world, (Player)this.player, this.hand, blockRayTraceResult);
                    if (iteminteractionresult.consumesAction()) {
                        this.returnPlayerInventory((Player)this.player);
                        return ItemStack.EMPTY;
                    }
                    if (iteminteractionresult == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION && this.hand == InteractionHand.MAIN_HAND && blockState.useWithoutItem((Level)this.world, (Player)this.player, blockRayTraceResult).consumesAction()) {
                        this.returnPlayerInventory((Player)this.player);
                        return ItemStack.EMPTY;
                    }
                }
            }
            if ((entities = this.world.getEntitiesOfClass(Entity.class, new AABB(this.pos))).size() > 0) {
                Entity entity = this.getEntity(entities);
                InteractionResult actionResult = this.player.interactOn(entity, this.hand);
                if (actionResult == InteractionResult.FAIL) {
                    return stack;
                }
                if (actionResult.consumesAction()) {
                    this.returnPlayerInventory((Player)this.player);
                    return ItemStack.EMPTY;
                }
            }
            if (rightClickBlockActionResult.getUseItem() != TriState.FALSE && !stack.isEmpty()) {
                InteractionResult cancelResult = CommonHooks.onItemRightClick((Player)this.player, (InteractionHand)this.hand);
                if (cancelResult != null) {
                    if (cancelResult == InteractionResult.FAIL) {
                        return stack;
                    }
                    if (cancelResult.consumesAction()) {
                        this.returnPlayerInventory((Player)this.player);
                        return ItemStack.EMPTY;
                    }
                } else {
                    ItemStack copyBeforeUse = stack.copy();
                    InteractionResultHolder actionresult = stack.use((Level)this.world, (Player)this.player, this.hand);
                    if (actionresult.getResult() == InteractionResult.FAIL) {
                        return stack;
                    }
                    if (((ItemStack)actionresult.getObject()).isEmpty()) {
                        PlayerHelpers.setHeldItemSilent((Player)this.player, this.hand, ItemStack.EMPTY);
                        EventHooks.onPlayerDestroyItem((Player)this.player, (ItemStack)copyBeforeUse, (InteractionHand)this.hand);
                    } else {
                        PlayerHelpers.setHeldItemSilent((Player)this.player, this.hand, (ItemStack)actionresult.getObject());
                    }
                    if (actionresult.getResult().consumesAction()) {
                        if (this.player.isUsingItem()) {
                            this.player.updateActiveHandSimulated();
                            this.player.releaseUsingItem();
                        }
                        this.returnPlayerInventory((Player)this.player);
                        return ItemStack.EMPTY;
                    }
                    if (((ItemStack)actionresult.getObject()).isEmpty()) {
                        this.returnPlayerInventory((Player)this.player);
                        return ItemStack.EMPTY;
                    }
                }
            }
            if (rightClickBlockActionResult.getUseItem() != TriState.FALSE && !stack.isEmpty()) {
                BlockPos targetPos = this.pos;
                double reachDistance = this.player.getAttribute(Attributes.BLOCK_INTERACTION_RANGE).getValue() + 3.0;
                int i = 0;
                while (true) {
                    int n = i++;
                    if (!((double)n < reachDistance) || !this.world.isEmptyBlock(targetPos)) break;
                    targetPos = targetPos.relative(this.side.getOpposite());
                }
                UseOnContext itemUseContextReach = new UseOnContext((Player)this.player, this.hand, new BlockHitResult(new Vec3(this.offsetX, this.offsetY, this.offsetZ), this.side, targetPos, false));
                InteractionResult actionResult = stack.useOn(itemUseContextReach);
                stack = itemUseContextReach.getItemInHand();
                if (actionResult == InteractionResult.FAIL) {
                    return stack;
                }
                if (actionResult.consumesAction()) {
                    if (this.player.isUsingItem()) {
                        this.player.updateActiveHandSimulated();
                        this.player.releaseUsingItem();
                    }
                    this.returnPlayerInventory((Player)this.player);
                    return ItemStack.EMPTY;
                }
            }
        } else {
            PlayerInteractEvent.LeftClickBlock event = CommonHooks.onLeftClickBlock((Player)this.player, (BlockPos)this.pos, (Direction)this.side, (ServerboundPlayerActionPacket.Action)ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK);
            BlockState blockState = this.world.getBlockState(this.pos);
            if (event.isCanceled() || event.getUseItem() == TriState.FALSE) {
                this.world.sendBlockUpdated(this.pos, blockState, this.world.getBlockState(this.pos), 3);
                return stack;
            }
            if (!this.world.isEmptyBlock(this.pos)) {
                int durabilityRemaining = this.player.gameMode.lastSentState;
                if (durabilityRemaining < 0) {
                    this.world.getBlockState(this.pos).attack((Level)this.world, this.pos, (Player)this.player);
                    float relativeBlockHardness = blockState.getDestroyProgress((Player)this.player, (BlockGetter)this.player.level(), this.pos);
                    if (relativeBlockHardness >= 1.0f) {
                        this.player.gameMode.destroyBlock(this.pos);
                    } else {
                        this.player.gameMode.destroyProgressStart = this.player.gameMode.gameTicks;
                        this.player.gameMode.isDestroyingBlock = true;
                        this.player.gameMode.destroyPos = this.pos.immutable();
                        this.player.gameMode.lastSentState = (int)(relativeBlockHardness * 10.0f);
                    }
                } else if (durabilityRemaining >= 9) {
                    this.player.gameMode.destroyBlock(this.pos);
                    ItemStoragePlayerWrapper.cancelDestroyingBlock((ServerPlayer)this.player);
                } else {
                    this.player.gameMode.tick();
                }
                this.returnPlayerInventory((Player)this.player);
                return ItemStack.EMPTY;
            }
            ItemStoragePlayerWrapper.cancelDestroyingBlock((ServerPlayer)this.player);
            List entities = this.world.getEntitiesOfClass(Entity.class, new AABB(this.pos), CAN_BE_ATTACKED::test);
            if (entities.size() > 0) {
                Entity entity = this.getEntity(entities);
                EquipmentSlot equipmentSlotType = this.hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                HashMultimap modifiers = HashMultimap.create();
                stack.getAttributeModifiers().forEach(equipmentSlotType, (x$0, x$1) -> modifiers.put(x$0, x$1));
                this.player.getAttributes().addTransientAttributeModifiers((Multimap)modifiers);
                this.player.attack(entity);
                this.player.getAttributes().removeAttributeModifiers((Multimap)modifiers);
                this.returnPlayerInventory((Player)this.player);
                return ItemStack.EMPTY;
            }
            return stack;
        }
        return stack;
    }

    public ItemStack extract(@Nonnull ItemStack prototype, Integer matchCondition, boolean simulate) {
        return ItemStack.EMPTY;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        return ItemStack.EMPTY;
    }
}

