/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.part;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.network.PositionedAddonsNetworkIngredientsFilter;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.write.PartStateWriterBase;
import org.cyclops.integratedtunnels.core.part.ContainerInterfaceSettings;
import org.cyclops.integratedtunnels.core.part.IPartTypeInterfacePositionedAddon;
import org.cyclops.integratedtunnels.core.part.PartTypeTunnelAspects;

public abstract class PartTypeInterfacePositionedAddonFiltering<N extends IPositionedAddonsNetwork, T, P extends PartTypeInterfacePositionedAddonFiltering<N, T, P, S>, S extends State<N, T, P, S>>
extends PartTypeTunnelAspects<P, S>
implements IPartTypeInterfacePositionedAddon<N, T, P, S> {
    public PartTypeInterfacePositionedAddonFiltering(String name) {
        super(name);
    }

    public void update(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        if (((State)state).isRequireAspectUpdateAndReset()) {
            super.update(network, partNetwork, target, state);
        }
    }

    protected void onVariableContentsUpdated(IPartNetwork network, PartTarget target, S state) {
        super.onVariableContentsUpdated(network, target, state);
        ((State)state).requireAspectUpdate();
    }

    public Optional<MenuProvider> getContainerProviderSettings(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)PartTypeInterfacePositionedAddonFiltering.this.getTranslationKey());
            }

            @Nullable
            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                return new ContainerInterfaceSettings(id, playerInventory, (Container)new SimpleContainer(0), (PartTarget)data.getRight(), Optional.of((IPartContainer)data.getLeft()), (IPartType)data.getMiddle());
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        });
    }

    @Override
    public void onAddingPositionToNetwork(N networkCapability, INetwork network, PartPos pos, int priority, int channelInterface, S state) {
        if (((State)state).getTargetFilter() != null) {
            networkCapability.addPosition(pos, priority, channelInterface);
            ((IPositionedAddonsNetworkIngredients)((State)state).getPositionedAddonsNetwork()).setPositionedStorageFilter(pos, ((State)state).getTargetFilter());
        }
    }

    @Override
    public void onRemovingPositionFromNetwork(N networkCapability, INetwork network, PartPos pos, S state) {
        networkCapability.removePosition(pos);
        Object addonsNetwork = ((State)state).getPositionedAddonsNetwork();
        if (addonsNetwork != null) {
            ((IPositionedAddonsNetworkIngredients)addonsNetwork).setPositionedStorageFilter(pos, null);
        }
    }

    public void afterNetworkReAlive(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.afterNetworkReAlive(network, partNetwork, target, state);
        this.addTargetToNetwork(network, target.getTarget(), state.getPriority(), ((State)state).getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
    }

    public void onNetworkRemoval(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.onNetworkRemoval(network, partNetwork, target, state);
        this.scheduleNetworkObservation(target, (IPartTypeInterfacePositionedAddon.IState)state);
        this.removeTargetFromNetwork(network, target.getTarget(), (IPartTypeInterfacePositionedAddon.IState)state);
    }

    public void onNetworkAddition(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.onNetworkAddition(network, partNetwork, target, state);
        this.addTargetToNetwork(network, target.getTarget(), state.getPriority(), ((State)state).getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
        this.scheduleNetworkObservation(target, (IPartTypeInterfacePositionedAddon.IState)state);
    }

    public void onBlockNeighborChange(INetwork network, IPartNetwork partNetwork, PartTarget target, S state, BlockGetter world) {
        super.onBlockNeighborChange(network, partNetwork, target, state, world);
        if (network != null) {
            this.updateTargetInNetwork(network, target.getTarget(), state.getPriority(), ((State)state).getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
        }
    }

    public void setPriorityAndChannel(INetwork network, IPartNetwork partNetwork, PartTarget target, S state, int priority, int channel) {
        this.removeTargetFromNetwork(network, target.getTarget(), (IPartTypeInterfacePositionedAddon.IState)state);
        super.setPriorityAndChannel(network, partNetwork, target, state, priority, channel);
        this.addTargetToNetwork(network, target.getTarget(), priority, ((State)state).getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
    }

    public static abstract class State<N extends IPositionedAddonsNetwork, T, P extends PartTypeInterfacePositionedAddonFiltering<N, T, P, S>, S extends State<N, T, P, S>>
    extends PartStateWriterBase<P>
    implements IPartTypeInterfacePositionedAddon.IState<N, T, P, S> {
        private N positionedAddonsNetwork = null;
        private PartPos pos = null;
        private boolean validTargetCapability = false;
        private int channelInterface = 0;
        private PositionedAddonsNetworkIngredientsFilter<T> targetFilter = null;
        private INetwork network;
        private IPartNetwork partNetwork;
        private ValueDeseralizationContext valueDeseralizationContext;
        private boolean requireAspectUpdate = true;

        public State(int inventorySize) {
            super(inventorySize);
        }

        protected int getDefaultUpdateInterval() {
            return 10;
        }

        public void serialize(ValueOutput valueOutput) {
            super.serialize(valueOutput);
            valueOutput.putInt("channelInterface", this.channelInterface);
        }

        public void deserialize(ValueInput valueInput) {
            super.deserialize(valueInput);
            this.channelInterface = (Integer)valueInput.getInt("channelInterface").orElseThrow();
        }

        @Override
        public void setChannelInterface(int channelInterface) {
            this.channelInterface = channelInterface;
            this.sendUpdate();
        }

        @Override
        public int getChannelInterface() {
            return this.channelInterface;
        }

        @Override
        @Nullable
        public N getPositionedAddonsNetwork() {
            return this.positionedAddonsNetwork;
        }

        @Override
        public void setPositionedAddonsNetwork(N positionedAddonsNetwork) {
            this.positionedAddonsNetwork = positionedAddonsNetwork;
        }

        @Override
        public boolean isValidTargetCapability() {
            return this.validTargetCapability;
        }

        @Override
        public void setValidTargetCapability(boolean validTargetCapability) {
            this.validTargetCapability = validTargetCapability;
        }

        @Override
        public PartPos getPos() {
            return this.pos;
        }

        @Override
        public void setPos(PartPos pos) {
            this.pos = pos;
        }

        public boolean isRequireAspectUpdateAndReset() {
            boolean ret = this.requireAspectUpdate;
            this.requireAspectUpdate = false;
            return ret;
        }

        @Nullable
        public PositionedAddonsNetworkIngredientsFilter<T> getTargetFilter() {
            return this.targetFilter;
        }

        public void setTargetFilter(@Nullable PositionedAddonsNetworkIngredientsFilter<T> targetFilter) {
            this.targetFilter = targetFilter;
            if (targetFilter == null) {
                this.requireAspectUpdate();
            } else {
                this.getVariable(this.network, this.partNetwork, this.valueDeseralizationContext).addInvalidationListener(this::requireAspectUpdate);
            }
        }

        public void requireAspectUpdate() {
            this.requireAspectUpdate = true;
        }

        @Override
        public void setNetworks(@Nullable INetwork network, @Nullable IPartNetwork partNetwork, ValueDeseralizationContext valueDeseralizationContext) {
            this.network = network;
            this.partNetwork = partNetwork;
            this.valueDeseralizationContext = valueDeseralizationContext;
        }

        @Override
        @Nullable
        public INetwork getNetwork() {
            return this.network;
        }

        @Override
        @Nullable
        public IPartNetwork getPartNetwork() {
            return this.partNetwork;
        }

        public <T> Optional<T> getCapability(P partType, PartCapability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
            if (this.isNetworkAndPositionValid() && capability == this.getTargetCapability()) {
                return Optional.of(this.getCapabilityInstance());
            }
            return super.getCapability(partType, capability, network, partNetwork, target);
        }
    }
}

