/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedtunnels.part.PartTypes;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspectWriteBuilders;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspects;

public class GameTestsItems {
    public static final String TEMPLATE_EMPTY = "integratedtunnels:empty10";
    public static final int TIMEOUT = 2000;
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testItemsImporterToInterfaceBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        helper.setBlock(POS.west(), Blocks.CHEST);
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.WHITE_WOOL));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        chestIn.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Item.BOOLEAN_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertContainerContains(POS.east().east(), Items.WHITE_WOOL);
            helper.assertContainerContains(POS.east().east(), Items.ACACIA_LEAVES);
            helper.assertContainerContains(POS.east().east(), Items.DIAMOND_PICKAXE);
            helper.assertContainerEmpty(POS.west());
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.IMPORTER_ITEM.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.Item.BOOLEAN_IMPORT, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.Item.BOOLEAN_IMPORT).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testItemsInterfaceToExporterBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.EXPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_ITEM.getItem()));
        helper.setBlock(POS.west(), Blocks.CHEST);
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.WHITE_WOOL));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        chestIn.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), TunnelAspects.Write.Item.BOOLEAN_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertContainerContains(POS.east().east(), Items.WHITE_WOOL);
            helper.assertContainerContains(POS.east().east(), Items.ACACIA_LEAVES);
            helper.assertContainerContains(POS.east().east(), Items.DIAMOND_PICKAXE);
            helper.assertContainerEmpty(POS.west());
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Exporter is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.EXPORTER_ITEM.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)), Direction.EAST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.Item.BOOLEAN_EXPORT, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.Item.BOOLEAN_EXPORT).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testItemsImporterToInterfaceToExporterBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_ITEM.getItem()));
        helper.setBlock(POS.west(), Blocks.CHEST);
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.setBlock(POS.east().north(), Blocks.CHEST);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.WHITE_WOOL));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        chestIn.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Item.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectExporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.Item.BOOLEAN_EXPORT, (ItemStack)variableAspectExporter);
        helper.succeedWhen(() -> {
            helper.assertContainerContains(POS.east().north(), Items.WHITE_WOOL);
            helper.assertContainerContains(POS.east().north(), Items.ACACIA_LEAVES);
            helper.assertContainerContains(POS.east().north(), Items.DIAMOND_PICKAXE);
            helper.assertContainerEmpty(POS.west());
            helper.assertContainerEmpty(POS.east().east());
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testItemsImporterToInterfaceItem(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        helper.setBlock(POS.west(), Blocks.CHEST);
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.WHITE_WOOL));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        chestIn.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_ITEMSTACK, (IValue)ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Items.ACACIA_LEAVES)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Item.ITEMSTACK_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            ChestBlockEntity chestOut = (ChestBlockEntity)helper.getBlockEntity(POS.east().east(), ChestBlockEntity.class);
            helper.assertFalse(chestIn.getItem(0).isEmpty(), (Component)Component.literal((String)"Incorrect input item was moved"));
            helper.assertTrue(chestIn.getItem(1).isEmpty(), (Component)Component.literal((String)"Incorrect input item was moved"));
            helper.assertFalse(chestIn.getItem(2).isEmpty(), (Component)Component.literal((String)"Incorrect input item was moved"));
            helper.assertFalse(chestOut.getItem(0).isEmpty(), (Component)Component.literal((String)"Incorrect output item was moved"));
            helper.assertTrue(chestOut.getItem(1).isEmpty(), (Component)Component.literal((String)"Incorrect output item was moved"));
            helper.assertContainerContains(POS.west(), Items.WHITE_WOOL);
            helper.assertContainerContains(POS.east().east(), Items.ACACIA_LEAVES);
            helper.assertContainerContains(POS.west(), Items.DIAMOND_PICKAXE);
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testItemsImporterToInterfaceBooleanReducedRate(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        helper.setBlock(POS.west(), Blocks.CHEST);
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.WHITE_WOOL));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        chestIn.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        PartPos posImporter = PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)posImporter, TunnelAspects.Write.Item.BOOLEAN_IMPORT, (ItemStack)variableAspect);
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)posImporter);
        IAspectProperties properties = TunnelAspects.Write.Item.BOOLEAN_IMPORT.getProperties(partStateHolder.getPart(), PartTarget.fromCenter((PartPos)posImporter), partStateHolder.getState());
        properties.setValue(TunnelAspectWriteBuilders.Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1));
        partStateHolder.getState().setAspectProperties(TunnelAspects.Write.Item.BOOLEAN_IMPORT, properties);
        helper.succeedWhen(() -> {
            helper.assertContainerContains(POS.east().east(), Items.WHITE_WOOL);
            helper.assertContainerContains(POS.east().east(), Items.ACACIA_LEAVES);
            helper.assertContainerContains(POS.east().east(), Items.DIAMOND_PICKAXE);
            helper.assertContainerEmpty(POS.west());
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testItemsNoMoveDisconnectedFakeCable(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS.east().east().east(), Direction.WEST);
        helper.setBlock(POS.west(), Blocks.CHEST);
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.setBlock(POS.west().above(), Blocks.HOPPER);
        HopperBlockEntity hopperIn = (HopperBlockEntity)helper.getBlockEntity(POS.west().above(), HopperBlockEntity.class);
        hopperIn.setItem(0, new ItemStack((ItemLike)Items.WHITE_WOOL));
        hopperIn.setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        hopperIn.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Item.BOOLEAN_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertContainerContains(POS.west(), Items.WHITE_WOOL);
            helper.assertContainerContains(POS.west(), Items.ACACIA_LEAVES);
            helper.assertContainerContains(POS.west(), Items.DIAMOND_PICKAXE);
            helper.assertContainerEmpty(POS.east().east());
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testItemsImporterToFilteredInterfaceBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FILTERING_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FILTERING_ITEM.getItem()));
        helper.setBlock(POS.west(), Blocks.CHEST);
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.WHITE_WOOL));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        chestIn.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Item.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectInterface = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), TunnelAspects.Write.ItemFilter.BOOLEAN_SET_FILTER, (ItemStack)variableAspectInterface);
        helper.succeedWhen(() -> {
            helper.assertContainerContains(POS.east().east(), Items.WHITE_WOOL);
            helper.assertContainerContains(POS.east().east(), Items.ACACIA_LEAVES);
            helper.assertContainerContains(POS.east().east(), Items.DIAMOND_PICKAXE);
            helper.assertContainerEmpty(POS.west());
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.IMPORTER_ITEM.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status importer is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.Item.BOOLEAN_IMPORT, (Component)Component.literal((String)"Active aspect importer is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.Item.BOOLEAN_IMPORT).isEmpty(), (Component)Component.literal((String)"Active aspect importer has errors"));
            IPartStateWriter partStateInterface = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)).getState();
            helper.assertFalse(partStateInterface.isDeactivated(), (Component)Component.literal((String)"Filtering interface is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.INTERFACE_FILTERING_ITEM.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)), Direction.EAST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status filtering interface is incorrect"));
            helper.assertValueEqual((Object)partStateInterface.getActiveAspect(), TunnelAspects.Write.ItemFilter.BOOLEAN_SET_FILTER, (Component)Component.literal((String)"Active aspect filtering interface is incorrect"));
            helper.assertTrue(partStateInterface.getErrors(TunnelAspects.Write.ItemFilter.BOOLEAN_SET_FILTER).isEmpty(), (Component)Component.literal((String)"Active aspect filtering interface has errors"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testItemsImporterToFilteredInterfaceItem(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_FILTERING_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_FILTERING_ITEM.getItem()));
        helper.setBlock(POS.west(), Blocks.CHEST);
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.WHITE_WOOL));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        chestIn.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        ItemStack variableAspectImporter = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Item.BOOLEAN_IMPORT, (ItemStack)variableAspectImporter);
        ItemStack variableAspectInterface = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_ITEMSTACK, (IValue)ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Items.ACACIA_LEAVES)));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST), TunnelAspects.Write.ItemFilter.ITEMSTACK_SET_FILTER, (ItemStack)variableAspectInterface);
        helper.succeedWhen(() -> {
            ChestBlockEntity chestOut = (ChestBlockEntity)helper.getBlockEntity(POS.east().east(), ChestBlockEntity.class);
            helper.assertFalse(chestIn.getItem(0).isEmpty(), (Component)Component.literal((String)"Incorrect input item was moved"));
            helper.assertTrue(chestIn.getItem(1).isEmpty(), (Component)Component.literal((String)"Incorrect input item was moved"));
            helper.assertFalse(chestIn.getItem(2).isEmpty(), (Component)Component.literal((String)"Incorrect input item was moved"));
            helper.assertFalse(chestOut.getItem(0).isEmpty(), (Component)Component.literal((String)"Incorrect output item was moved"));
            helper.assertTrue(chestOut.getItem(1).isEmpty(), (Component)Component.literal((String)"Incorrect output item was moved"));
            helper.assertContainerContains(POS.west(), Items.WHITE_WOOL);
            helper.assertContainerContains(POS.east().east(), Items.ACACIA_LEAVES);
            helper.assertContainerContains(POS.west(), Items.DIAMOND_PICKAXE);
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.IMPORTER_ITEM.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status importer is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.Item.BOOLEAN_IMPORT, (Component)Component.literal((String)"Active aspect importer is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.Item.BOOLEAN_IMPORT).isEmpty(), (Component)Component.literal((String)"Active aspect importer has errors"));
            IPartStateWriter partStateInterface = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)).getState();
            helper.assertFalse(partStateInterface.isDeactivated(), (Component)Component.literal((String)"Filtering interface is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.INTERFACE_FILTERING_ITEM.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST)), Direction.EAST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status filtering interface is incorrect"));
            helper.assertValueEqual((Object)partStateInterface.getActiveAspect(), TunnelAspects.Write.ItemFilter.ITEMSTACK_SET_FILTER, (Component)Component.literal((String)"Active aspect filtering interface is incorrect"));
            helper.assertTrue(partStateInterface.getErrors(TunnelAspects.Write.ItemFilter.ITEMSTACK_SET_FILTER).isEmpty(), (Component)Component.literal((String)"Active aspect filtering interface has errors"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testItemsImporterToInterfacesRoundRobin(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east().above(), (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east().above().above(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east().above()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east().above().above()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        helper.setBlock(POS.west(), Blocks.CHEST);
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.setBlock(POS.east().east().above(), Blocks.CHEST);
        helper.setBlock(POS.east().east().above().above(), Blocks.CHEST);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.WHITE_WOOL, 30));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        PartPos posImporter = PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)posImporter, TunnelAspects.Write.Item.BOOLEAN_IMPORT, (ItemStack)variableAspect);
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)posImporter);
        IAspectProperties properties = TunnelAspects.Write.Item.BOOLEAN_IMPORT.getProperties(partStateHolder.getPart(), PartTarget.fromCenter((PartPos)posImporter), partStateHolder.getState());
        properties.setValue(TunnelAspectWriteBuilders.Item.PROP_RATE, (IValue)ValueTypeInteger.ValueInteger.of((int)1));
        properties.setValue(TunnelAspectWriteBuilders.PROP_ROUNDROBIN, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
        partStateHolder.getState().setAspectProperties(TunnelAspects.Write.Item.BOOLEAN_IMPORT, properties);
        helper.succeedWhen(() -> {
            ChestBlockEntity chest1 = (ChestBlockEntity)helper.getBlockEntity(POS.east().east(), ChestBlockEntity.class);
            ChestBlockEntity chest2 = (ChestBlockEntity)helper.getBlockEntity(POS.east().east().above(), ChestBlockEntity.class);
            ChestBlockEntity chest3 = (ChestBlockEntity)helper.getBlockEntity(POS.east().east().above().above(), ChestBlockEntity.class);
            helper.assertTrue(chest1.getItem(0).getItem() == Items.WHITE_WOOL, (Component)Component.literal((String)"chest 1 does not contain white wool"));
            helper.assertTrue(chest1.getItem(0).getCount() == 10, (Component)Component.literal((String)"chest 1 does not contain 10 white wool"));
            helper.assertTrue(chest2.getItem(0).getItem() == Items.WHITE_WOOL, (Component)Component.literal((String)"chest 2 does not contain white wool"));
            helper.assertTrue(chest2.getItem(0).getCount() == 10, (Component)Component.literal((String)"chest 2 does not contain 10 white wool"));
            helper.assertTrue(chest3.getItem(0).getItem() == Items.WHITE_WOOL, (Component)Component.literal((String)"chest 3 does not contain white wool"));
            helper.assertTrue(chest3.getItem(0).getCount() == 10, (Component)Component.literal((String)"chest 3 does not contain 10 white wool"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testItemsImporterToInterfaceItemList(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        helper.setBlock(POS.west(), Blocks.CHEST);
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.WHITE_WOOL));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        chestIn.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeItemStack.ValueItemStack[]{ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Items.ACACIA_LEAVES)), ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Items.DIAMOND_PICKAXE))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Item.LIST_IMPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            ChestBlockEntity chestOut = (ChestBlockEntity)helper.getBlockEntity(POS.east().east(), ChestBlockEntity.class);
            helper.assertFalse(chestIn.getItem(0).isEmpty(), (Component)Component.literal((String)"Incorrect input item was moved"));
            helper.assertTrue(chestIn.getItem(1).isEmpty(), (Component)Component.literal((String)"Incorrect input item was moved"));
            helper.assertTrue(chestIn.getItem(2).isEmpty(), (Component)Component.literal((String)"Incorrect input item was moved"));
            helper.assertFalse(chestOut.getItem(0).isEmpty(), (Component)Component.literal((String)"Incorrect output item was moved"));
            helper.assertFalse(chestOut.getItem(1).isEmpty(), (Component)Component.literal((String)"Incorrect output item was moved"));
            helper.assertTrue(chestOut.getItem(2).isEmpty(), (Component)Component.literal((String)"Incorrect output item was moved"));
            helper.assertContainerContains(POS.west(), Items.WHITE_WOOL);
            helper.assertContainerContains(POS.east().east(), Items.ACACIA_LEAVES);
            helper.assertContainerContains(POS.east().east(), Items.DIAMOND_PICKAXE);
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testItemsImporterToInterfaceItemListBlacklist(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        helper.setBlock(POS.west(), Blocks.CHEST);
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        ChestBlockEntity chestIn = (ChestBlockEntity)helper.getBlockEntity(POS.west(), ChestBlockEntity.class);
        chestIn.setItem(0, new ItemStack((ItemLike)Items.WHITE_WOOL));
        chestIn.setItem(1, new ItemStack((ItemLike)Items.ACACIA_LEAVES));
        chestIn.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
        ItemStack variableAspect = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.LIST, (IValue)ValueTypeList.ValueList.ofAll((IValue[])new ValueObjectTypeItemStack.ValueItemStack[]{ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Items.WHITE_WOOL))}));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.Item.LIST_IMPORT, (ItemStack)variableAspect);
        PartPos posImporter = PartPos.of((DimPos)DimPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS)), (Direction)Direction.WEST);
        PartHelpers.PartStateHolder partStateHolder = PartHelpers.getPart((PartPos)posImporter);
        IAspectProperties properties = TunnelAspects.Write.Item.LIST_IMPORT.getProperties(partStateHolder.getPart(), PartTarget.fromCenter((PartPos)posImporter), partStateHolder.getState());
        properties.setValue(TunnelAspectWriteBuilders.PROP_BLACKLIST, (IValue)ValueTypeBoolean.ValueBoolean.of((boolean)true));
        partStateHolder.getState().setAspectProperties(TunnelAspects.Write.Fluid.LIST_IMPORT, properties);
        helper.succeedWhen(() -> {
            ChestBlockEntity chestOut = (ChestBlockEntity)helper.getBlockEntity(POS.east().east(), ChestBlockEntity.class);
            helper.assertFalse(chestIn.getItem(0).isEmpty(), (Component)Component.literal((String)"Incorrect input item was moved"));
            helper.assertTrue(chestIn.getItem(1).isEmpty(), (Component)Component.literal((String)"Incorrect input item was moved"));
            helper.assertTrue(chestIn.getItem(2).isEmpty(), (Component)Component.literal((String)"Incorrect input item was moved"));
            helper.assertFalse(chestOut.getItem(0).isEmpty(), (Component)Component.literal((String)"Incorrect output item was moved"));
            helper.assertFalse(chestOut.getItem(1).isEmpty(), (Component)Component.literal((String)"Incorrect output item was moved"));
            helper.assertTrue(chestOut.getItem(2).isEmpty(), (Component)Component.literal((String)"Incorrect output item was moved"));
            helper.assertContainerContains(POS.west(), Items.WHITE_WOOL);
            helper.assertContainerContains(POS.east().east(), Items.ACACIA_LEAVES);
            helper.assertContainerContains(POS.east().east(), Items.DIAMOND_PICKAXE);
        });
    }
}

