/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels;

import com.google.common.collect.Lists;
import java.util.Collection;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.IInfoBookRegistry;
import org.cyclops.cyclopscore.init.IRegistry;
import org.cyclops.cyclopscore.init.ModBaseNeoForge;
import org.cyclops.cyclopscore.proxy.IClientProxy;
import org.cyclops.cyclopscore.proxy.ICommonProxy;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.event.IntegratedDynamicsSetupEvent;
import org.cyclops.integrateddynamics.core.part.aspect.AspectRegistry;
import org.cyclops.integrateddynamics.infobook.OnTheDynamicsOfIntegrationBook;
import org.cyclops.integratedtunnels.Capabilities;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.RegistryEntries;
import org.cyclops.integratedtunnels.api.world.IBlockBreakHandlerRegistry;
import org.cyclops.integratedtunnels.api.world.IBlockPlaceHandlerRegistry;
import org.cyclops.integratedtunnels.capability.ingredient.TunnelIngredientComponentCapabilities;
import org.cyclops.integratedtunnels.capability.network.TunnelNetworkCapabilityConstructors;
import org.cyclops.integratedtunnels.core.ItemStoragePlayerWrapper;
import org.cyclops.integratedtunnels.core.part.ContainerInterfaceSettingsConfig;
import org.cyclops.integratedtunnels.core.world.BlockBreakHandlerRegistry;
import org.cyclops.integratedtunnels.core.world.BlockBreakHandlers;
import org.cyclops.integratedtunnels.core.world.BlockBreakPlaceRegistry;
import org.cyclops.integratedtunnels.core.world.BlockPlaceHandlers;
import org.cyclops.integratedtunnels.gametest.GameTestsEnergy;
import org.cyclops.integratedtunnels.gametest.GameTestsFluids;
import org.cyclops.integratedtunnels.gametest.GameTestsItems;
import org.cyclops.integratedtunnels.gametest.GameTestsPlayerSimulator;
import org.cyclops.integratedtunnels.gametest.GameTestsWorldBlock;
import org.cyclops.integratedtunnels.gametest.GameTestsWorldFluid;
import org.cyclops.integratedtunnels.gametest.GameTestsWorldItem;
import org.cyclops.integratedtunnels.item.ItemDummyPickAxeConfig;
import org.cyclops.integratedtunnels.part.PartTypes;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspects;
import org.cyclops.integratedtunnels.part.aspect.listproxy.TunnelValueTypeListProxyFactories;
import org.cyclops.integratedtunnels.proxy.ClientProxy;
import org.cyclops.integratedtunnels.proxy.CommonProxy;

@Mod(value="integratedtunnels")
public class IntegratedTunnels
extends ModBaseNeoForge<IntegratedTunnels> {
    public static IntegratedTunnels _instance;

    public IntegratedTunnels(IEventBus modEventBus) {
        super("integratedtunnels", instance -> {
            _instance = instance;
        }, modEventBus);
        this.getRegistryManager().addRegistry(IBlockBreakHandlerRegistry.class, (IRegistry)BlockBreakHandlerRegistry.getInstance());
        this.getRegistryManager().addRegistry(IBlockPlaceHandlerRegistry.class, (IRegistry)BlockBreakPlaceRegistry.getInstance());
        modEventBus.addListener(this::onRegistriesCreate);
        modEventBus.addListener(this::onSetup);
        modEventBus.addListener(Capabilities::registerPartCapabilities);
        modEventBus.register((Object)new TunnelNetworkCapabilityConstructors());
        NeoForge.EVENT_BUS.addListener(ItemStoragePlayerWrapper::onTameAnimal);
    }

    public void onRegistriesCreate(NewRegistryEvent event) {
        TunnelIngredientComponentCapabilities.load();
        TunnelAspects.load();
        PartTypes.load();
        BlockBreakHandlers.load();
        BlockPlaceHandlers.load();
    }

    protected void setup(FMLCommonSetupEvent event) {
        super.setup(event);
    }

    protected void onSetup(IntegratedDynamicsSetupEvent event) {
        TunnelValueTypeListProxyFactories.load();
        AspectRegistry.getInstance().register((IPartType)org.cyclops.integrateddynamics.core.part.PartTypes.NETWORK_READER, (Collection)Lists.newArrayList((Object[])new IAspect[]{TunnelAspects.Read.Item.LONG_COUNT, TunnelAspects.Read.Item.LONG_COUNTMAX, TunnelAspects.Read.Item.LIST_ITEMSTACKS, TunnelAspects.Read.Item.OPERATOR_GETITEMCOUNT, TunnelAspects.Read.Item.INTEGER_INTERFACES, TunnelAspects.Read.Fluid.LONG_COUNT, TunnelAspects.Read.Fluid.LONG_COUNTMAX, TunnelAspects.Read.Fluid.LIST_FLUIDSTACKS, TunnelAspects.Read.Fluid.OPERATOR_GETFLUIDCOUNT, TunnelAspects.Read.Fluid.INTEGER_INTERFACES}));
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBaseNeoForge)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.manual", "/data/integratedtunnels/info/tunnels_info.xml");
        ((IInfoBookRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IInfoBookRegistry.class)).registerSection((ModBaseNeoForge)this, (IInfoBook)OnTheDynamicsOfIntegrationBook.getInstance(), "info_book.integrateddynamics.tutorials", "/data/integratedtunnels/info/tunnels_tutorials.xml");
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).icon(() -> new ItemStack(RegistryEntries.ITEM_PART_INTERFACE));
    }

    public void onConfigsRegister(ConfigHandlerCommon configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfigCommon)new GeneralConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ItemDummyPickAxeConfig());
        configHandler.addConfigurable((ExtendedConfigCommon)new ContainerInterfaceSettingsConfig());
    }

    protected IClientProxy constructClientProxy() {
        return new ClientProxy();
    }

    protected ICommonProxy constructCommonProxy() {
        return new CommonProxy();
    }

    public Class<?>[] getGameTestClasses() {
        return new Class[]{GameTestsEnergy.class, GameTestsFluids.class, GameTestsItems.class, GameTestsPlayerSimulator.class, GameTestsWorldBlock.class, GameTestsWorldFluid.class, GameTestsWorldItem.class};
    }

    public static void clog(String message) {
        IntegratedTunnels.clog(Level.INFO, message);
    }

    public static void clog(Level level, String message) {
        _instance.getLoggerHelper().log(level, message);
    }
}

