/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core.part;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.network.PacketCodecs;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartCapability;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.network.PartNetworkElement;
import org.cyclops.integrateddynamics.core.part.PartStateBase;
import org.cyclops.integratedtunnels.core.part.ContainerInterfaceSettings;
import org.cyclops.integratedtunnels.core.part.IPartTypeInterfacePositionedAddon;
import org.cyclops.integratedtunnels.core.part.PartTypeTunnel;

public abstract class PartTypeInterfacePositionedAddon<N extends IPositionedAddonsNetwork, T, P extends PartTypeInterfacePositionedAddon<N, T, P, S>, S extends IPartTypeInterfacePositionedAddon.IState<N, T, P, S>>
extends PartTypeTunnel<P, S>
implements IPartTypeInterfacePositionedAddon<N, T, P, S> {
    public PartTypeInterfacePositionedAddon(String name) {
        super(name);
    }

    public boolean isUpdate(S state) {
        return this.getConsumptionRate((IPartState)state) > 0 && GeneralConfig.energyConsumptionMultiplier > 0 || state.requiresOffsetUpdates();
    }

    public Optional<MenuProvider> getContainerProvider(final PartPos pos) {
        return Optional.of(new MenuProvider(){

            public Component getDisplayName() {
                return Component.translatable((String)PartTypeInterfacePositionedAddon.this.getTranslationKey());
            }

            @Nullable
            public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
                Triple data = PartHelpers.getContainerPartConstructionData((PartPos)pos);
                return new ContainerInterfaceSettings(id, playerInventory, (Container)new SimpleContainer(0), (PartTarget)data.getRight(), Optional.of((IPartContainer)data.getLeft()), (IPartType)data.getMiddle());
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        });
    }

    public void writeExtraGuiData(RegistryFriendlyByteBuf packetBuffer, PartPos pos, ServerPlayer player) {
        PacketCodecs.write((RegistryFriendlyByteBuf)packetBuffer, (Object)pos);
        packetBuffer.writeUtf(this.getUniqueName().toString());
    }

    @Override
    public void onAddingPositionToNetwork(N networkCapability, INetwork network, PartPos pos, int priority, int channelInterface, S state) {
        networkCapability.addPosition(pos, priority, channelInterface);
    }

    @Override
    public void onRemovingPositionFromNetwork(N networkCapability, INetwork network, PartPos pos, S state) {
        networkCapability.removePosition(pos);
    }

    public void afterNetworkReAlive(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.afterNetworkReAlive(network, partNetwork, target, state);
        this.addTargetToNetwork(network, target.getTarget(), state.getPriority(), state.getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
    }

    public void onNetworkRemoval(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.onNetworkRemoval(network, partNetwork, target, state);
        this.scheduleNetworkObservation(target, (IPartTypeInterfacePositionedAddon.IState)state);
        this.removeTargetFromNetwork(network, target.getTarget(), (IPartTypeInterfacePositionedAddon.IState)state);
    }

    public void onNetworkAddition(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.onNetworkAddition(network, partNetwork, target, state);
        this.addTargetToNetwork(network, target.getTarget(), state.getPriority(), state.getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
        this.scheduleNetworkObservation(target, (IPartTypeInterfacePositionedAddon.IState)state);
    }

    public void onBlockNeighborChange(INetwork network, IPartNetwork partNetwork, PartTarget target, S state, BlockGetter world) {
        super.onBlockNeighborChange(network, partNetwork, target, state, world);
        if (network != null) {
            this.updateTargetInNetwork(network, target.getTarget(), state.getPriority(), state.getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
        }
    }

    public void setPriorityAndChannel(INetwork network, IPartNetwork partNetwork, PartTarget target, S state, int priority, int channel) {
        this.removeTargetFromNetwork(network, target.getTarget(), (IPartTypeInterfacePositionedAddon.IState)state);
        super.setPriorityAndChannel(network, partNetwork, target, state, priority, channel);
        this.addTargetToNetwork(network, target.getTarget(), priority, state.getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
    }

    public boolean setTargetOffset(S state, PartPos center, Vec3i offset) {
        INetwork network = state.getNetwork();
        if (network != null) {
            this.removeTargetFromNetwork(network, this.getTarget(center, (IPartState)state).getTarget(), (IPartTypeInterfacePositionedAddon.IState)state);
        }
        boolean ret = super.setTargetOffset(state, center, offset);
        if (network != null) {
            this.addTargetToNetwork(network, this.getTarget(center, (IPartState)state).getTarget(), state.getPriority(), state.getChannelInterface(), (IPartTypeInterfacePositionedAddon.IState)state);
        }
        return ret;
    }

    public void onOffsetVariablesChanged(PartTarget target, S state) {
        super.onOffsetVariablesChanged(target, state);
        state.initializeOffsets(target);
        DimPos dimPos = target.getCenter().getPos();
        INetwork network = NetworkHelpers.getNetworkChecked((ILevelExtension)dimPos.getLevel(true), (BlockPos)dimPos.getBlockPos(), (Direction)target.getCenter().getSide());
        PartNetworkElement networkElement = new PartNetworkElement((IPartType)this, target.getCenter());
        network.setPriorityAndChannel((INetworkElement)networkElement, this.getPriority((IPartState)state), this.getChannel((IPartState)state));
    }

    public static abstract class State<N extends IPositionedAddonsNetwork, T, P extends PartTypeInterfacePositionedAddon<N, T, P, S>, S extends State<N, T, P, S>>
    extends PartStateBase<P>
    implements IPartTypeInterfacePositionedAddon.IState<N, T, P, S> {
        private N positionedAddonsNetwork = null;
        private PartPos pos = null;
        private boolean validTargetCapability = false;
        private int channelInterface = 0;
        private INetwork network;
        private IPartNetwork partNetwork;

        public void serialize(ValueOutput valueOutput) {
            super.serialize(valueOutput);
            valueOutput.putInt("channelInterface", this.channelInterface);
        }

        public void deserialize(ValueInput valueInput) {
            super.deserialize(valueInput);
            this.channelInterface = (Integer)valueInput.getInt("channelInterface").orElseThrow();
        }

        @Override
        public void setChannelInterface(int channelInterface) {
            this.channelInterface = channelInterface;
            this.sendUpdate();
        }

        @Override
        public int getChannelInterface() {
            return this.channelInterface;
        }

        @Override
        @Nullable
        public N getPositionedAddonsNetwork() {
            return this.positionedAddonsNetwork;
        }

        @Override
        public void setPositionedAddonsNetwork(N positionedAddonsNetwork) {
            this.positionedAddonsNetwork = positionedAddonsNetwork;
        }

        @Override
        public boolean isValidTargetCapability() {
            return this.validTargetCapability;
        }

        @Override
        public void setValidTargetCapability(boolean validTargetCapability) {
            this.validTargetCapability = validTargetCapability;
        }

        @Override
        public PartPos getPos() {
            return this.pos;
        }

        @Override
        public void setPos(PartPos pos) {
            this.pos = pos;
        }

        @Override
        public void setNetworks(@Nullable INetwork network, @Nullable IPartNetwork partNetwork, ValueDeseralizationContext valueDeseralizationContext) {
            this.network = network;
            this.partNetwork = partNetwork;
        }

        @Override
        @Nullable
        public INetwork getNetwork() {
            return this.network;
        }

        @Override
        @Nullable
        public IPartNetwork getPartNetwork() {
            return this.partNetwork;
        }

        public <T> Optional<T> getCapability(P partType, PartCapability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
            if (this.isNetworkAndPositionValid() && capability == this.getTargetCapability()) {
                return Optional.of(this.getCapabilityInstance());
            }
            return super.getCapability(partType, capability, network, partNetwork, target);
        }
    }
}

