/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.core.block.IgnoredBlockStatus;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integratedtunnels.part.PartTypes;
import org.cyclops.integratedtunnels.part.aspect.TunnelAspects;

public class GameTestsWorldBlock {
    public static final String TEMPLATE_EMPTY = "integratedtunnels:empty10";
    public static final int TIMEOUT = 2000;
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testWorldBlockImporterToInterfaceToExporterBoolean(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_WORLD_BLOCK, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_WORLD_BLOCK.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_WORLD_BLOCK, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_WORLD_BLOCK.getItem()));
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.setBlock(POS.west(), Blocks.STONE);
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.World.BLOCK_BOOLEAN_IMPORT, (ItemStack)variableAspect);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.World.BLOCK_BOOLEAN_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent(Blocks.STONE, POS.west());
            helper.assertContainerEmpty(POS.east().east());
            helper.assertBlockPresent(Blocks.COBBLESTONE, POS.east().north());
            IPartStateWriter partStateWriter = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)).getState();
            helper.assertFalse(partStateWriter.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.IMPORTER_WORLD_BLOCK.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST)), Direction.WEST).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter.getActiveAspect(), TunnelAspects.Write.World.BLOCK_BOOLEAN_IMPORT, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter.getErrors(TunnelAspects.Write.World.BLOCK_BOOLEAN_IMPORT).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
            IPartStateWriter partStateWriter2 = (IPartStateWriter)PartHelpers.getPart((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH)).getState();
            helper.assertFalse(partStateWriter2.isDeactivated(), (Component)Component.literal((String)"Importer is deactivated"));
            helper.assertValueEqual((Object)((IgnoredBlockStatus.Status)PartTypes.EXPORTER_WORLD_BLOCK.getBlockState(PartHelpers.getPartContainerChecked((PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH)), Direction.NORTH).getValue((Property)IgnoredBlockStatus.STATUS)), (Object)IgnoredBlockStatus.Status.ACTIVE, (Component)Component.literal((String)"Block status is incorrect"));
            helper.assertValueEqual((Object)partStateWriter2.getActiveAspect(), TunnelAspects.Write.World.BLOCK_BOOLEAN_EXPORT, (Component)Component.literal((String)"Active aspect is incorrect"));
            helper.assertTrue(partStateWriter2.getErrors(TunnelAspects.Write.World.BLOCK_BOOLEAN_EXPORT).isEmpty(), (Component)Component.literal((String)"Active aspect has errors"));
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testWorldBlockImporterToInterfaceToExporterBlockCorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_WORLD_BLOCK, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_WORLD_BLOCK.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_WORLD_BLOCK, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_WORLD_BLOCK.getItem()));
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.World.BLOCK_ITEMSTACK_IMPORT, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_ITEMSTACK, (IValue)ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Blocks.COBBLESTONE))));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.World.BLOCK_BOOLEAN_EXPORT, (ItemStack)new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE));
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent(Blocks.STONE, POS.west());
            helper.assertContainerEmpty(POS.east().east());
            helper.assertBlockPresent(Blocks.COBBLESTONE, POS.east().north());
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testWorldBlockImporterToInterfaceToExporterBlockIncorrect(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_WORLD_BLOCK, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_WORLD_BLOCK.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_WORLD_BLOCK, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_WORLD_BLOCK.getItem()));
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.World.BLOCK_ITEMSTACK_IMPORT, (ItemStack)GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), (IValueType)ValueTypes.OBJECT_ITEMSTACK, (IValue)ValueObjectTypeItemStack.ValueItemStack.of((ItemStack)new ItemStack((ItemLike)Blocks.STONE))));
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.World.BLOCK_BOOLEAN_EXPORT, (ItemStack)new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE));
        helper.succeedWhen(() -> {
            helper.assertBlockPresent(Blocks.STONE, POS.west());
            helper.assertContainerEmpty(POS.east().east());
            helper.assertBlockNotPresent(Blocks.COBBLESTONE, POS.east().north());
        });
    }

    @GameTest(template="integratedtunnels:empty10", timeoutTicks=2000)
    public void testWorldBlockImporterToInterfaceToExporterShulkerBox(GameTestHelper helper) {
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        helper.setBlock(POS.east(), (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST, (IPartType)PartTypes.IMPORTER_WORLD_BLOCK, (ItemStack)new ItemStack((ItemLike)PartTypes.IMPORTER_WORLD_BLOCK.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.EAST, (IPartType)PartTypes.INTERFACE_ITEM, (ItemStack)new ItemStack((ItemLike)PartTypes.INTERFACE_ITEM.getItem()));
        PartHelpers.addPart((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH, (IPartType)PartTypes.EXPORTER_WORLD_BLOCK, (ItemStack)new ItemStack((ItemLike)PartTypes.EXPORTER_WORLD_BLOCK.getItem()));
        helper.setBlock(POS.east().east(), Blocks.CHEST);
        helper.setBlock(POS.west(), Blocks.SHULKER_BOX);
        ShulkerBoxBlockEntity shulkerBoxStart = (ShulkerBoxBlockEntity)helper.getBlockEntity(POS.west(), ShulkerBoxBlockEntity.class);
        shulkerBoxStart.setItem(0, new ItemStack((ItemLike)Items.APPLE));
        shulkerBoxStart.setItem(1, new ItemStack((ItemLike)Items.DIRT));
        ItemStack variableAspect = new ItemStack((Holder)RegistryEntries.ITEM_VARIABLE);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS), (Direction)Direction.WEST), TunnelAspects.Write.World.BLOCK_BOOLEAN_IMPORT, (ItemStack)variableAspect);
        GameTestHelpersIntegratedDynamics.placeVariableInWriter((GameTestHelper)helper, (Level)helper.getLevel(), (PartPos)PartPos.of((Level)helper.getLevel(), (BlockPos)helper.absolutePos(POS.east()), (Direction)Direction.NORTH), TunnelAspects.Write.World.BLOCK_BOOLEAN_EXPORT, (ItemStack)variableAspect);
        helper.succeedWhen(() -> {
            helper.assertBlockNotPresent(Blocks.STONE, POS.west());
            helper.assertContainerEmpty(POS.east().east());
            helper.assertBlockPresent(Blocks.SHULKER_BOX, POS.east().north());
            helper.assertContainerContains(POS.east().north(), Items.APPLE);
            helper.assertContainerContains(POS.east().north(), Items.DIRT);
        });
    }
}

