/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeListProxy;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.core.IngredientPredicateBlockOperator;
import org.cyclops.integratedtunnels.core.ItemStorageBlockWrapper;
import org.cyclops.integratedtunnels.core.TunnelHelpers;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicate;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateBlockList;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateItemStackList;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateItemStackNbt;
import org.cyclops.integratedtunnels.core.predicate.IngredientPredicateItemStackOperator;
import org.cyclops.integratedtunnels.part.aspect.ITunnelConnection;

public class TunnelItemHelpers {
    public static final IngredientPredicate<ItemStack, Integer> MATCH_NONE = new IngredientPredicate<ItemStack, Integer>(IngredientComponent.ITEMSTACK, ItemStack.f_41583_, Integer.valueOf(13), false, true, 0, false){

        @Override
        public boolean test(@Nullable ItemStack input) {
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == MATCH_NONE;
        }

        @Override
        public int hashCode() {
            return 9991029;
        }
    };

    public static IngredientPredicate<ItemStack, Integer> matchAll(int amount, boolean exactAmount) {
        return new IngredientPredicate<ItemStack, Integer>(IngredientComponent.ITEMSTACK, new ItemStack((ItemLike)Items.f_42410_, amount), Integer.valueOf(exactAmount ? 8 : 0), false, false, amount, exactAmount){

            @Override
            public boolean test(ItemStack input) {
                return true;
            }
        };
    }

    protected static int getItemStackMatchFlags(boolean checkItem, boolean checkStackSize, boolean checkNbt) {
        int matchFlags = 0;
        if (checkItem) {
            matchFlags |= 1;
        }
        if (checkNbt) {
            matchFlags |= 4;
        }
        if (checkStackSize) {
            matchFlags |= 8;
        }
        return matchFlags;
    }

    public static IngredientPredicate<ItemStack, Integer> matchItemStack(final ItemStack itemStack, boolean checkItem, final boolean checkStackSize, final boolean checkNbt, final boolean blacklist, boolean exactAmount) {
        return new IngredientPredicate<ItemStack, Integer>(IngredientComponent.ITEMSTACK, itemStack.m_41777_(), Integer.valueOf(TunnelItemHelpers.getItemStackMatchFlags(checkItem, checkStackSize, checkNbt)), blacklist, itemStack.m_41619_() && !blacklist, itemStack.m_41613_(), exactAmount){

            @Override
            public boolean test(@Nullable ItemStack input) {
                boolean result = TunnelItemHelpers.areItemStackEqual(input, itemStack, checkStackSize, true, checkNbt);
                if (blacklist) {
                    result = !result;
                }
                return result;
            }
        };
    }

    public static IngredientPredicate<ItemStack, Integer> matchItemStacks(IValueTypeListProxy<ValueObjectTypeItemStack, ValueObjectTypeItemStack.ValueItemStack> itemStacks, boolean checkItem, boolean checkStackSize, boolean checkNbt, boolean blacklist, int amount, boolean exactAmount) {
        return new IngredientPredicateItemStackList(blacklist, amount, exactAmount, itemStacks, TunnelItemHelpers.getItemStackMatchFlags(checkItem, checkStackSize, checkNbt), checkStackSize, checkItem, checkNbt);
    }

    public static IngredientPredicate<ItemStack, Integer> matchPredicateItem(PartTarget partTarget, IOperator predicate, int amount, boolean exactAmount) {
        return new IngredientPredicateItemStackOperator(amount, exactAmount, predicate, partTarget);
    }

    public static IngredientPredicate<ItemStack, Integer> matchBlocks(IValueTypeListProxy<ValueObjectTypeBlock, ValueObjectTypeBlock.ValueBlock> blocks, boolean checkItem, boolean checkStackSize, boolean checkNbt, boolean blacklist, int amount, boolean exactAmount) {
        return new IngredientPredicateBlockList(blacklist, amount, exactAmount, blocks, TunnelItemHelpers.getItemStackMatchFlags(checkItem, checkStackSize, checkNbt), checkStackSize, checkItem, checkNbt);
    }

    public static IngredientPredicate<ItemStack, Integer> matchPredicateBlock(PartTarget partTarget, IOperator predicate, int amount, boolean exactAmount) {
        return new IngredientPredicateBlockOperator(amount, exactAmount, predicate, partTarget);
    }

    public static IngredientPredicate<ItemStack, Integer> matchNbt(Optional<Tag> tag, boolean subset, boolean superset, boolean requireNbt, boolean recursive, boolean blacklist, int amount, boolean exactAmount) {
        return new IngredientPredicateItemStackNbt(blacklist, amount, exactAmount, requireNbt, subset, tag, recursive, superset);
    }

    public static boolean areItemStackEqual(ItemStack stackA, ItemStack stackB, boolean checkStackSize, boolean checkItem, boolean checkNbt) {
        if (stackA == null && stackB == null) {
            return true;
        }
        if (stackA != null && stackB != null) {
            if (checkStackSize && stackA.m_41613_() != stackB.m_41613_()) {
                return false;
            }
            if (checkItem && stackA.m_41720_() != stackB.m_41720_()) {
                return false;
            }
            return !checkNbt || Objects.equals(stackA.m_41783_(), stackB.m_41783_()) && stackA.areCapsCompatible((CapabilityProvider)stackB);
        }
        return false;
    }

    public static ItemStack placeItems(INetwork network, IPositionedAddonsNetworkIngredients<ItemStack, Integer> ingredientsNetwork, int channel, ITunnelConnection connection, IIngredientComponentStorage<ItemStack, Integer> source, Level world, BlockPos pos, Direction side, IngredientPredicate<ItemStack, Integer> itemStackMatcher, InteractionHand hand, boolean blockUpdate, boolean ignoreReplacable, boolean craftIfFailed) throws EvaluationException {
        BlockState destBlockState = world.m_8055_(pos);
        boolean isDestNonSolid = !destBlockState.m_280296_();
        boolean isDestReplaceable = destBlockState.m_60629_(TunnelHelpers.createBlockItemUseContext(world, null, pos, side, hand));
        if (!(world.m_46859_(pos) || isDestNonSolid && ignoreReplacable && isDestReplaceable)) {
            return null;
        }
        ItemStorageBlockWrapper destinationBlock = new ItemStorageBlockWrapper(true, (ServerLevel)world, pos, side, hand, blockUpdate, 0, false, ignoreReplacable, true);
        return TunnelHelpers.moveSingleStateOptimized(network, ingredientsNetwork, channel, connection, source, -1, destinationBlock, -1, itemStackMatcher, PartPos.of((Level)world, (BlockPos)pos, (Direction)side), craftIfFailed);
    }

    public static List<ItemStack> pickUpItems(INetwork network, IPositionedAddonsNetworkIngredients<ItemStack, Integer> ingredientsNetwork, int channel, ITunnelConnection connection, Level world, BlockPos pos, Direction side, IIngredientComponentStorage<ItemStack, Integer> destination, IngredientPredicate<ItemStack, Integer> itemStackMatcher, InteractionHand hand, boolean blockUpdate, boolean ignoreReplacable, int fortune, boolean silkTouch, boolean breakOnNoDrops) throws EvaluationException {
        ItemStack itemStack;
        BlockState destBlockState = world.m_8055_(pos);
        boolean isDestReplaceable = destBlockState.m_60629_(TunnelHelpers.createBlockItemUseContext(world, null, pos, side, hand));
        if (world.m_46859_(pos) || ignoreReplacable && isDestReplaceable || destBlockState.m_278721_()) {
            return null;
        }
        ItemStorageBlockWrapper sourceBlock = new ItemStorageBlockWrapper(false, (ServerLevel)world, pos, side, hand, blockUpdate, fortune, silkTouch, ignoreReplacable, breakOnNoDrops);
        ArrayList itemStacks = Lists.newArrayList();
        while (!(itemStack = TunnelHelpers.moveSingleStateOptimized(network, ingredientsNetwork, channel, connection, sourceBlock, -1, destination, -1, itemStackMatcher, PartPos.of((Level)world, (BlockPos)pos, (Direction)side), false)).m_41619_()) {
            itemStacks.add(itemStack);
        }
        List<ItemStack> cachedDrops = sourceBlock.getCachedDrops();
        if (sourceBlock.isExtracted() && cachedDrops != null) {
            Iterator<ItemStack> it = cachedDrops.iterator();
            while (it.hasNext()) {
                ItemStack cachedStack = it.next();
                if (cachedStack.m_41619_()) continue;
                ItemStack remaining = (ItemStack)destination.insert((Object)cachedStack, false);
                if (GeneralConfig.ejectItemsOnBlockDropOverflow) {
                    ItemStackHelpers.spawnItemStack((Level)world, (BlockPos)pos, (ItemStack)remaining);
                }
                it.remove();
            }
            sourceBlock.postExtract();
        }
        return itemStacks;
    }

    public static ItemStack prototypeWithCount(ItemStack prototype, int count) {
        if (prototype.m_41613_() != count) {
            if (prototype.m_41619_()) {
                return new ItemStack((ItemLike)Items.f_42410_, count);
            }
            prototype = prototype.m_41777_();
            prototype.m_41764_(count);
        }
        return prototype;
    }
}

