/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.serdes.commons.serializer;

import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.schema.GenericsDeclaration;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.serdes.DeserializationData;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.serdes.ObjectSerializer;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.serdes.SerializationData;
import java.time.Instant;
import lombok.NonNull;

public class InstantSerializer
implements ObjectSerializer<Instant> {
    private final boolean numeric;

    @Override
    public boolean supports(@NonNull Class<? super Instant> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Instant.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull Instant object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        if (this.numeric) {
            data.setValue((Object)object.toEpochMilli(), Long.class);
        } else {
            data.setValue(object.toString());
        }
    }

    @Override
    public Instant deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        if (data.getValueRaw() instanceof String) {
            return Instant.parse((String)data.getValueRaw());
        }
        return Instant.ofEpochMilli(data.getValue(Long.TYPE));
    }

    public InstantSerializer(boolean numeric) {
        this.numeric = numeric;
    }
}

