/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.yaml.bukkit.serdes.serializer;

import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.schema.GenericsDeclaration;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.serdes.DeserializationData;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.serdes.ObjectSerializer;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.serdes.SerializationData;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;

public class ShapedRecipeSerializer
implements ObjectSerializer<ShapedRecipe> {
    private static Boolean hasNamespacedKey = null;
    private static Boolean hasRecipeChoices = null;
    private final Plugin plugin;

    @Override
    public boolean supports(@NonNull Class<? super ShapedRecipe> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return ShapedRecipe.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull ShapedRecipe shapedRecipe, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (shapedRecipe == null) {
            throw new NullPointerException("shapedRecipe is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        if (ShapedRecipeSerializer.hasNamespacedKey()) {
            data.add("key", shapedRecipe.getKey().getKey());
        }
        List<String> shapeList = Arrays.asList(shapedRecipe.getShape());
        data.addCollection("shape", shapeList, String.class);
        if (ShapedRecipeSerializer.hasRecipeChoices()) {
            Map choices = shapedRecipe.getChoiceMap().entrySet().stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getKey()), entry -> {
                if (entry.getValue() instanceof RecipeChoice.ExactChoice) {
                    List stacks = ((RecipeChoice.ExactChoice)entry.getValue()).getChoices();
                    GenericsDeclaration listType = GenericsDeclaration.of(List.class, Collections.singletonList(ItemStack.class));
                    return (List)data.getConfigurer().simplifyCollection(stacks, listType, data.getContext(), true);
                }
                if (entry.getValue() instanceof RecipeChoice.MaterialChoice) {
                    List materials = ((RecipeChoice.MaterialChoice)entry.getValue()).getChoices();
                    GenericsDeclaration listType = GenericsDeclaration.of(List.class, Collections.singletonList(Material.class));
                    return (List)data.getConfigurer().simplifyCollection(materials, listType, data.getContext(), true);
                }
                throw new IllegalArgumentException("Unknown choice type in recipe: " + ((RecipeChoice)entry.getValue()).getClass() + " [" + entry + "]");
            }, (u, v) -> {
                throw new IllegalStateException("Duplicate recipe key u=" + u + ", v=" + v);
            }, LinkedHashMap::new));
            data.addRaw("ingredients", choices);
        } else {
            Map ingredientMap = shapedRecipe.getIngredientMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Collections.singletonList(((ItemStack)entry.getValue()).getType()), (u, v) -> {
                throw new IllegalStateException("Duplicate recipe key u=" + u + ", v=" + v);
            }, LinkedHashMap::new));
            GenericsDeclaration valueType = GenericsDeclaration.of(List.class, Collections.singletonList(Material.class));
            data.addAsMap("ingredients", ingredientMap, GenericsDeclaration.of(Map.class, Arrays.asList(Character.class, valueType)));
        }
        data.add("result", (Object)shapedRecipe.getResult(), ItemStack.class);
    }

    @Override
    public ShapedRecipe deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        ItemStack result = data.get("result", ItemStack.class);
        List<String> shape = data.getAsList("shape", String.class);
        ShapedRecipe recipe = ShapedRecipeSerializer.hasNamespacedKey() ? new ShapedRecipe(new NamespacedKey(this.plugin, data.get("key", String.class)), result) : new ShapedRecipe(result);
        recipe.shape(shape.toArray(new String[0]));
        Map<Character, Object> ingredients = data.getAsMap("ingredients", Character.class, Object.class);
        for (Map.Entry<Character, Object> entry : ingredients.entrySet()) {
            Object firstElement;
            if (!(entry.getValue() instanceof Collection)) {
                throw new IllegalArgumentException("Unknown recipe ingredient for " + entry.getKey() + ": " + entry.getValue() + " (" + entry.getValue().getClass() + ")");
            }
            List list = (List)entry.getValue();
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Empty ingredients list for " + entry.getKey());
            }
            if (ShapedRecipeSerializer.hasRecipeChoices()) {
                firstElement = list.get(0);
                if (firstElement instanceof String) {
                    recipe.setIngredient(entry.getKey().charValue(), (RecipeChoice)new RecipeChoice.MaterialChoice(list.stream().map(String.class::cast).map(Material::valueOf).collect(Collectors.toList())));
                    continue;
                }
                if (firstElement instanceof Map) {
                    recipe.setIngredient(entry.getKey().charValue(), (RecipeChoice)new RecipeChoice.ExactChoice(list.stream().map(map -> data.getConfigurer().resolveType(map, GenericsDeclaration.of(map), ItemStack.class, GenericsDeclaration.of(ItemStack.class), data.getContext())).collect(Collectors.toList())));
                    continue;
                }
                throw new IllegalArgumentException("Unknown recipe ingredient type for " + entry.getKey() + ": " + firstElement.getClass());
            }
            if (list.size() > 1) {
                throw new IllegalArgumentException("Recipes with more than one Material are not allowed on this version: " + list);
            }
            firstElement = list.get(0);
            if (firstElement instanceof String) {
                Material material = Material.valueOf((String)((String)firstElement));
                recipe.setIngredient(entry.getKey().charValue(), material);
                continue;
            }
            throw new IllegalArgumentException("Unknown recipe ingredient type for " + entry.getKey() + ": " + firstElement.getClass());
        }
        return recipe;
    }

    private static boolean hasNamespacedKey() {
        if (hasNamespacedKey == null) {
            try {
                Class.forName("org.bukkit.NamespacedKey");
                hasNamespacedKey = true;
            }
            catch (ClassNotFoundException ignored) {
                hasNamespacedKey = false;
            }
        }
        return hasNamespacedKey;
    }

    private static boolean hasRecipeChoices() {
        if (hasRecipeChoices == null) {
            try {
                Class.forName("org.bukkit.inventory.RecipeChoice");
                hasRecipeChoices = true;
            }
            catch (ClassNotFoundException ignored) {
                hasRecipeChoices = false;
            }
        }
        return hasRecipeChoices;
    }

    public ShapedRecipeSerializer(Plugin plugin) {
        this.plugin = plugin;
    }
}

