/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.yaml.bukkit.serdes.transformer.experimental;

import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.schema.GenericsPair;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.serdes.BidirectionalTransformer;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.serdes.SerdesContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import lombok.NonNull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class StringBase64ItemStackTransformer
extends BidirectionalTransformer<ItemStack, String> {
    @Override
    public GenericsPair<ItemStack, String> getPair() {
        return this.genericsPair(ItemStack.class, String.class);
    }

    @Override
    public String leftToRight(@NonNull ItemStack data, @NonNull SerdesContext serdesContext) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (serdesContext == null) {
            throw new NullPointerException("serdesContext is marked non-null but is null");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BukkitObjectOutputStream dataOutput = new BukkitObjectOutputStream((OutputStream)outputStream);
        dataOutput.writeObject((Object)data);
        dataOutput.close();
        return Base64.getEncoder().encodeToString(outputStream.toByteArray()).trim();
    }

    @Override
    public ItemStack rightToLeft(@NonNull String data, @NonNull SerdesContext serdesContext) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (serdesContext == null) {
            throw new NullPointerException("serdesContext is marked non-null but is null");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(Base64.getDecoder().decode(data));
        BukkitObjectInputStream dataInput = new BukkitObjectInputStream((InputStream)inputStream);
        ItemStack item = (ItemStack)dataInput.readObject();
        dataInput.close();
        return item;
    }
}

