/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.context;

import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.Placeholders;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.context.PlaceholderContext;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.message.part.MessageField;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.schema.meta.SchemaMeta;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.schema.resolver.DefaultSchemaResolver;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.schema.resolver.PlaceholderResolver;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class Placeholder {
    private final Object value;
    private Placeholders placeholders;
    private PlaceholderContext context;

    public static Placeholder of(@Nullable Object value) {
        return new Placeholder(value);
    }

    public static Placeholder of(@Nullable Placeholders placeholders, @Nullable Object value) {
        return Placeholder.of(placeholders, value, null);
    }

    public static Placeholder of(@Nullable Placeholders placeholders, @Nullable Object value, @Nullable PlaceholderContext context) {
        Placeholder placeholder = new Placeholder(value);
        placeholder.setPlaceholders(placeholders);
        placeholder.setContext(context);
        return placeholder;
    }

    @Nullable
    public String render(@NonNull MessageField field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return this.render(this.value, field);
    }

    @Nullable
    private String render(@Nullable Object object, @NonNull MessageField field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (object == null) {
            return null;
        }
        if (this.placeholders != null) {
            if (field.getSub() != null) {
                MessageField fieldSub = field.getSub();
                PlaceholderResolver resolver = this.placeholders.getResolver(object, fieldSub.getName());
                if (resolver == null) {
                    if (object.getClass().getAnnotation(com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.schema.annotation.Placeholder.class) != null) {
                        return this.renderUsingPlaceholderSchema(object, field);
                    }
                    return "<noresolver:" + field.getName() + "@" + fieldSub.getName() + ">";
                }
                object = resolver.resolve(object, fieldSub, this.context);
                if (fieldSub.hasSub()) {
                    return this.render(object, fieldSub);
                }
            } else {
                PlaceholderResolver resolver = this.placeholders.getResolver(object, null);
                if (resolver != null) {
                    object = resolver.resolve(object, field, this.context);
                }
            }
        }
        if (object == null) {
            return null;
        }
        if (DefaultSchemaResolver.INSTANCE.supports(object.getClass())) {
            return DefaultSchemaResolver.INSTANCE.resolve(object, field);
        }
        if (object.getClass().getAnnotation(com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.schema.annotation.Placeholder.class) != null) {
            return this.renderUsingPlaceholderSchema(object, field);
        }
        return "<norenderer:" + field.getLastSubPath() + "(" + object.getClass().getSimpleName() + ")>";
    }

    private String renderUsingPlaceholderSchema(@NonNull Object object, @NonNull MessageField field) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        SchemaMeta meta = SchemaMeta.of(object.getClass());
        if (field.getSub() == null) {
            throw new RuntimeException("rendering PlaceholderSchema itself not supported at the moment");
        }
        MessageField fieldSub = field.getSub();
        Map<String, PlaceholderResolver> placeholders = meta.getPlaceholders();
        PlaceholderResolver resolver = placeholders.get(fieldSub.getName());
        if (resolver == null) {
            throw new RuntimeException("resolver cannot be null: " + fieldSub.getName());
        }
        Object resolved = resolver.resolve(object, fieldSub, this.context);
        return this.render(resolved, fieldSub);
    }

    public Object getValue() {
        return this.value;
    }

    public Placeholders getPlaceholders() {
        return this.placeholders;
    }

    public PlaceholderContext getContext() {
        return this.context;
    }

    public void setPlaceholders(Placeholders placeholders) {
        this.placeholders = placeholders;
    }

    public void setContext(PlaceholderContext context) {
        this.context = context;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Placeholder)) {
            return false;
        }
        Placeholder other = (Placeholder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Placeholders this$placeholders = this.getPlaceholders();
        Placeholders other$placeholders = other.getPlaceholders();
        if (this$placeholders == null ? other$placeholders != null : !this$placeholders.equals(other$placeholders)) {
            return false;
        }
        PlaceholderContext this$context = this.getContext();
        PlaceholderContext other$context = other.getContext();
        return !(this$context == null ? other$context != null : !((Object)this$context).equals(other$context));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Placeholder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Placeholders $placeholders = this.getPlaceholders();
        result = result * 59 + ($placeholders == null ? 43 : $placeholders.hashCode());
        PlaceholderContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        return result;
    }

    public String toString() {
        return "Placeholder(value=" + this.getValue() + ", placeholders=" + this.getPlaceholders() + ")";
    }

    private Placeholder(Object value) {
        this.value = value;
    }
}

