/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.context;

import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.Placeholders;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.context.FailMode;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.context.Placeholder;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.message.CompiledMessage;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.message.part.MessageElement;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.message.part.MessageField;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.message.part.MessageStatic;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderContext {
    private final Map<String, Placeholder> fields = new LinkedHashMap<String, Placeholder>();
    private final CompiledMessage message;
    private final FailMode failMode;
    private Placeholders placeholders;

    public static PlaceholderContext create() {
        return PlaceholderContext.create(FailMode.FAIL_SAFE);
    }

    public static PlaceholderContext create(@NonNull FailMode failMode) {
        if (failMode == null) {
            throw new NullPointerException("failMode is marked non-null but is null");
        }
        return new PlaceholderContext(null, failMode);
    }

    public static PlaceholderContext of(@NonNull CompiledMessage message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return PlaceholderContext.of(null, message);
    }

    public static PlaceholderContext of(@Nullable Placeholders placeholders, @NonNull CompiledMessage message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return PlaceholderContext.of(placeholders, message, FailMode.FAIL_SAFE);
    }

    public static PlaceholderContext of(@Nullable Placeholders placeholders, @NonNull CompiledMessage message, @NonNull FailMode failMode) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (failMode == null) {
            throw new NullPointerException("failMode is marked non-null but is null");
        }
        PlaceholderContext context = new PlaceholderContext(message, failMode);
        context.setPlaceholders(placeholders);
        return context;
    }

    public PlaceholderContext with(@NonNull String field, @Nullable Object value) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (!(this.placeholders == null || !this.placeholders.isFastMode() || this.message == null || this.message.isWithFields() && this.message.hasField(field))) {
            return this;
        }
        this.fields.put(field, Placeholder.of(this.placeholders, value, this));
        return this;
    }

    public PlaceholderContext with(@NonNull Map<String, Object> fields) {
        if (fields == null) {
            throw new NullPointerException("fields is marked non-null but is null");
        }
        fields.forEach(this::with);
        return this;
    }

    public Map<MessageField, String> renderFields() {
        return this.renderFields(this.message);
    }

    public Map<MessageField, String> renderFields(@NonNull CompiledMessage message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (message != this.message && this.message != null) {
            throw new IllegalArgumentException("cannot apply another message for context created with prepacked message: if you intended to use this context as shared please use empty context from #create(), if you're just trying to send a message use of(message)");
        }
        if (!message.isWithFields()) {
            return Collections.emptyMap();
        }
        String state = message.getRaw();
        List<MessageElement> parts = message.getParts();
        LinkedHashMap<MessageField, String> rendered = new LinkedHashMap<MessageField, String>();
        for (MessageElement part : parts) {
            String render;
            if (!(part instanceof MessageField)) continue;
            MessageField field = (MessageField)part;
            String name = field.getName();
            String alreadyRendered = (String)rendered.get(field);
            if (alreadyRendered != null) continue;
            Placeholder placeholder = this.fields.get(name);
            if (placeholder == null || placeholder.getValue() == null) {
                if (field.getDefaultValue() != null) {
                    placeholder = Placeholder.of(null, field.getDefaultValue(), this);
                } else {
                    if (this.failMode == FailMode.FAIL_FAST) {
                        throw new IllegalArgumentException("missing placeholder '" + name + "' for message '" + state + "'");
                    }
                    if (this.failMode == FailMode.FAIL_SAFE) {
                        placeholder = Placeholder.of(null, "<missing:" + field.getLastSubPath() + ">", this);
                    } else {
                        throw new RuntimeException("unknown fail mode: " + (Object)((Object)this.failMode));
                    }
                }
            }
            if ((render = placeholder.render(field)) == null) {
                if (field.getDefaultValue() != null) {
                    render = field.getDefaultValue();
                } else {
                    if (this.failMode == FailMode.FAIL_FAST) {
                        throw new IllegalArgumentException("rendered null for placeholder '" + name + "' for message '" + state + "'");
                    }
                    if (this.failMode == FailMode.FAIL_SAFE) {
                        render = "<null:" + field.getLastSubPath() + ">";
                    } else {
                        throw new RuntimeException("unknown fail mode: " + (Object)((Object)this.failMode));
                    }
                }
            }
            rendered.put(field, render);
        }
        return rendered;
    }

    public String apply() {
        return this.apply(this.message);
    }

    public String apply(@NonNull CompiledMessage message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        List<MessageElement> parts = message.getParts();
        Map<MessageField, String> rendered = this.renderFields(message);
        StringBuilder builder = new StringBuilder();
        for (MessageElement part : parts) {
            if (part instanceof MessageStatic) {
                builder.append(((MessageStatic)part).getValue());
                continue;
            }
            if (part instanceof MessageField) {
                MessageField field = (MessageField)part;
                String render = rendered.get(field);
                builder.append(render);
                continue;
            }
            throw new IllegalArgumentException("unknown message part: " + part);
        }
        return builder.toString();
    }

    public PlaceholderContext(CompiledMessage message, FailMode failMode) {
        this.message = message;
        this.failMode = failMode;
    }

    public Map<String, Placeholder> getFields() {
        return this.fields;
    }

    public CompiledMessage getMessage() {
        return this.message;
    }

    public FailMode getFailMode() {
        return this.failMode;
    }

    public Placeholders getPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(Placeholders placeholders) {
        this.placeholders = placeholders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlaceholderContext)) {
            return false;
        }
        PlaceholderContext other = (PlaceholderContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Placeholder> this$fields = this.getFields();
        Map<String, Placeholder> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        CompiledMessage this$message = this.getMessage();
        CompiledMessage other$message = other.getMessage();
        if (this$message == null ? other$message != null : !((Object)this$message).equals(other$message)) {
            return false;
        }
        FailMode this$failMode = this.getFailMode();
        FailMode other$failMode = other.getFailMode();
        if (this$failMode == null ? other$failMode != null : !((Object)((Object)this$failMode)).equals((Object)other$failMode)) {
            return false;
        }
        Placeholders this$placeholders = this.getPlaceholders();
        Placeholders other$placeholders = other.getPlaceholders();
        return !(this$placeholders == null ? other$placeholders != null : !this$placeholders.equals(other$placeholders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlaceholderContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Placeholder> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        CompiledMessage $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        FailMode $failMode = this.getFailMode();
        result = result * 59 + ($failMode == null ? 43 : ((Object)((Object)$failMode)).hashCode());
        Placeholders $placeholders = this.getPlaceholders();
        result = result * 59 + ($placeholders == null ? 43 : $placeholders.hashCode());
        return result;
    }

    public String toString() {
        return "PlaceholderContext(fields=" + this.getFields() + ", message=" + this.getMessage() + ", failMode=" + (Object)((Object)this.getFailMode()) + ", placeholders=" + this.getPlaceholders() + ")";
    }
}

