/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.message.part;

import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.message.part.FieldParams;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class MessageFieldTokenizer {
    public List<FieldParams> tokenize(@NonNull String field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        ArrayList<FieldParams> tokens = new ArrayList<FieldParams>();
        char[] charArray = field.toCharArray();
        StringBuilder buffer = new StringBuilder();
        boolean parsingArgs = false;
        String name = "";
        int charArrayLength = charArray.length;
        for (int i = 0; i < charArrayLength; ++i) {
            char c = charArray[i];
            if (c == '(' && !parsingArgs) {
                name = buffer.toString();
                buffer.setLength(0);
                parsingArgs = true;
                continue;
            }
            if (c == ')' && (charArrayLength == i + 1 || charArray[i + 1] == '.') && parsingArgs) {
                tokens.add(FieldParams.of(name, this.tokenizeArgs(buffer.toString()).toArray(new String[0])));
                buffer.setLength(0);
                parsingArgs = false;
                ++i;
                continue;
            }
            if (parsingArgs) {
                buffer.append(c);
                continue;
            }
            if (charArrayLength == i + 1 || charArray[i + 1] == '.') {
                buffer.append(c);
                tokens.add(FieldParams.of(buffer.toString(), new String[0]));
                buffer.setLength(0);
                ++i;
                continue;
            }
            buffer.append(c);
        }
        return tokens;
    }

    public List<String> tokenizeArgs(@NonNull String argText) {
        if (argText == null) {
            throw new NullPointerException("argText is marked non-null but is null");
        }
        if (argText.isEmpty()) {
            return Collections.singletonList("");
        }
        ArrayList<String> args = new ArrayList<String>();
        char[] charArray = argText.toCharArray();
        StringBuilder buffer = new StringBuilder();
        int charArrayLength = charArray.length;
        for (int i = 0; i < charArrayLength; ++i) {
            char c = charArray[i];
            if (c == ',') {
                if (i > 0 && charArray[i - 1] == '\\') {
                    buffer.setCharAt(buffer.length() - 1, c);
                    continue;
                }
                args.add(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (charArrayLength == i + 1) {
                buffer.append(c);
                args.add(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            buffer.append(c);
        }
        return args;
    }
}

