/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.commands;

import com.epicplayera10.optimizationutils.OptimizationUtils;
import com.epicplayera10.optimizationutils.libs.acf.BaseCommand;
import com.epicplayera10.optimizationutils.libs.acf.CommandHelp;
import com.epicplayera10.optimizationutils.libs.acf.annotation.CommandAlias;
import com.epicplayera10.optimizationutils.libs.acf.annotation.CommandPermission;
import com.epicplayera10.optimizationutils.libs.acf.annotation.Description;
import com.epicplayera10.optimizationutils.libs.acf.annotation.HelpCommand;
import com.epicplayera10.optimizationutils.libs.acf.annotation.Optional;
import com.epicplayera10.optimizationutils.libs.acf.annotation.Subcommand;
import com.epicplayera10.optimizationutils.libs.acf.annotation.Syntax;
import com.epicplayera10.optimizationutils.libs.acf.bukkit.contexts.OnlinePlayer;
import com.epicplayera10.optimizationutils.manager.SimulationDistanceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.plugin.Plugin;

@CommandAlias(value="optimizationutils|ou|opt")
@CommandPermission(value="optimizationutils.admin")
public class OptimizationUtilsCommand
extends BaseCommand {
    @HelpCommand
    public void doHelp(CommandSender sender, CommandHelp help) {
        help.showHelp();
    }

    @Subcommand(value="analyzechunks")
    @Description(value="Analyze loaded chunks for entity counts")
    public void analyzeChunks(Player player) {
        player.sendMessage("Analyzing chunks...");
        World world = player.getWorld();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)OptimizationUtils.instance(), () -> {
            HashMap<Chunk, Integer> chunkEntities = new HashMap<Chunk, Integer>();
            for (Chunk chunk : world.getLoadedChunks()) {
                chunkEntities.put(chunk, chunk.getEntities().length);
            }
            chunkEntities.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).forEach(entry -> {
                Chunk chunk = (Chunk)entry.getKey();
                int entities = (Integer)entry.getValue();
                player.sendMessage(entities + " -> Chunk " + chunk.getX() + " " + chunk.getZ());
            });
        });
    }

    @Subcommand(value="setsimulationdistance")
    @Syntax(value="<new simulation distance>")
    @Description(value="Sets simulation distance for all worlds while respecting despawn ranges")
    public void setSimulationDistance(CommandSender sender, int newSimulationDistance) {
        for (World world : Bukkit.getWorlds()) {
            world.setSimulationDistance(newSimulationDistance);
            try {
                SimulationDistanceManager.setNMSSimulationDistance(world, newSimulationDistance);
            }
            catch (NoClassDefFoundError e) {
                OptimizationUtils.instance().getLogger().warning("Cannot update related configuration using NMS because your server version is not supported.");
            }
        }
        sender.sendMessage(Component.text((String)("Successfully set simulation distance to " + newSimulationDistance + " for all worlds.")).color((TextColor)NamedTextColor.GREEN));
        sender.sendMessage(Component.text((String)"Make sure that \"/paper mobcaps\" will go to the max mobcap, or else use \"/ou setspawnlimit\" to lower mobcap.").color((TextColor)NamedTextColor.YELLOW));
    }

    @Subcommand(value="setspawnlimit")
    @Syntax(value="<spawn category> <limit>")
    @Description(value="Sets mobcap for all worlds")
    public void setSpawnLimit(CommandSender sender, SpawnCategory spawnCategory, int limit) {
        for (World world : Bukkit.getWorlds()) {
            world.setSpawnLimit(spawnCategory, limit);
        }
        sender.sendMessage(Component.text((String)("Successfully set spawn limit for " + spawnCategory.name() + " to " + limit + " for all worlds.")).color((TextColor)NamedTextColor.GREEN));
    }

    @Subcommand(value="setticksperspawn")
    @Syntax(value="<spawn category> <ticks>")
    @Description(value="Sets ticks per spawn for all worlds. This is the mob spawn frequency, how fast the server makes a check for spawning mobs.")
    public void setTicksPerSpawn(CommandSender sender, SpawnCategory spawnCategory, int ticks) {
        for (World world : Bukkit.getWorlds()) {
            world.setTicksPerSpawns(spawnCategory, ticks);
        }
        sender.sendMessage(Component.text((String)("Successfully set ticks per spawn for " + spawnCategory.name() + " to " + ticks + " for all worlds.")).color((TextColor)NamedTextColor.GREEN));
    }

    @Subcommand(value="killoutofrange")
    @Description(value="Kills entities that are out of range of players in the world")
    public void killOutOfRange(Player player, EntityType entityType, int range) {
        World world = player.getWorld();
        Bukkit.getScheduler().runTask((Plugin)OptimizationUtils.instance(), () -> {
            List toRemove = world.getEntities().stream().filter(entity -> entity.getType() == entityType).collect(Collectors.toCollection(ArrayList::new));
            for (Player onlinePlayer : world.getPlayers()) {
                toRemove.removeIf(entity -> entity.getLocation().distance(onlinePlayer.getLocation()) <= (double)range);
            }
            for (Entity entity2 : toRemove) {
                entity2.remove();
            }
            player.sendMessage(Component.text((String)("Killed " + toRemove.size() + " entities out of range.")).color((TextColor)NamedTextColor.GREEN));
        });
    }

    @Subcommand(value="killanimalsoutofrange")
    @Description(value="Kills animals that are out of range of players in the world")
    @Syntax(value="<range>")
    public void killAnimalsOutOfRange(Player player, int range) {
        World world = player.getWorld();
        Bukkit.getScheduler().runTask((Plugin)OptimizationUtils.instance(), () -> {
            Collection toRemove = world.getEntitiesByClass(Animals.class);
            for (Player onlinePlayer : world.getPlayers()) {
                toRemove.removeIf(entity -> entity.getLocation().distance(onlinePlayer.getLocation()) <= (double)range);
            }
            for (Animals animal : toRemove) {
                animal.remove();
            }
            player.sendMessage(Component.text((String)("Killed " + toRemove.size() + " animals out of range.")).color((TextColor)NamedTextColor.GREEN));
        });
    }

    @Subcommand(value="setviewdistance")
    @Syntax(value="<new view distance> [player]")
    @Description(value="Sets view distance for all worlds")
    public void setViewDistance(CommandSender sender, int newViewDistance, @Optional OnlinePlayer target) {
        if (target != null) {
            target.player.setViewDistance(newViewDistance);
            sender.sendMessage(Component.text((String)("Successfully set view distance to " + newViewDistance + " for " + target.player.getName())).color((TextColor)NamedTextColor.GREEN));
        } else {
            for (World world : Bukkit.getWorlds()) {
                world.setViewDistance(newViewDistance);
            }
            sender.sendMessage(Component.text((String)("Successfully set view distance to " + newViewDistance + " for all worlds.")).color((TextColor)NamedTextColor.GREEN));
        }
    }

    @Subcommand(value="reload")
    @Description(value="Reloads the configuration")
    public void reload(CommandSender sender) {
        OptimizationUtils.instance().reloadConfiguration();
        sender.sendMessage(Component.text((String)"Configuration reloaded successfully.").color((TextColor)NamedTextColor.GREEN));
    }

    @Subcommand(value="info")
    @Description(value="Displays server and plugin information.")
    public void info(CommandSender sender) {
        Component message = ((TextComponent)((TextComponent)Component.text((String)"=== OptimizationUtils Info ===").color((TextColor)NamedTextColor.GREEN)).append((Component)Component.newline())).append((Component)Component.newline());
        message = message.append(Component.text((String)"View Distance:").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.newline());
        for (World world : Bukkit.getWorlds()) {
            int viewDistance = world.getViewDistance();
            message = message.append(Component.text((String)("  " + world.getName() + ": " + viewDistance)).color((TextColor)NamedTextColor.WHITE)).append((Component)Component.newline());
        }
        message = message.append((Component)Component.newline());
        message = message.append(Component.text((String)"Simulation Distance:").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.newline());
        for (World world : Bukkit.getWorlds()) {
            int simulationDistance = world.getSimulationDistance();
            message = message.append(Component.text((String)("  " + world.getName() + ": " + simulationDistance)).color((TextColor)NamedTextColor.WHITE)).append((Component)Component.newline());
        }
        message = message.append((Component)Component.newline());
        Map<Integer, Long> viewDistanceGroups = Bukkit.getOnlinePlayers().stream().collect(Collectors.groupingBy(player -> player.getViewDistance() != 0 ? player.getViewDistance() : player.getWorld().getViewDistance(), Collectors.counting()));
        message = message.append(Component.text((String)"Player View Distance:").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.newline());
        if (viewDistanceGroups.isEmpty()) {
            message = message.append(Component.text((String)"  No players online").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.newline());
        } else {
            List sortedViewDistanceGroups = viewDistanceGroups.entrySet().stream().sorted(Map.Entry.comparingByKey().reversed()).collect(Collectors.toList());
            for (Iterator entry : sortedViewDistanceGroups) {
                message = message.append(Component.text((String)("  " + String.valueOf(entry.getKey()) + " view distance - " + String.valueOf(entry.getValue()) + " players")).color((TextColor)NamedTextColor.WHITE)).append((Component)Component.newline());
            }
        }
        message = message.append((Component)Component.newline());
        Map<Integer, Long> simulationDistanceGroups = Bukkit.getOnlinePlayers().stream().collect(Collectors.groupingBy(player -> player.getSimulationDistance() != 0 ? player.getSimulationDistance() : player.getWorld().getSimulationDistance(), Collectors.counting()));
        message = message.append(Component.text((String)"Player Simulation Distance:").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.newline());
        if (simulationDistanceGroups.isEmpty()) {
            message = message.append(Component.text((String)"  No players online").color((TextColor)NamedTextColor.GRAY)).append((Component)Component.newline());
        } else {
            List sortedSimulationDistanceGroups = simulationDistanceGroups.entrySet().stream().sorted(Map.Entry.comparingByKey().reversed()).collect(Collectors.toList());
            for (Map.Entry entry : sortedSimulationDistanceGroups) {
                message = message.append(Component.text((String)("  " + String.valueOf(entry.getKey()) + " simulation distance - " + String.valueOf(entry.getValue()) + " players")).color((TextColor)NamedTextColor.WHITE)).append((Component)Component.newline());
            }
        }
        message = message.append((Component)Component.newline());
        int totalEntities = 0;
        message = message.append(Component.text((String)"Entity Count:").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.newline());
        for (Object world : Bukkit.getWorlds()) {
            int entityCount = world.getEntityCount();
            totalEntities += entityCount;
            message = message.append(Component.text((String)("  " + world.getName() + ": " + entityCount)).color((TextColor)NamedTextColor.WHITE)).append((Component)Component.newline());
        }
        message = message.append(Component.text((String)("Total Entities: " + totalEntities)).color((TextColor)NamedTextColor.YELLOW)).append((Component)Component.newline()).append((Component)Component.newline());
        int totalChunks = 0;
        message = message.append(Component.text((String)"Loaded Chunks:").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.newline());
        for (World world : Bukkit.getWorlds()) {
            int chunkCount = world.getLoadedChunks().length;
            totalChunks += chunkCount;
            message = message.append(Component.text((String)("  " + world.getName() + ": " + chunkCount)).color((TextColor)NamedTextColor.WHITE)).append((Component)Component.newline());
        }
        message = message.append(Component.text((String)("Total Loaded Chunks: " + totalChunks)).color((TextColor)NamedTextColor.YELLOW)).append((Component)Component.newline()).append((Component)Component.newline());
        message = message.append(Component.text((String)"Random Tick Speed:").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.newline());
        for (World world : Bukkit.getWorlds()) {
            int randomTickSpeed = (Integer)world.getGameRuleValue(GameRule.RANDOM_TICK_SPEED);
            message = message.append(Component.text((String)("  " + world.getName() + ": " + randomTickSpeed)).color((TextColor)NamedTextColor.WHITE)).append((Component)Component.newline());
        }
        message = message.append((Component)Component.newline());
        message = message.append(Component.text((String)"Plugin Configuration:").color((TextColor)NamedTextColor.AQUA)).append((Component)Component.newline());
        message = message.append(Component.text((String)("  MSPT Calculation Mode: " + String.valueOf((Object)OptimizationUtils.instance().pluginConfiguration().msptCalculationMode))).color((TextColor)NamedTextColor.GRAY)).append((Component)Component.newline());
        String dynamicMobcapStatus = OptimizationUtils.instance().pluginConfiguration().dynamicMobcap.enabled ? "Enabled (threshold: " + OptimizationUtils.instance().pluginConfiguration().dynamicMobcap.msptThreshold + "ms)" : "Disabled";
        message = message.append(Component.text((String)("  Dynamic Mobcap: " + dynamicMobcapStatus)).color((TextColor)NamedTextColor.GRAY)).append((Component)Component.newline());
        String dynamicRandomTickStatus = OptimizationUtils.instance().pluginConfiguration().dynamicRandomTickSpeed.enabled ? "Enabled (threshold: " + OptimizationUtils.instance().pluginConfiguration().dynamicRandomTickSpeed.msptThreshold + "ms)" : "Disabled";
        message = message.append(Component.text((String)("  Dynamic Random Tick Speed: " + dynamicRandomTickStatus)).color((TextColor)NamedTextColor.GRAY));
        sender.sendMessage(message);
    }
}

