/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.libs.eu.okaeri.pluralize;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import lombok.NonNull;

public final class Pluralize {
    private static final Map<String, Function<Integer, Integer>> PLURALIZERS = new HashMap<String, Function<Integer, Integer>>();
    private static final Map<String, Integer> PLURALS = new HashMap<String, Integer>();

    private static void add(@NonNull String isoLocale, int nplurals, @NonNull Function<Integer, Integer> pluralizer) {
        if (isoLocale == null) {
            throw new NullPointerException("isoLocale is marked non-null but is null");
        }
        if (pluralizer == null) {
            throw new NullPointerException("pluralizer is marked non-null but is null");
        }
        PLURALIZERS.put(isoLocale, pluralizer);
        PLURALS.put(isoLocale, nplurals);
    }

    public static Optional<Function<Integer, Integer>> getPluralizer(@NonNull Locale locale) {
        Function<Integer, Integer> pluralizer;
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if (!lang.isEmpty() && !country.isEmpty() && (pluralizer = PLURALIZERS.get(lang + "_" + country)) != null) {
            return Optional.of(pluralizer);
        }
        pluralizer = PLURALIZERS.get(lang);
        return Optional.ofNullable(pluralizer);
    }

    @Deprecated
    public static Optional<Function<Integer, Integer>> getPluralizer(@NonNull String isoLocale) {
        if (isoLocale == null) {
            throw new NullPointerException("isoLocale is marked non-null but is null");
        }
        return Optional.ofNullable(PLURALIZERS.get(isoLocale));
    }

    public static String pluralize(@NonNull Locale locale, int n, String ... plurals) {
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        if (plurals == null) {
            throw new NullPointerException("plurals is marked non-null but is null");
        }
        Optional<Function<Integer, Integer>> pluralizer = Pluralize.getPluralizer(locale);
        if (!pluralizer.isPresent()) {
            throw new IllegalArgumentException("no pluralizer for locale: " + locale);
        }
        int form = pluralizer.get().apply(n);
        if (form > plurals.length) {
            throw new IllegalArgumentException("not enough plurals provided: " + form + ">" + plurals.length);
        }
        return plurals[form];
    }

    @Deprecated
    public static String pluralize(@NonNull String isoLocale, int n, String ... plurals) {
        if (isoLocale == null) {
            throw new NullPointerException("isoLocale is marked non-null but is null");
        }
        if (plurals == null) {
            throw new NullPointerException("plurals is marked non-null but is null");
        }
        Optional<Function<Integer, Integer>> pluralizer = Pluralize.getPluralizer(isoLocale);
        if (!pluralizer.isPresent()) {
            throw new IllegalArgumentException("no pluralizer for locale: " + isoLocale);
        }
        int form = pluralizer.get().apply(n);
        if (form > plurals.length) {
            throw new IllegalArgumentException("not enough plurals provided: " + form + ">" + plurals.length);
        }
        return plurals[form];
    }

    public static int plurals(@NonNull Locale locale) {
        Integer plurals;
        if (locale == null) {
            throw new NullPointerException("locale is marked non-null but is null");
        }
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if (!lang.isEmpty() && !country.isEmpty() && (plurals = PLURALS.get(lang + "_" + country)) != null) {
            return plurals;
        }
        plurals = PLURALS.get(lang);
        if (plurals == null) {
            throw new IllegalArgumentException("no plurals info for locale: " + locale);
        }
        return plurals;
    }

    @Deprecated
    public static int plurals(@NonNull String isoLocale) {
        if (isoLocale == null) {
            throw new NullPointerException("isoLocale is marked non-null but is null");
        }
        Integer plurals = PLURALS.get(isoLocale);
        if (plurals == null) {
            throw new IllegalArgumentException("no plurals info for locale: " + isoLocale);
        }
        return plurals;
    }

    static {
        Pluralize.add("ach", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("af", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ak", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("am", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("an", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("anp", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ar", 6, n -> n == 0 ? 0 : (n == 1 ? 1 : (n == 2 ? 2 : (n % 100 >= 3 && n % 100 <= 10 ? 3 : (n % 100 >= 11 ? 4 : 5)))));
        Pluralize.add("arn", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("as", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ast", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ay", 1, n -> 0);
        Pluralize.add("az", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("be", 3, n -> n % 10 == 1 && n % 100 != 11 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
        Pluralize.add("bg", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("bn", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("bo", 1, n -> 0);
        Pluralize.add("br", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("brx", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("bs", 3, n -> n % 10 == 1 && n % 100 != 11 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
        Pluralize.add("ca", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("cgg", 1, n -> 0);
        Pluralize.add("cs", 3, n -> n == 1 ? 0 : (n >= 2 && n <= 4 ? 1 : 2));
        Pluralize.add("csb", 3, n -> n == 1 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
        Pluralize.add("cy", 4, n -> n == 1 ? 0 : (n == 2 ? 1 : (n != 8 && n != 11 ? 2 : 3)));
        Pluralize.add("da", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("de", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("doi", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("dz", 1, n -> 0);
        Pluralize.add("el", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("en", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("eo", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("es", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("es_AR", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("et", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("eu", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("fa", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("ff", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("fi", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("fil", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("fo", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("fr", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("fur", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("fy", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ga", 5, n -> n == 1 ? 0 : (n == 2 ? 1 : (n > 2 && n < 7 ? 2 : (n > 6 && n < 11 ? 3 : 4))));
        Pluralize.add("gd", 4, n -> n == 1 || n == 11 ? 0 : (n == 2 || n == 12 ? 1 : (n > 2 && n < 20 ? 2 : 3)));
        Pluralize.add("gl", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("gu", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("gun", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("ha", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("he", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("hi", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("hne", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("hr", 3, n -> n % 10 == 1 && n % 100 != 11 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
        Pluralize.add("hu", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("hy", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ia", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("id", 1, n -> 0);
        Pluralize.add("is", 2, n -> n % 10 != 1 || n % 100 == 11 ? 1 : 0);
        Pluralize.add("it", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ja", 1, n -> 0);
        Pluralize.add("jbo", 1, n -> 0);
        Pluralize.add("jv", 2, n -> n == 0 ? 0 : 1);
        Pluralize.add("ka", 1, n -> 0);
        Pluralize.add("kk", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("kl", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("km", 1, n -> 0);
        Pluralize.add("kn", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ko", 1, n -> 0);
        Pluralize.add("ku", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("kw", 4, n -> n == 1 ? 0 : (n == 2 ? 1 : (n == 3 ? 2 : 3)));
        Pluralize.add("ky", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("lb", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ln", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("lo", 1, n -> 0);
        Pluralize.add("lt", 3, n -> n % 10 == 1 && n % 100 != 11 ? 0 : (n % 10 >= 2 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
        Pluralize.add("lv", 3, n -> n % 10 == 1 && n % 100 != 11 ? 0 : (n != 0 ? 1 : 2));
        Pluralize.add("mai", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("me", 3, n -> n % 10 == 1 && n % 100 != 11 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
        Pluralize.add("mfe", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("mg", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("mi", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("ml", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("mn", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("mni", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("mnk", 3, n -> n == 0 ? 0 : (n == 1 ? 1 : 2));
        Pluralize.add("mr", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ms", 1, n -> 0);
        Pluralize.add("mt", 4, n -> n == 1 ? 0 : (n == 0 || n % 100 > 1 && n % 100 < 11 ? 1 : (n % 100 > 10 && n % 100 < 20 ? 2 : 3)));
        Pluralize.add("my", 1, n -> 0);
        Pluralize.add("nah", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("nap", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("nb", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ne", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("nl", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("nn", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("no", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("nso", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("oc", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("or", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("pa", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("pap", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("pl", 3, n -> n == 1 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
        Pluralize.add("pms", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ps", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("pt", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("pt_BR", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("rm", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ro", 3, n -> n == 1 ? 0 : (n == 0 || n % 100 > 0 && n % 100 < 20 ? 1 : 2));
        Pluralize.add("ru", 3, n -> n % 10 == 1 && n % 100 != 11 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
        Pluralize.add("rw", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("sah", 1, n -> 0);
        Pluralize.add("sat", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("sco", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("sd", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("se", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("si", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("sk", 3, n -> n == 1 ? 0 : (n >= 2 && n <= 4 ? 1 : 2));
        Pluralize.add("sl", 4, n -> n % 100 == 1 ? 0 : (n % 100 == 2 ? 1 : (n % 100 == 3 || n % 100 == 4 ? 2 : 3)));
        Pluralize.add("so", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("son", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("sq", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("sr", 3, n -> n % 10 == 1 && n % 100 != 11 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
        Pluralize.add("su", 1, n -> 0);
        Pluralize.add("sv", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("sw", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("ta", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("te", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("tg", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("th", 1, n -> 0);
        Pluralize.add("ti", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("tk", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("tr", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("tt", 1, n -> 0);
        Pluralize.add("ug", 1, n -> 0);
        Pluralize.add("uk", 3, n -> n % 10 == 1 && n % 100 != 11 ? 0 : (n % 10 >= 2 && n % 10 <= 4 && (n % 100 < 10 || n % 100 >= 20) ? 1 : 2));
        Pluralize.add("ur", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("uz", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("vi", 1, n -> 0);
        Pluralize.add("wa", 2, n -> n > 1 ? 1 : 0);
        Pluralize.add("wo", 1, n -> 0);
        Pluralize.add("yo", 2, n -> n == 1 ? 0 : 1);
        Pluralize.add("zh", 1, n -> 0);
    }
}

