/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.libs.eu.okaeri.validator.provider;

import com.epicplayera10.optimizationutils.libs.eu.okaeri.validator.ConstraintViolation;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.validator.annotation.NotNull;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.validator.annotation.Nullable;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.validator.exception.ValidatorException;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.validator.policy.NullPolicy;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.validator.provider.ValidationProvider;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class NotNullProvider
implements ValidationProvider<NotNull> {
    private final NullPolicy nullPolicy;

    @Override
    public Class<NotNull> getAnnotation() {
        return NotNull.class;
    }

    @Override
    public boolean shouldValidate(Object target) {
        return true;
    }

    @Override
    public Set<ConstraintViolation> validate(@NotNull NotNull notNull, @Nullable Object annotationSource, @Nullable Object value, @NotNull Class<?> type, @NotNull Type genericType, @NotNull String name) {
        Boolean canBeNull = null;
        Nullable nullable = this.extractAnnotation(annotationSource, Nullable.class);
        if (notNull == null) {
            if (this.nullPolicy == NullPolicy.NOT_NULL) {
                canBeNull = nullable == null ? Boolean.valueOf(false) : Boolean.valueOf(true);
            } else if (this.nullPolicy == NullPolicy.NULLABLE) {
                canBeNull = true;
            }
        } else {
            canBeNull = false;
        }
        if (canBeNull == null) {
            throw new ValidatorException("unexpected case for @NotNull @Nullable and NullPolicy occured");
        }
        if (canBeNull.booleanValue() || value != null) {
            return Collections.emptySet();
        }
        String message = notNull != null ? notNull.message() : "value cannot be null";
        LinkedHashSet<ConstraintViolation> violations = new LinkedHashSet<ConstraintViolation>();
        violations.add(new ConstraintViolation(name, message, this.getType()));
        return violations;
    }

    public NotNullProvider(NullPolicy nullPolicy) {
        this.nullPolicy = nullPolicy;
    }
}

