/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.manager;

import com.epicplayera10.optimizationutils.manager.ReflectionUtils;
import io.papermc.paper.configuration.WorldConfiguration;
import io.papermc.paper.configuration.type.DespawnRange;
import io.papermc.paper.configuration.type.number.IntOr;
import java.util.OptionalInt;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EnumCreatureType;
import org.bukkit.World;
import org.spongepowered.configurate.serialize.SerializationException;

public class SimulationDistanceManager {
    public static void setNMSSimulationDistance(World world, int newSimulationDistance) {
        int configBasedSimulationDistance = Math.min(newSimulationDistance, 9);
        WorldServer serverLevel = ReflectionUtils.getNMSWorld(world);
        serverLevel.spigotConfig.mobSpawnRange = (byte)Math.max(3, Math.min(8, configBasedSimulationDistance - 1));
        WorldConfiguration.Entities.Spawning.DespawnRangePair oldDespawnRangePair = (WorldConfiguration.Entities.Spawning.DespawnRangePair)serverLevel.paperConfig().entities.spawning.despawnRanges.get(EnumCreatureType.a);
        IntOr.Default horizontalLimit = new IntOr.Default(OptionalInt.of((configBasedSimulationDistance - 1) * 16));
        IntOr.Default verticalLimit = ReflectionUtils.getDespawnRangesVerticalLimit(oldDespawnRangePair.hard());
        serverLevel.paperConfig().entities.spawning.despawnRanges.replace(EnumCreatureType.a, new WorldConfiguration.Entities.Spawning.DespawnRangePair(new DespawnRange(horizontalLimit, verticalLimit, true), oldDespawnRangePair.soft()));
        try {
            serverLevel.paperConfig().entities.spawning.precomputeDespawnDistances();
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }
}

