/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.manager;

import com.epicplayera10.optimizationutils.OptimizationUtils;
import com.epicplayera10.optimizationutils.config.model.MsptCalculationMode;
import org.bukkit.Bukkit;
import org.bukkit.World;

public class ThrottleUtils {
    private static long lastLogTime = -1L;

    public static boolean shouldThrottle(World world, float msptThreshold, String action) {
        double currentMspt = ThrottleUtils.getMspt();
        if (currentMspt > (double)msptThreshold) {
            if (lastLogTime == -1L || System.currentTimeMillis() - lastLogTime > 10000L) {
                lastLogTime = System.currentTimeMillis();
                OptimizationUtils.instance().getLogger().info("Server is overloaded (" + currentMspt + "ms), throttling " + action + ". Entities count: " + world.getEntityCount());
            }
            return true;
        }
        return false;
    }

    public static double getMspt() {
        return switch (OptimizationUtils.instance().pluginConfiguration().msptCalculationMode) {
            default -> throw new MatchException(null, null);
            case MsptCalculationMode.AVERAGE_5S -> Bukkit.getAverageTickTime();
            case MsptCalculationMode.LAST_TICK -> {
                int lastTick = Bukkit.getCurrentTick() - 1;
                if (lastTick < 0) {
                    yield 0.0;
                }
                long currentMsptNanos = Bukkit.getTickTimes()[lastTick % Bukkit.getTickTimes().length];
                yield (double)currentMsptNanos / 1000000.0;
            }
        };
    }
}

