/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils;

import com.epicplayera10.optimizationutils.commands.OptimizationUtilsCommand;
import com.epicplayera10.optimizationutils.config.ConfigurationFactory;
import com.epicplayera10.optimizationutils.config.DataConfiguration;
import com.epicplayera10.optimizationutils.config.PluginConfiguration;
import com.epicplayera10.optimizationutils.libs.acf.PaperCommandManager;
import com.epicplayera10.optimizationutils.libs.org.bstats.bukkit.Metrics;
import com.epicplayera10.optimizationutils.listeners.EntityListener;
import com.epicplayera10.optimizationutils.manager.ThrottleUtils;
import java.io.File;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class OptimizationUtils
extends JavaPlugin {
    private PluginConfiguration pluginConfiguration;
    private DataConfiguration dataConfiguration;
    private static OptimizationUtils instance;

    public void onEnable() {
        instance = this;
        this.setupMetrics();
        this.pluginConfiguration = ConfigurationFactory.createPluginConfiguration(new File(this.getDataFolder(), "config.yml"));
        this.dataConfiguration = ConfigurationFactory.createDataConfiguration(new File(this.getDataFolder(), "data.yml"));
        this.restoreOriginalRandomTickSpeeds();
        Bukkit.getPluginManager().registerEvents((Listener)new EntityListener(), (Plugin)this);
        this.registerCommands();
        Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> {
            if (!this.pluginConfiguration().dynamicRandomTickSpeed.enabled) {
                return;
            }
            for (World world : Bukkit.getWorlds()) {
                if (ThrottleUtils.shouldThrottle(world, this.pluginConfiguration().dynamicRandomTickSpeed.msptThreshold, "RandomTickSpeed")) {
                    int currentRandomTickSpeed = (Integer)world.getGameRuleValue(GameRule.RANDOM_TICK_SPEED);
                    if (!this.dataConfiguration().originalRandomTickSpeeds.containsKey(world.getName())) {
                        if (this.pluginConfiguration().debug) {
                            this.getLogger().info("Storing original random tick speed for world " + world.getName() + ": " + currentRandomTickSpeed);
                        }
                        this.dataConfiguration().originalRandomTickSpeeds.put(world.getName(), currentRandomTickSpeed);
                        this.dataConfiguration().save();
                    } else if (currentRandomTickSpeed != 0) {
                        if (this.pluginConfiguration().debug) {
                            this.getLogger().info("Updating original random tick speed for world " + world.getName() + ": " + currentRandomTickSpeed);
                        }
                        this.dataConfiguration().originalRandomTickSpeeds.put(world.getName(), currentRandomTickSpeed);
                        this.dataConfiguration().save();
                    }
                    world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)0);
                    continue;
                }
                if (!this.dataConfiguration().originalRandomTickSpeeds.containsKey(world.getName())) continue;
                if (this.pluginConfiguration().debug) {
                    this.getLogger().info("Restoring original random tick speed for world " + world.getName() + ": " + String.valueOf(this.dataConfiguration().originalRandomTickSpeeds.get(world.getName())));
                }
                int originalRandomTickSpeed = this.dataConfiguration().originalRandomTickSpeeds.get(world.getName());
                world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)originalRandomTickSpeed);
                this.dataConfiguration().originalRandomTickSpeeds.remove(world.getName());
                this.dataConfiguration().save();
            }
        }, 1L, 1L);
    }

    public void onDisable() {
        this.restoreOriginalRandomTickSpeeds();
    }

    private void restoreOriginalRandomTickSpeeds() {
        for (Map.Entry<String, Integer> entry : this.dataConfiguration().originalRandomTickSpeeds.entrySet()) {
            World world = Bukkit.getWorld((String)entry.getKey());
            if (world == null) continue;
            world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)entry.getValue());
        }
        this.dataConfiguration().originalRandomTickSpeeds.clear();
        this.dataConfiguration().save();
    }

    private void registerCommands() {
        PaperCommandManager manager = new PaperCommandManager((Plugin)this);
        manager.enableUnstableAPI("help");
        manager.registerCommand(new OptimizationUtilsCommand());
    }

    private void setupMetrics() {
        int pluginId = 26099;
        Metrics metrics = new Metrics(this, pluginId);
    }

    public static OptimizationUtils instance() {
        return instance;
    }

    public PluginConfiguration pluginConfiguration() {
        return this.pluginConfiguration;
    }

    public DataConfiguration dataConfiguration() {
        return this.dataConfiguration;
    }

    public void reloadConfiguration() {
        this.pluginConfiguration.load();
        this.dataConfiguration.load();
    }
}

