/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.libs.acf;

import com.epicplayera10.optimizationutils.libs.acf.ACFPatterns;
import com.epicplayera10.optimizationutils.libs.acf.BaseCommand;
import com.epicplayera10.optimizationutils.libs.acf.CommandExecutionContext;
import com.epicplayera10.optimizationutils.libs.acf.CommandIssuer;
import com.epicplayera10.optimizationutils.libs.acf.CommandManager;
import com.epicplayera10.optimizationutils.libs.acf.CommandOperationContext;
import com.epicplayera10.optimizationutils.libs.acf.ConditionContext;
import com.epicplayera10.optimizationutils.libs.acf.InvalidCommandArgument;
import com.epicplayera10.optimizationutils.libs.acf.LogLevel;
import com.epicplayera10.optimizationutils.libs.acf.RegisteredCommand;
import com.epicplayera10.optimizationutils.libs.acf.lib.util.Table;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CommandConditions<I extends CommandIssuer, CEC extends CommandExecutionContext<CEC, I>, CC extends ConditionContext<I>> {
    private CommandManager manager;
    private Map<String, Condition<I>> conditions = new HashMap<String, Condition<I>>();
    private Table<Class<?>, String, ParameterCondition<?, ?, ?>> paramConditions = new Table();

    CommandConditions(CommandManager manager) {
        this.manager = manager;
    }

    public Condition<I> addCondition(@NotNull String id, @NotNull Condition<I> handler) {
        return this.conditions.put(id.toLowerCase(Locale.ENGLISH), handler);
    }

    public <P> ParameterCondition addCondition(Class<P> clazz, @NotNull String id, @NotNull ParameterCondition<P, CEC, I> handler) {
        return this.paramConditions.put(clazz, id.toLowerCase(Locale.ENGLISH), handler);
    }

    void validateConditions(CommandOperationContext context) throws InvalidCommandArgument {
        RegisteredCommand cmd = context.getRegisteredCommand();
        this.validateConditions(cmd.conditions, context);
        this.validateConditions(cmd.scope, context);
    }

    private void validateConditions(BaseCommand scope, CommandOperationContext operationContext) throws InvalidCommandArgument {
        this.validateConditions(scope.conditions, operationContext);
        if (scope.parentCommand != null) {
            this.validateConditions(scope.parentCommand, operationContext);
        }
    }

    private void validateConditions(String conditions, CommandOperationContext context) throws InvalidCommandArgument {
        if (conditions == null) {
            return;
        }
        conditions = this.manager.getCommandReplacements().replace(conditions);
        Object issuer = context.getCommandIssuer();
        for (String cond : ACFPatterns.PIPE.split(conditions)) {
            String[] split = ACFPatterns.COLON.split(cond, 2);
            String id = split[0].toLowerCase(Locale.ENGLISH);
            Condition<I> condition = this.conditions.get(id);
            if (condition == null) {
                RegisteredCommand cmd = context.getRegisteredCommand();
                this.manager.log(LogLevel.ERROR, "Could not find command condition " + id + " for " + cmd.method.getName());
                continue;
            }
            String config = split.length == 2 ? split[1] : null;
            ConditionContext conditionContext = this.manager.createConditionContext((CommandIssuer)issuer, config);
            condition.validateCondition(conditionContext);
        }
    }

    void validateConditions(CEC execContext, Object value) throws InvalidCommandArgument {
        String conditions = ((CommandExecutionContext)execContext).getCommandParameter().getConditions();
        if (conditions == null) {
            return;
        }
        conditions = this.manager.getCommandReplacements().replace(conditions);
        Object issuer = ((CommandExecutionContext)execContext).getIssuer();
        for (String cond : ACFPatterns.PIPE.split(conditions)) {
            ParameterCondition<?, ?, ?> condition;
            String[] split = ACFPatterns.COLON.split(cond, 2);
            Class<?> cls = ((CommandExecutionContext)execContext).getParam().getType();
            String id = split[0].toLowerCase(Locale.ENGLISH);
            while ((condition = this.paramConditions.get(cls, id)) == null && cls.getSuperclass() != null && cls.getSuperclass() != Object.class && (cls = cls.getSuperclass()) != null) {
            }
            if (condition == null) {
                RegisteredCommand cmd = ((CommandExecutionContext)execContext).getCmd();
                this.manager.log(LogLevel.ERROR, "Could not find command condition " + id + " for " + cmd.method.getName() + "::" + ((CommandExecutionContext)execContext).getParam().getName());
                continue;
            }
            String config = split.length == 2 ? split[1] : null;
            ConditionContext conditionContext = this.manager.createConditionContext((CommandIssuer)issuer, config);
            condition.validateCondition(conditionContext, execContext, value);
        }
    }

    public static interface Condition<I extends CommandIssuer> {
        public void validateCondition(ConditionContext<I> var1) throws InvalidCommandArgument;
    }

    public static interface ParameterCondition<P, CEC extends CommandExecutionContext, I extends CommandIssuer> {
        public void validateCondition(ConditionContext<I> var1, CEC var2, P var3) throws InvalidCommandArgument;
    }
}

