/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.yaml.bukkit.serdes.transformer;

import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.exception.OkaeriException;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.schema.GenericsPair;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.serdes.BidirectionalTransformer;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.configs.serdes.SerdesContext;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.potion.PotionEffectType;

public class StringPotionEffectTypeTransformer
extends BidirectionalTransformer<String, PotionEffectType> {
    private static Map<String, PotionEffectType> byName = new HashMap<String, PotionEffectType>();

    @Override
    public GenericsPair<String, PotionEffectType> getPair() {
        return this.genericsPair(String.class, PotionEffectType.class);
    }

    @Override
    public PotionEffectType leftToRight(@NonNull String data, @NonNull SerdesContext serdesContext) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (serdesContext == null) {
            throw new NullPointerException("serdesContext is marked non-null but is null");
        }
        PotionEffectType potionEffectType = PotionEffectType.getByName((String)data);
        if (potionEffectType == null) {
            if (byName.isEmpty()) {
                for (PotionEffectType p : PotionEffectType.values()) {
                    byName.put(p.getName().toUpperCase(Locale.ROOT), p);
                }
            }
            potionEffectType = byName.get(data.toUpperCase(Locale.ROOT));
        }
        if (potionEffectType == null) {
            String available = Arrays.stream(PotionEffectType.values()).map(PotionEffectType::getName).collect(Collectors.joining(", "));
            throw new OkaeriException("Unknown potion effect type: " + data + " (Available: " + available + ")");
        }
        return potionEffectType;
    }

    @Override
    public String rightToLeft(@NonNull PotionEffectType data, @NonNull SerdesContext serdesContext) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (serdesContext == null) {
            throw new NullPointerException("serdesContext is marked non-null but is null");
        }
        return data.getName();
    }
}

