/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders;

import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.DefaultPlaceholderPack;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.PlaceholderPack;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.context.PlaceholderContext;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.message.CompiledMessage;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.message.part.MessageField;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.schema.resolver.PlaceholderResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class Placeholders {
    private Map<Class<?>, Map<String, PlaceholderResolver>> resolvers = new LinkedHashMap();
    private List<Class<?>> resolversOrdered = new ArrayList();
    private PlaceholderResolver fallbackResolver = null;
    private boolean fastMode = true;

    public static Placeholders create() {
        return Placeholders.create(false);
    }

    public static Placeholders create(boolean registerDefaults) {
        Placeholders placeholders = new Placeholders();
        if (registerDefaults) {
            placeholders.registerPlaceholders(new DefaultPlaceholderPack());
        }
        return placeholders;
    }

    public PlaceholderContext contextOf(@NonNull CompiledMessage message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        return PlaceholderContext.of(this, message);
    }

    public Placeholders fallbackResolver(PlaceholderResolver fallbackResolver) {
        this.fallbackResolver = fallbackResolver;
        return this;
    }

    public Placeholders fastMode(boolean fastMode) {
        this.fastMode = fastMode;
        return this;
    }

    public Placeholders registerPlaceholders(@NonNull PlaceholderPack pack) {
        if (pack == null) {
            throw new NullPointerException("pack is marked non-null but is null");
        }
        pack.register(this);
        return this;
    }

    public void setResolvers(@NonNull Map<Class<?>, Map<String, PlaceholderResolver>> resolvers) {
        if (resolvers == null) {
            throw new NullPointerException("resolvers is marked non-null but is null");
        }
        this.resolvers = resolvers;
        ArrayList keys = new ArrayList(resolvers.keySet());
        Collections.reverse(keys);
        this.resolversOrdered = keys;
    }

    public <T> Placeholders registerPlaceholder(@NonNull Class<T> type, @NonNull PlaceholderResolver<T> resolver) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (resolver == null) {
            throw new NullPointerException("resolver is marked non-null but is null");
        }
        if (!this.resolvers.containsKey(type)) {
            this.resolvers.put(type, new HashMap());
            this.resolversOrdered.add(0, type);
        }
        Map<String, PlaceholderResolver> resolverMap = this.resolvers.get(type);
        resolverMap.put(null, resolver);
        return this;
    }

    public <T> Placeholders registerPlaceholder(@NonNull Class<T> type, @NonNull String name, @NonNull PlaceholderResolver<T> resolver) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (resolver == null) {
            throw new NullPointerException("resolver is marked non-null but is null");
        }
        if (!this.resolvers.containsKey(type)) {
            this.resolvers.put(type, new HashMap());
            this.resolversOrdered.add(0, type);
        }
        Map<String, PlaceholderResolver> resolverMap = this.resolvers.get(type);
        resolverMap.put(name, resolver);
        return this;
    }

    @Deprecated
    public Object readValue(@NonNull Object from) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        PlaceholderResolver placeholderResolver = this.getResolver(from, null);
        if (placeholderResolver != null) {
            return placeholderResolver.resolve(from, MessageField.unknown(), null);
        }
        throw new IllegalArgumentException("cannot find resolver for " + from.getClass());
    }

    @Deprecated
    public Object readValue(@NonNull Object from, @Nullable String param) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        PlaceholderResolver placeholderResolver = this.getResolver(from, param);
        if (placeholderResolver != null) {
            return placeholderResolver.resolve(from, MessageField.unknown(), null);
        }
        throw new IllegalArgumentException("cannot find resolver for " + from.getClass() + ": " + param);
    }

    public PlaceholderResolver getResolver(@NonNull Object from, @Nullable String param) {
        PlaceholderResolver resolver;
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        Class<?> fromClass = from.getClass();
        Map<String, PlaceholderResolver> resolverMap = this.resolvers.get(fromClass);
        if (resolverMap != null && (resolver = resolverMap.get(param)) != null) {
            return resolver;
        }
        resolver = this.findResolverOrNull(from, param);
        if (resolver != null) {
            return resolver;
        }
        return this.fallbackResolver;
    }

    public PlaceholderResolver findResolverOrNull(@NonNull Object from, @Nullable String param) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        for (Class<?> potentialType : this.resolversOrdered) {
            Map<String, PlaceholderResolver> resolverMap;
            PlaceholderResolver resolver;
            if (!potentialType.isAssignableFrom(from.getClass()) || (resolver = (resolverMap = this.resolvers.get(potentialType)).get(param)) == null) continue;
            return resolver;
        }
        return null;
    }

    public int getResolversCount() {
        return Math.toIntExact(this.resolvers.values().stream().mapToLong(map -> map.entrySet().size()).sum());
    }

    public Placeholders copy() {
        Placeholders placeholders = new Placeholders();
        placeholders.setResolvers(this.getResolversCopy());
        placeholders.fallbackResolver = this.getFallbackResolver();
        return placeholders;
    }

    public Map<Class<?>, Map<String, PlaceholderResolver>> getResolversCopy() {
        LinkedHashMap resolvers = new LinkedHashMap();
        for (Map.Entry<Class<?>, Map<String, PlaceholderResolver>> entry : this.resolvers.entrySet()) {
            HashMap<String, PlaceholderResolver> map = new HashMap<String, PlaceholderResolver>();
            map.putAll(entry.getValue());
            resolvers.put(entry.getKey(), map);
        }
        return resolvers;
    }

    private Placeholders() {
    }

    public PlaceholderResolver getFallbackResolver() {
        return this.fallbackResolver;
    }

    public boolean isFastMode() {
        return this.fastMode;
    }
}

