/*
 * Decompiled with CFR 0.152.
 */
package com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.schema.resolver;

import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.message.part.MessageField;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.placeholders.schema.resolver.SchemaResolver;
import com.epicplayera10.optimizationutils.libs.eu.okaeri.pluralize.Pluralize;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;

public class DefaultSchemaResolver
implements SchemaResolver {
    public static final SchemaResolver INSTANCE = new DefaultSchemaResolver();
    private static final Set<Class<?>> SUPPORTED_TYPES = new HashSet<Class>(Arrays.asList(BigDecimal.class, BigInteger.class, Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Double.class, Double.TYPE, Float.class, Float.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, String.class, UUID.class, Instant.class));

    @Override
    public boolean supports(@NonNull Class<?> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return SUPPORTED_TYPES.contains(type) || type.isEnum();
    }

    @Override
    public String resolve(@NonNull Object object, @NonNull MessageField field) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        if (field.getMetadataRaw() != null && object instanceof Number && field.getMetadataRaw().length() > 1 && field.getMetadataRaw().charAt(0) == '%') {
            double doubleValue = new BigDecimal(String.valueOf(object)).doubleValue();
            return String.format(field.getLocale(), field.getMetadataRaw(), doubleValue);
        }
        if (field.getMetadataOptions() != null && object instanceof Number) {
            int intValue = new BigDecimal(String.valueOf(object)).intValue();
            try {
                if (field.getMetadataOptions().length == Pluralize.plurals(field.getLocale())) {
                    return Pluralize.pluralize(field.getLocale(), intValue, field.getMetadataOptions());
                }
            }
            catch (IllegalArgumentException exception) {
                try {
                    return Pluralize.pluralize(Locale.ENGLISH, intValue, field.getMetadataOptions());
                }
                catch (IllegalArgumentException exception1) {
                    return field.getMetadataOptions()[0];
                }
            }
        }
        if (field.getMetadataOptions() != null && object instanceof Boolean && field.getMetadataOptions().length == 2) {
            return (Boolean)object != false ? field.getMetadataOptions()[0] : field.getMetadataOptions()[1];
        }
        if (field.getMetadataRaw() != null && object instanceof Instant) {
            DateTimeFormatter formatter;
            String[] metadataOptions = field.getMetadataOptions();
            String rawFormat = metadataOptions[0].toUpperCase(Locale.ROOT);
            FormatStyle style = null;
            String pattern = null;
            if ("P".equals(rawFormat)) {
                if (metadataOptions.length < 2) {
                    throw new IllegalArgumentException("The pattern formatter ('P') requires a pattern as a second metadata option.");
                }
                pattern = metadataOptions[1];
            } else {
                style = metadataOptions.length >= 2 ? FormatStyle.valueOf(metadataOptions[1].toUpperCase(Locale.ROOT)) : FormatStyle.SHORT;
            }
            switch (rawFormat) {
                case "LT": {
                    formatter = DateTimeFormatter.ofLocalizedTime(style);
                    break;
                }
                case "LDT": {
                    formatter = DateTimeFormatter.ofLocalizedDateTime(style);
                    break;
                }
                case "LD": {
                    formatter = DateTimeFormatter.ofLocalizedDate(style);
                    break;
                }
                case "P": {
                    formatter = DateTimeFormatter.ofPattern(pattern);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown time formatter: " + rawFormat);
                }
            }
            ZoneId zone = field.getMetadataRaw() == null || field.getMetadataOptions().length < 3 ? ZoneId.systemDefault() : ZoneId.of(metadataOptions[2]);
            return formatter.withLocale(field.getLocale()).withZone(zone).format((TemporalAccessor)object);
        }
        return this.resolve(object);
    }

    @Override
    public String resolve(@NonNull Object object) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (object instanceof Enum) {
            return ((Enum)object).name();
        }
        if (object instanceof Float || object instanceof Double) {
            return String.format("%.2f", object);
        }
        return object.toString();
    }
}

