/*
 * Decompiled with CFR 0.152.
 */
package xyz.bonfiremc.windy.mixin;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.bonfiremc.windy.WindyConfig;
import xyz.bonfiremc.windy.WindyParticles;

@Mixin(value={ClientLevel.class})
public abstract class ClientLevelMixin {
    @Shadow
    public abstract void addParticle(ParticleOptions var1, double var2, double var4, double var6, double var8, double var10, double var12);

    @Inject(method={"doAnimateTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientLevel;getBiome(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/core/Holder;")})
    public void windy$spawnWind(int posX, int posY, int posZ, int range, RandomSource random, Block block, BlockPos.MutableBlockPos blockPos, CallbackInfo ci) {
        ClientLevel world = (ClientLevel)this;
        if (world.dimension() != Level.OVERWORLD) {
            return;
        }
        WindyConfig config = (WindyConfig)WindyConfig.HANDLER.instance();
        if (!config.spawnWind || blockPos.getY() < config.minimumWindHeight) {
            return;
        }
        if (config.windMustSeeSky && !world.canSeeSky((BlockPos)blockPos)) {
            return;
        }
        if (random.nextDouble() * 100.0 <= config.windFrequency * 0.015) {
            SimpleParticleType particle = WindyParticles.WIND.get();
            if (world.isThundering()) {
                if (random.nextDouble() <= 0.8) {
                    particle = WindyParticles.STRONG_WIND.get();
                }
            } else if (world.isRaining() && random.nextDouble() <= 0.5) {
                particle = WindyParticles.STRONG_WIND.get();
            }
            this.addParticle((ParticleOptions)particle, (double)blockPos.getX() + random.nextDouble(), (double)blockPos.getY() + random.nextDouble(), (double)blockPos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }
}

